/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDAttribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDValidatorBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DefaultAttrValue;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.XMLStreamException;

public final class DTDNmTokensAttr
extends DTDAttribute {
    public DTDNmTokensAttr(PrefixedName prefixedName, DefaultAttrValue defaultAttrValue, int n2, boolean bl2, boolean bl3) {
        super(prefixedName, defaultAttrValue, n2, bl2, bl3);
    }

    @Override
    public DTDAttribute cloneWith(int n2) {
        return new DTDNmTokensAttr(this.mName, this.mDefValue, n2, this.mCfgNsAware, this.mCfgXml11);
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String validate(DTDValidatorBase dTDValidatorBase, char[] cArray, int n2, int n3, boolean bl2) throws XMLStreamException {
        while (n2 < n3 && WstxInputData.isSpaceChar(cArray[n2])) {
            ++n2;
        }
        if (n2 >= n3) {
            return this.reportValidationProblem(dTDValidatorBase, "Empty NMTOKENS value");
        }
        if (!bl2) {
            while (n2 < n3) {
                char c2 = cArray[n2];
                if (!WstxInputData.isSpaceChar(c2) && !WstxInputData.isNameChar(c2, this.mCfgNsAware, this.mCfgXml11)) {
                    return this.reportInvalidChar(dTDValidatorBase, c2, "not valid as NMTOKENS character");
                }
                ++n2;
            }
            return null;
        }
        --n3;
        while (n3 > n2 && WstxInputData.isSpaceChar(cArray[n3])) {
            --n3;
        }
        StringBuilder stringBuilder = null;
        while (n2 <= n3) {
            char c3;
            int n4;
            for (n4 = n2; n4 <= n3 && !WstxInputData.isSpaceChar(c3 = cArray[n4]); ++n4) {
                if (WstxInputData.isNameChar(c3, this.mCfgNsAware, this.mCfgXml11)) continue;
                return this.reportInvalidChar(dTDValidatorBase, c3, "not valid as an NMTOKENS character");
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n3 - n2 + 1);
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(cArray, n2, n4 - n2);
            for (n2 = n4 + 1; n2 <= n3 && WstxInputData.isSpaceChar(cArray[n2]); ++n2) {
            }
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    @Override
    public void validateDefault(InputProblemReporter inputProblemReporter, boolean bl2) throws XMLStreamException {
        String string = this.mDefValue.getValue();
        int n2 = string.length();
        StringBuilder stringBuilder = null;
        int n3 = 0;
        int n4 = 0;
        block0: while (n4 < n2) {
            char c2 = string.charAt(n4);
            while (WstxInputData.isSpaceChar(c2)) {
                if (++n4 >= n2) break block0;
                c2 = string.charAt(n4);
            }
            int n5 = n4 + 1;
            while (++n5 < n2 && !WstxInputData.isSpaceChar(c2 = string.charAt(n5))) {
            }
            ++n3;
            String string2 = string.substring(n4, n5);
            int n6 = WstxInputData.findIllegalNmtokenChar(string2, this.mCfgNsAware, this.mCfgXml11);
            if (n6 >= 0) {
                this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string + "'; character #" + n6 + " (" + WstxInputData.getCharDesc(string.charAt(n6)) + ") not a valid NMTOKENS character");
            }
            if (bl2) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n5 - n4 + 32);
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string2);
            }
            n4 = n5 + 1;
        }
        if (n3 == 0) {
            this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string + "'; empty String is not a valid NMTOKENS value");
            return;
        }
        if (stringBuilder != null) {
            this.mDefValue.setValue(stringBuilder.toString());
        }
    }
}

