/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testacceleration.client.selection.coverage;

import com.gradle.enterprise.testacceleration.client.api.TestSelectionException;
import com.gradle.enterprise.testacceleration.client.b.l;
import com.gradle.enterprise.testacceleration.client.selection.b;
import com.gradle.enterprise.testacceleration.client.selection.coverage.CodeCoverageDownloadException;
import com.gradle.enterprise.testacceleration.client.selection.coverage.c;
import com.gradle.enterprise.testacceleration.client.selection.coverage.f;
import com.gradle.enterprise.testacceleration.client.selection.z;
import com.gradle.enterprise.testselection.common.a.d;
import com.gradle.enterprise.testselection.common.model.api.base.DownloadPartialCodeCoverageResponse;
import com.gradle.enterprise.testselection.common.model.api.base.InputFingerprint;
import com.gradle.enterprise.testselection.common.model.api.base.PublicBuildId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Failsafe;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.RetryPolicy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.RetryPolicyBuilder;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.CloseableHttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpUriRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.RequestBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.CloseableHttpClient;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements f {
    private static final Logger b = LoggerFactory.getLogger(a.class);
    private final z c;
    private final CloseableHttpClient d;
    private final com.gradle.enterprise.testacceleration.client.connector.f e;
    private final ExecutorService f;
    private final SmileMapper g = com.gradle.enterprise.testselection.common.a.d.a();
    private final ObjectMapper h = com.gradle.enterprise.testselection.common.a.d.b();
    private final ConcurrentMap<l, Collection<CompletableFuture<Void>>> i = new ConcurrentHashMap<l, Collection<CompletableFuture<Void>>>();

    public a(z z2, CloseableHttpClient closeableHttpClient, com.gradle.enterprise.testacceleration.client.connector.f f2) {
        this.c = z2;
        this.d = closeableHttpClient;
        this.e = f2;
        ThreadFactory threadFactory = com.gradle.enterprise.java.c.c.a("pts-code-coverage-downloader-%s", 1);
        this.f = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    public void a(com.gradle.enterprise.testacceleration.client.selection.coverage.b b2, com.gradle.enterprise.testacceleration.client.output.b b3) {
        this.i.computeIfAbsent(b2.c(), l2 -> b2.b().stream().map(list -> this.a(b2.a(), (List<PublicBuildId>)list, (l)l2, b2.d(), b3, b2.e())).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> a(Path path, List<PublicBuildId> list, l l2, InputFingerprint inputFingerprint, com.gradle.enterprise.testacceleration.client.output.b b2, c c2) {
        return this.a(list, l2, inputFingerprint, c2).handle((downloadPartialCodeCoverageResponse, throwable) -> {
            if (throwable != null) {
                throw com.gradle.enterprise.java.g.f.a(throwable);
            }
            downloadPartialCodeCoverageResponse.getPartialCoverageData().forEach(partialCoverageData -> {
                try {
                    b2.a(path, partialCoverageData.getBuildId().getValue(), partialCoverageData.getCoverageData());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            });
            return null;
        });
    }

    private CompletableFuture<DownloadPartialCodeCoverageResponse> a(List<PublicBuildId> list, l l2, InputFingerprint inputFingerprint, c c2) {
        return CompletableFuture.supplyAsync(() -> {
            String string = Base64.getUrlEncoder().encodeToString(inputFingerprint.getBytes());
            HttpUriRequest httpUriRequest = this.a(list, l2, string, c2.a());
            try (CloseableHttpResponse closeableHttpResponse = this.a(httpUriRequest, list, l2, string, c2.b(), c2.c());){
                DownloadPartialCodeCoverageResponse downloadPartialCodeCoverageResponse;
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                try {
                    downloadPartialCodeCoverageResponse = this.a(statusLine, httpEntity);
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly(httpEntity);
                    throw throwable;
                }
                EntityUtils.consumeQuietly(httpEntity);
                return downloadPartialCodeCoverageResponse;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }, this.f);
    }

    private CloseableHttpResponse a(HttpUriRequest httpUriRequest, List<PublicBuildId> list, l l2, String string, Duration duration, Duration duration2) throws IOException {
        if (b.isDebugEnabled()) {
            b.debug("Requesting partial code coverage for builds {}, project {}, test target {} and input fingerprint {} with request ID {}", new Object[]{list.stream().map(PublicBuildId::getValue).collect(Collectors.joining(", ")), l2.a(), l2.b(), string, httpUriRequest.getFirstHeader("X-Request-Id").getValue()});
        }
        return Failsafe.with(((RetryPolicyBuilder)com.gradle.enterprise.testdistribution.common.client.a.a().withMaxRetries(-1).withMaxDuration(duration2).withDelay(duration)).onRetry(a::a).build(), (Policy[])new RetryPolicy[0]).get(() -> this.d.execute(httpUriRequest));
    }

    private static void a(ExecutionAttemptedEvent<CloseableHttpResponse> executionAttemptedEvent) {
        b.warn("Retrying code coverage download request, because: {}", (Object)executionAttemptedEvent.getLastException().getMessage());
    }

    private HttpUriRequest a(List<PublicBuildId> list, l l2, String string2, Duration duration) {
        URI uRI = this.c.g().resolve("/predictive-test-selection/coverage");
        RequestBuilder requestBuilder = RequestBuilder.get(uRI).addHeader("Accept", String.join((CharSequence)", ", "application/x-jackson-smile", "application/problem+json")).addHeader("X-Request-Id", UUID.randomUUID().toString()).addHeader("User-Agent", this.e.b() + "/" + this.e.c()).addParameter("projectCoordinates", l2.a()).addParameter("targetPath", l2.b()).addParameter("inputFingerprint", string2);
        if (!duration.isZero()) {
            requestBuilder.setConfig(RequestConfig.copy(com.gradle.enterprise.testdistribution.common.client.a.a.a).setSocketTimeout(Math.toIntExact(duration.toMillis())).build());
        }
        list.forEach(publicBuildId -> requestBuilder.addParameter("buildIds", publicBuildId.getValue()));
        this.c.e().a(this.c.g().getHost(), this.c.c()).ifPresent(string -> requestBuilder.addHeader("Authorization", "Bearer " + string));
        if (this.c.f() != null) {
            requestBuilder.addHeader("X-Project-Id", this.c.f());
        }
        return requestBuilder.build();
    }

    private DownloadPartialCodeCoverageResponse a(StatusLine statusLine, HttpEntity httpEntity) throws IOException {
        String string = httpEntity.getContentType() == null ? null : httpEntity.getContentType().getValue();
        b.debug("Response ({}): {}", (Object)statusLine.getStatusCode(), (Object)string);
        if (statusLine.getStatusCode() == 200 && "application/x-jackson-smile".equals(string)) {
            return this.g.readValue(httpEntity.getContent(), DownloadPartialCodeCoverageResponse.class);
        }
        if ("application/problem+json".equals(string)) {
            com.gradle.a.a.a.a a2 = this.h.readValue(httpEntity.getContent(), com.gradle.a.a.a.a.class);
            throw new TestSelectionException("Unexpected problem response from server: " + a2);
        }
        throw new TestSelectionException("Unexpected response from server when downloading partial code coverage data: " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + " (" + string + ")");
    }

    @Override
    public void a(l l2, c c2) throws CodeCoverageDownloadException {
        try {
            Collection collection = (Collection)this.i.remove(l2);
            com.gradle.enterprise.java.a.a(collection, () -> "Code coverage for test target " + l2 + " has not been requested");
            b.debug("Predictive Test Selection: Waiting for code coverage download for test target {} to complete", (Object)l2);
            CompletableFuture.allOf(collection.toArray(new CompletableFuture[0])).get((long)(collection.size() + 2) * c2.a().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            throw new CodeCoverageDownloadException(com.gradle.enterprise.testacceleration.client.selection.b.a(com.gradle.enterprise.java.c.a.a(exception)));
        }
    }

    @Override
    public void close() {
        this.f.shutdownNow();
        try {
            if (!this.f.awaitTermination(30L, TimeUnit.SECONDS)) {
                b.warn("Failed to terminate executor service for code coverage download requests within timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

