/*
 * Decompiled with CFR 0.152.
 */
package de.kalpatec.pojosr.framework.felix.framework;

import de.kalpatec.pojosr.framework.felix.framework.ServiceRegistrationImpl;
import de.kalpatec.pojosr.framework.felix.framework.capabilityset.Capability;
import de.kalpatec.pojosr.framework.felix.framework.capabilityset.CapabilitySet;
import de.kalpatec.pojosr.framework.felix.framework.capabilityset.SimpleFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;

public class ServiceRegistry {
    private long m_currentServiceId = 1L;
    private final Map m_regsMap = Collections.synchronizedMap(new HashMap());
    private final CapabilitySet m_regCapSet;
    private final Map m_lockedRegsMap = new HashMap();
    private final Map m_inUseMap = new HashMap();
    private final ServiceRegistryCallbacks m_callbacks;
    private final Set m_eventHooks = new TreeSet(Collections.reverseOrder());
    private final Set m_findHooks = new TreeSet(Collections.reverseOrder());
    private final Set m_listenerHooks = new TreeSet(Collections.reverseOrder());

    public ServiceRegistry(ServiceRegistryCallbacks callbacks) {
        this.m_callbacks = callbacks;
        ArrayList<String> indices = new ArrayList<String>();
        indices.add("objectClass");
        this.m_regCapSet = new CapabilitySet(indices, false);
    }

    public ServiceReference[] getRegisteredServices(Bundle bundle) {
        ServiceRegistration[] regs = (ServiceRegistration[])this.m_regsMap.get(bundle);
        if (regs != null) {
            ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>(regs.length);
            for (int i = 0; i < regs.length; ++i) {
                try {
                    refs.add(regs[i].getReference());
                    continue;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            return refs.toArray(new ServiceReference[refs.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(Bundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        ServiceRegistrationImpl reg = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            reg = new ServiceRegistrationImpl(this, bundle, classNames, new Long(this.m_currentServiceId++), svcObj, dict);
            this.addHooks(classNames, svcObj, reg.getReference());
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_regsMap.get(bundle);
            this.m_regsMap.put(bundle, ServiceRegistry.addServiceRegistration(regs, reg));
            this.m_regCapSet.addCapability((Capability)((Object)reg.getReference()));
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(1, reg.getReference()), null);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistration reg) {
        this.removeHook(reg.getReference());
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_regsMap.get(bundle);
            this.m_regsMap.put(bundle, ServiceRegistry.removeServiceRegistration(regs, reg));
            this.m_regCapSet.removeCapability((Capability)((Object)reg.getReference()));
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(4, reg.getReference()), null);
        }
        serviceRegistry = this;
        synchronized (serviceRegistry) {
            Bundle[] clients = this.getUsingBundles(reg.getReference());
            for (int i = 0; clients != null && i < clients.length; ++i) {
                while (this.ungetService(clients[i], reg.getReference())) {
                }
            }
            ((ServiceRegistrationImpl)reg).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(Bundle bundle) {
        ServiceRegistration[] regs = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            regs = (ServiceRegistration[])this.m_regsMap.get(bundle);
        }
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!((ServiceRegistrationImpl)regs[i]).isValid()) continue;
            regs[i].unregister();
        }
        ServiceRegistry serviceRegistry2 = this;
        synchronized (serviceRegistry2) {
            this.m_regsMap.remove(bundle);
        }
    }

    public synchronized List getServiceReferences(String className, SimpleFilter filter) {
        if (className == null && filter == null) {
            filter = new SimpleFilter("objectClass", "*", 8);
        } else if (className != null && filter == null) {
            filter = new SimpleFilter("objectClass", className, 4);
        } else if (className != null && filter != null) {
            ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>(2);
            filters.add(new SimpleFilter("objectClass", className, 4));
            filters.add(filter);
            filter = new SimpleFilter(null, filters, 1);
        }
        Set<Capability> matches = this.m_regCapSet.match(filter, false);
        return new ArrayList<Capability>(matches);
    }

    public synchronized ServiceReference[] getServicesInUse(Bundle bundle) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usages != null) {
            ServiceReference[] refs = new ServiceReference[usages.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = usages[i].m_ref;
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        Object svcObj = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new ServiceException("ServiceFactory.getService() resulted in a cycle.", 2, null);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
            if (reg.isValid()) {
                usage = this.getUsageCount(bundle, ref);
                if (usage == null) {
                    usage = this.addUsageCount(bundle, ref);
                }
                ++usage.m_count;
                svcObj = usage.m_svcObj;
            }
        }
        try {
            if (usage != null && svcObj == null) {
                svcObj = reg.getService(bundle);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                if (!reg.isValid() || svcObj == null) {
                    this.flushUsageCount(bundle, ref);
                } else {
                    usage.m_svcObj = svcObj;
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            usage = this.getUsageCount(bundle, ref);
            if (usage == null) {
                return false;
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
        }
        try {
            if (usage.m_count == 1) {
                ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().ungetService(bundle, usage.m_svcObj);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                --usage.m_count;
                if (!reg.isValid() || usage.m_count <= 0) {
                    usage.m_svcObj = null;
                    this.flushUsageCount(bundle, ref);
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServices(Bundle bundle) {
        UsageCount[] usages;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            usages = (UsageCount[])this.m_inUseMap.get(bundle);
        }
        if (usages == null) {
            return;
        }
        for (int i = 0; i < usages.length; ++i) {
            while (this.ungetService(bundle, usages[i].m_ref)) {
            }
        }
    }

    public synchronized Bundle[] getUsingBundles(ServiceReference ref) {
        Bundle[] bundles = null;
        Iterator iter = this.m_inUseMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Bundle bundle = (Bundle)entry.getKey();
            UsageCount[] usages = (UsageCount[])entry.getValue();
            for (int useIdx = 0; useIdx < usages.length; ++useIdx) {
                if (!usages[useIdx].m_ref.equals(ref)) continue;
                if (bundles == null) {
                    bundles = new Bundle[]{bundle};
                    continue;
                }
                Bundle[] nbs = new Bundle[bundles.length + 1];
                System.arraycopy(bundles, 0, nbs, 0, bundles.length);
                nbs[bundles.length] = bundle;
                bundles = nbs;
            }
        }
        return bundles;
    }

    void servicePropertiesModified(ServiceRegistration reg, Dictionary oldProps) {
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(2, reg.getReference()), oldProps);
        }
    }

    private static ServiceRegistration[] addServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        if (regs == null) {
            regs = new ServiceRegistration[]{reg};
        } else {
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length + 1];
            System.arraycopy(regs, 0, newRegs, 0, regs.length);
            newRegs[regs.length] = reg;
            regs = newRegs;
        }
        return regs;
    }

    private static ServiceRegistration[] removeServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!regs[i].equals(reg)) continue;
            if (regs.length - 1 == 0) {
                regs = new ServiceRegistration[]{};
                continue;
            }
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length - 1];
            System.arraycopy(regs, 0, newRegs, 0, i);
            if (i < newRegs.length) {
                System.arraycopy(regs, i + 1, newRegs, i, newRegs.length - i);
            }
            regs = newRegs;
        }
        return regs;
    }

    private UsageCount getUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            return usages[i];
        }
        return null;
    }

    private UsageCount addUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        UsageCount usage = new UsageCount();
        usage.m_ref = ref;
        if (usages == null) {
            usages = new UsageCount[]{usage};
        } else {
            UsageCount[] newUsages = new UsageCount[usages.length + 1];
            System.arraycopy(usages, 0, newUsages, 0, usages.length);
            newUsages[usages.length] = usage;
            usages = newUsages;
        }
        this.m_inUseMap.put(bundle, usages);
        return usage;
    }

    private void flushUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            if (usages.length - 1 == 0) {
                usages = null;
                continue;
            }
            UsageCount[] newUsages = new UsageCount[usages.length - 1];
            System.arraycopy(usages, 0, newUsages, 0, i);
            if (i < newUsages.length) {
                System.arraycopy(usages, i + 1, newUsages, i, newUsages.length - i);
            }
            usages = newUsages;
        }
        if (usages != null) {
            this.m_inUseMap.put(bundle, usages);
        } else {
            this.m_inUseMap.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHooks(String[] classNames, Object svcObj, ServiceReference ref) {
        Set set;
        if (ServiceRegistry.isHook(classNames, EventHook.class, svcObj)) {
            set = this.m_eventHooks;
            synchronized (set) {
                this.m_eventHooks.add(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, FindHook.class, svcObj)) {
            set = this.m_findHooks;
            synchronized (set) {
                this.m_findHooks.add(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, ListenerHook.class, svcObj)) {
            set = this.m_listenerHooks;
            synchronized (set) {
                this.m_listenerHooks.add(ref);
            }
        }
    }

    static boolean isHook(String[] classNames, Class hookClass, Object svcObj) {
        if (svcObj instanceof ServiceFactory) {
            return Arrays.asList(classNames).contains(hookClass.getName());
        }
        if (hookClass.isAssignableFrom(svcObj.getClass())) {
            String hookName = hookClass.getName();
            for (int i = 0; i < classNames.length; ++i) {
                if (!classNames[i].equals(hookName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHook(ServiceReference ref) {
        Set set;
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        String[] classNames = (String[])ref.getProperty("objectClass");
        if (ServiceRegistry.isHook(classNames, EventHook.class, svcObj)) {
            set = this.m_eventHooks;
            synchronized (set) {
                this.m_eventHooks.remove(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, FindHook.class, svcObj)) {
            set = this.m_findHooks;
            synchronized (set) {
                this.m_findHooks.remove(ref);
            }
        }
        if (ServiceRegistry.isHook(classNames, ListenerHook.class, svcObj)) {
            set = this.m_listenerHooks;
            synchronized (set) {
                this.m_listenerHooks.remove(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEventHooks() {
        Set set = this.m_eventHooks;
        synchronized (set) {
            return new ArrayList(this.m_eventHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getFindHooks() {
        Set set = this.m_findHooks;
        synchronized (set) {
            return new ArrayList(this.m_findHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getListenerHooks() {
        Set set = this.m_listenerHooks;
        synchronized (set) {
            return new ArrayList(this.m_listenerHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeHook(ServiceReference ref, Framework framework, Object callback) {
        Object hook = this.getService(framework, ref);
        this.ungetService(framework, ref);
    }

    public static interface ServiceRegistryCallbacks {
        public void serviceChanged(ServiceEvent var1, Dictionary var2);
    }

    private static class UsageCount {
        public int m_count = 0;
        public ServiceReference m_ref = null;
        public Object m_svcObj = null;

        private UsageCount() {
        }
    }
}

