/*
 * Decompiled with CFR 0.152.
 */
package de.kalpatec.pojosr.framework;

import de.kalpatec.pojosr.framework.EntryFilterEnumeration;
import de.kalpatec.pojosr.framework.PojoSRBundleContext;
import de.kalpatec.pojosr.framework.Revision;
import de.kalpatec.pojosr.framework.felix.framework.ServiceRegistry;
import de.kalpatec.pojosr.framework.felix.framework.util.EventDispatcher;
import de.kalpatec.pojosr.framework.felix.framework.util.MapToDictionary;
import de.kalpatec.pojosr.framework.felix.framework.util.StringMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoSRBundle
implements Bundle {
    private final Revision m_revision;
    private final Map<String, String> m_manifest;
    private final Version m_version;
    private final String m_location;
    private final Map<Long, Bundle> m_bundles;
    private final ServiceRegistry m_reg;
    private final String m_activatorClass;
    private final long m_id;
    private final String m_symbolicName;
    private volatile BundleActivator m_activator = null;
    volatile int m_state = 4;
    volatile BundleContext m_context = null;
    private final EventDispatcher m_dispatcher;
    private final ClassLoader m_loader;
    private final Map m_cachedHeaders = new HashMap();
    private long m_cachedHeadersTimestamp;

    Revision getRevision() {
        return this.m_revision;
    }

    public PojoSRBundle(Revision revision, Map<String, String> manifest, Version version, String location, ServiceRegistry reg, EventDispatcher dispatcher, String activatorClass, long id, String symbolicName, Map<Long, Bundle> bundles, ClassLoader loader) {
        this.m_revision = revision;
        this.m_manifest = manifest;
        this.m_version = version;
        this.m_location = location;
        this.m_reg = reg;
        this.m_dispatcher = dispatcher;
        this.m_activatorClass = activatorClass;
        this.m_id = id;
        this.m_symbolicName = symbolicName;
        bundles.put(new Long(this.m_id), this);
        this.m_bundles = bundles;
        this.m_loader = loader;
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    @Override
    public void start(int options) throws BundleException {
        this.start();
    }

    @Override
    public synchronized void start() throws BundleException {
        if (this.m_state != 4) {
            if (this.m_state == 32) {
                return;
            }
            throw new BundleException("Bundle is in wrong state for start");
        }
        try {
            this.m_state = 8;
            this.m_context = new PojoSRBundleContext(this, this.m_reg, this.m_dispatcher, this.m_bundles);
            this.m_dispatcher.fireBundleEvent(new BundleEvent(128, this));
            if (this.m_activatorClass != null) {
                this.m_activator = (BundleActivator)this.m_loader.loadClass(this.m_activatorClass).newInstance();
                this.m_activator.start(this.m_context);
            }
            this.m_state = 32;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(2, this));
        }
        catch (Throwable ex) {
            this.m_state = 4;
            this.m_activator = null;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(4, this));
            throw new BundleException("Unable to start bundle", ex);
        }
    }

    @Override
    public void stop(int options) throws BundleException {
        this.stop();
    }

    @Override
    public synchronized void stop() throws BundleException {
        if (this.m_state != 32) {
            if (this.m_state == 4) {
                return;
            }
            throw new BundleException("Bundle is in wrong state for stop");
        }
        try {
            this.m_state = 16;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(256, this));
            if (this.m_activator != null) {
                this.m_activator.stop(this.m_context);
            }
        }
        catch (Throwable ex) {
            throw new BundleException("Error while stopping bundle", ex);
        }
        finally {
            this.m_reg.unregisterServices(this);
            this.m_dispatcher.removeListeners(this);
            this.m_activator = null;
            this.m_context = null;
            this.m_state = 4;
            this.m_dispatcher.fireBundleEvent(new BundleEvent(4, this));
        }
    }

    @Override
    public void update(InputStream input) throws BundleException {
        throw new BundleException("pojosr bundles can't be updated");
    }

    @Override
    public void update() throws BundleException {
        throw new BundleException("pojosr bundles can't be updated");
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("pojosr bundles can't be uninstalled");
    }

    @Override
    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    @Override
    public long getBundleId() {
        return this.m_id;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public ServiceReference[] getRegisteredServices() {
        return this.m_reg.getRegisteredServices(this);
    }

    @Override
    public ServiceReference[] getServicesInUse() {
        return this.m_reg.getServicesInUse(this);
    }

    @Override
    public boolean hasPermission(Object permission) {
        return true;
    }

    @Override
    public URL getResource(String name) {
        URL result = this.m_loader.getResource(name);
        return result;
    }

    @Override
    public Dictionary getHeaders(String locale) {
        return new MapToDictionary(this.getCurrentLocalizedHeader(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCurrentLocalizedHeader(String locale) {
        Map result = null;
        if (locale == null || locale.length() == 0) {
            result = new StringMap(this.m_manifest, false);
        }
        if (result == null) {
            Map map = this.m_cachedHeaders;
            synchronized (map) {
                if (this.getState() == 1) {
                    result = (Map)this.m_cachedHeaders.values().iterator().next();
                } else if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                    this.m_cachedHeaders.clear();
                } else if (this.m_cachedHeaders.containsKey(locale)) {
                    result = (Map)this.m_cachedHeaders.get(locale);
                }
            }
        }
        if (result == null) {
            StringMap headers;
            result = headers = new StringMap(this.m_manifest, false);
            boolean localize = false;
            Iterator it = headers.values().iterator();
            while (!localize && it.hasNext()) {
                if (!((String)it.next()).startsWith("%")) continue;
                localize = true;
            }
            if (!localize) {
                this.updateHeaderCache(locale, headers);
            } else {
                String basename = (String)headers.get("Bundle-Localization");
                if (basename == null) {
                    basename = "OSGI-INF/l10n/bundle";
                }
                List resourceList = PojoSRBundle.createLocalizationResourceList(basename, locale);
                boolean found = false;
                Properties mergedProperties = new Properties();
                Iterator it2 = resourceList.iterator();
                while (it2.hasNext()) {
                    URL uRL = this.m_revision.getEntry(new StringBuffer().append(it2.next()).append(".properties").toString());
                    if (uRL == null) continue;
                    found = true;
                    try {
                        mergedProperties.load(uRL.openConnection().getInputStream());
                    }
                    catch (IOException ex) {}
                }
                if (!found && !locale.equals(Locale.getDefault().toString())) {
                    result = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
                } else {
                    for (Map.Entry entry : headers.entrySet()) {
                        String value = (String)entry.getValue();
                        if (!value.startsWith("%")) continue;
                        String key = value.substring(value.indexOf("%") + 1);
                        String newvalue = mergedProperties.getProperty(key);
                        if (newvalue == null) {
                            newvalue = key;
                        }
                        entry.setValue(newvalue);
                    }
                    this.updateHeaderCache(locale, headers);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map localizedHeaders) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private static List createLocalizationResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    @Override
    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.m_loader.loadClass(name);
    }

    @Override
    public Enumeration getResources(String name) throws IOException {
        return this.m_loader.getResources(name);
    }

    @Override
    public Enumeration getEntryPaths(String path) {
        return new EntryFilterEnumeration(this.m_revision, false, path, null, false, true);
    }

    @Override
    public URL getEntry(String path) {
        URL result = this.m_revision.getEntry(path);
        return result;
    }

    @Override
    public long getLastModified() {
        return this.m_revision.getLastModified();
    }

    @Override
    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return new EntryFilterEnumeration(this.m_revision, false, path, filePattern, recurse, true);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public Map getSignerCertificates(int signersType) {
        return new HashMap();
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    public boolean equals(Object o) {
        if (o instanceof PojoSRBundle) {
            return ((PojoSRBundle)o).m_id == this.m_id;
        }
        return false;
    }
}

