/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import com.googlecode.download.maven.plugin.internal.cache.IncompatibleIndexException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.maven.plugin.logging.Log;

@NotThreadSafe
final class FileBackedIndex
implements FileIndex {
    private static final String CACHE_FILENAME = "index.ser";
    private final Map<URI, String> index = new HashMap<URI, String>();
    private final File storage;
    private final ReentrantLock lock = new ReentrantLock();
    private final Log log;

    FileBackedIndex(File baseDir, Log log) {
        this.log = log;
        this.storage = new File(baseDir, CACHE_FILENAME);
    }

    @Override
    public void put(URI uri, String path) {
        this.index.put(uri, path);
        try {
            this.load(this.storage);
        }
        catch (IncompatibleIndexException | IOException e) {
            this.log.warn((CharSequence)"Could not load index cache index file, it will be rewritten.");
        }
        this.save();
    }

    @Override
    public String get(URI uri) {
        try {
            this.load(this.storage);
        }
        catch (IncompatibleIndexException | IOException e) {
            this.log.warn((CharSequence)("Error while reading from cache " + this.storage.getAbsolutePath()));
        }
        return this.index.get(uri);
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    private void load(File store) throws IncompatibleIndexException, IOException {
        if (store.length() != 0L) {
            try (RandomAccessFile file = new RandomAccessFile(store, "r");
                 FileChannel channel = file.getChannel();
                 FileLock ignored = channel.lock(0L, Long.MAX_VALUE, true);
                 ObjectInputStream deserialize = new ObjectInputStream(Files.newInputStream(store.toPath(), new OpenOption[0]));){
                Map newEntries = (Map)deserialize.readObject();
                newEntries.forEach(this.index::putIfAbsent);
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                throw new IncompatibleIndexException(e);
            }
        }
    }

    private void save() {
        try (FileOutputStream file = new FileOutputStream(this.storage);
             ObjectOutputStream res = new ObjectOutputStream(file);
             FileChannel channel = file.getChannel();
             FileLock ignored = channel.lock();){
            res.writeObject(this.index);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

