/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode;

import com.googlecode.CachedFileEntry;
import com.googlecode.SignatureUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class DownloadCache {
    private static final String INDEX_FILENAME = "index.ser";
    private File basedir;
    private File indexFile;
    private Map<String, CachedFileEntry> index;

    public DownloadCache(File cacheDirectory) {
        this.basedir = cacheDirectory;
        this.indexFile = new File(this.basedir, INDEX_FILENAME);
    }

    private CachedFileEntry getEntry(String url, String md5, String sha1) throws Exception {
        this.loadIndex();
        CachedFileEntry res = this.index.get(url);
        if (res == null) {
            return null;
        }
        File resFile = new File(this.basedir, res.fileName);
        if (!resFile.isFile()) {
            return null;
        }
        if (md5 != null && !md5.equals(SignatureUtils.getMD5(resFile))) {
            return null;
        }
        if (sha1 != null && !sha1.equals(SignatureUtils.getSHA1(resFile))) {
            return null;
        }
        return res;
    }

    public File getArtifact(String url, String md5, String sha1) throws Exception {
        CachedFileEntry res = this.getEntry(url, md5, sha1);
        if (res != null) {
            return new File(this.basedir, res.fileName);
        }
        return null;
    }

    public void install(String url, File outputFile, String md5, String sha1) throws Exception {
        CachedFileEntry entry;
        this.loadIndex();
        if (md5 == null) {
            md5 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("MD5"));
        }
        if (sha1 == null) {
            sha1 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("SHA1"));
        }
        if ((entry = this.getEntry(url, md5, sha1)) != null) {
            return;
        }
        entry = new CachedFileEntry();
        entry.fileName = outputFile.getName();
        this.index.put(url, entry);
        FileUtils.copyFile((File)outputFile, (File)new File(this.basedir, entry.fileName));
        this.saveIndex();
    }

    private void loadIndex() throws Exception {
        if (this.indexFile.isFile()) {
            FileInputStream input = new FileInputStream(this.indexFile);
            ObjectInputStream deserialize = new ObjectInputStream(input);
            this.index = (Map)deserialize.readObject();
            deserialize.close();
        } else {
            this.index = new HashMap<String, CachedFileEntry>();
        }
    }

    private void saveIndex() throws Exception {
        if (this.basedir.exists() && !this.basedir.isDirectory()) {
            throw new Exception("Cannot use " + this.basedir + " as cache directory: file exists");
        }
        if (!this.basedir.exists()) {
            this.basedir.mkdirs();
        }
        if (!this.indexFile.exists()) {
            this.indexFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(this.indexFile);
        ObjectOutputStream res = new ObjectOutputStream(out);
        res.writeObject(this.index);
        res.close();
    }
}

