/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import com.googlecode.download.maven.plugin.internal.checksum.Checksums;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class DownloadCache {
    private final File basedir;
    private final FileIndex index;

    public DownloadCache(File cacheDirectory, Log log) {
        this.index = new FileBackedIndex(cacheDirectory, log);
        this.basedir = cacheDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getArtifact(URI uri, Checksums checksums) {
        Optional<String> resource;
        this.index.getLock().lock();
        try {
            resource = this.getEntry(uri, checksums);
        }
        finally {
            this.index.getLock().unlock();
        }
        return resource.map(res -> new File(this.basedir, (String)res)).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(URI uri, File outputFile, Checksums checksums) throws MojoFailureException, IOException {
        if (!this.basedir.exists() && !this.basedir.mkdirs()) {
            throw new MojoFailureException(String.format("Could not create cache directory: %s", this.basedir.getAbsolutePath()));
        }
        this.index.getLock().lock();
        try {
            Optional<String> entry = this.getEntry(uri, checksums);
            if (!entry.isPresent()) {
                String fileName = String.format("%s_%s", outputFile.getName(), DigestUtils.md5Hex((String)uri.toString()));
                Files.copy(outputFile.toPath(), new File(this.basedir, fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.index.put(uri, fileName);
            }
        }
        finally {
            this.index.getLock().unlock();
        }
    }

    private Optional<String> getEntry(URI uri, Checksums checksums) {
        String resource = this.index.get(uri);
        return Optional.ofNullable(resource).filter(res -> {
            File resFile = new File(this.basedir, resource);
            return resFile.isFile() && checksums.isValid(resFile);
        });
    }
}

