/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.ProgressReport;
import java.net.URI;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.maven.plugin.logging.Log;

@NotThreadSafe
public final class LoggingProgressReport
implements ProgressReport {
    private static final long KBYTE = 1024L;
    private static final char K_UNIT = 'K';
    private static final char B_UNIT = 'b';
    private final Log log;
    private char unit;
    private long total;
    private long completed;

    public LoggingProgressReport(Log logger) {
        this.log = logger;
    }

    @Override
    public void initiate(URI uri, long totalBytes) {
        this.total = totalBytes;
        this.completed = 0L;
        this.unit = (char)(totalBytes >= 1024L ? 75 : 98);
        this.log.info((CharSequence)String.format("%s: %s", "Downloading", uri));
    }

    @Override
    public void update(long bytesRead) {
        long completedInUnits;
        String totalInUnits;
        this.completed += bytesRead;
        if (this.unit == 'K') {
            totalInUnits = this.total == -1L ? "?" : Long.toString(this.total / 1024L) + this.unit;
            completedInUnits = this.completed / 1024L;
        } else {
            totalInUnits = this.total == -1L ? "?" : Long.toString(this.total);
            completedInUnits = this.completed;
        }
        this.log.info((CharSequence)String.format("%d/%s", completedInUnits, totalInUnits));
    }

    @Override
    public void completed() {
        this.log.info((CharSequence)String.format("%s downloaded", LoggingProgressReport.render(this.completed, this.unit)));
    }

    @Override
    public void error(Exception exc) {
        this.log.error((Throwable)exc);
    }

    private static String render(long bytes, char unit) {
        return unit == 'K' ? Long.toString(bytes / 1024L) + unit : Long.toString(bytes);
    }
}

