/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class FilePermissions {
    private static final String SET_EXECUTABLE = "+x";
    private final String operations;
    private final Log log;

    public FilePermissions(String operations, Log log) {
        this.operations = operations;
        this.log = log;
    }

    public void applyTo(File file) throws MojoExecutionException {
        if (this.operations != null) {
            if (this.operations.contains(SET_EXECUTABLE)) {
                this.setExecutable(file);
            } else {
                throw new MojoExecutionException("Invalid outputFilePermissions: " + this.operations);
            }
        }
    }

    private void setExecutable(File file) throws MojoExecutionException {
        if (!file.setExecutable(true)) {
            throw new MojoExecutionException(String.format("Failed to apply (%s) to file %s", this.operations, file.getAbsolutePath()));
        }
        this.log.debug((CharSequence)String.format("Applied (%s) permission to file %s", this.operations, file.getAbsolutePath()));
    }
}

