/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="artifact", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=false)
public final class ArtifactMojo
extends AbstractMojo {
    @Parameter(property="artifactId", required=true)
    private String artifactId;
    @Parameter(property="groupId", required=true)
    private String groupId;
    @Parameter(property="version", required=true)
    private String version;
    @Parameter(property="type", defaultValue="jar")
    private String type;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(property="outputFileName")
    private String outputFileName;
    @Parameter(property="unpack", defaultValue="false")
    private boolean unpack;
    @Parameter(property="download.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="dependencyDepth", defaultValue="0")
    private long dependencyDepth;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Inject
    private ArtifactFactory artifactFactory;
    @Inject
    private ArchiverManager archiverManager;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"download-maven-plugin:artifact skipped");
            return;
        }
        if (this.dependencyDepth > 0L && this.outputFileName != null) {
            throw new MojoExecutionException("Cannot have a dependency depth higher than 0 and an outputFileName");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
        this.createOutputDirectoryIfNecessary();
        try {
            this.downloadAndAddArtifact(artifact, this.dependencyDepth).thenAccept(artifacts -> artifacts.forEach(copy -> {
                try {
                    if (this.unpack) {
                        this.unpackFileToDirectory((Artifact)copy);
                    } else {
                        this.copyFileToDirectory((Artifact)copy);
                    }
                }
                catch (MojoFailureException | NoSuchArchiverException exc) {
                    throw new RuntimeException(exc);
                }
            })).toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException exc) {
            throw new MojoExecutionException("Abnormal termination of the retrieval", exc);
        }
    }

    private CompletionStage<Set<Artifact>> downloadAndAddArtifact(Artifact artifact, long maxDepth) {
        return this.downloadArtifact(artifact).thenApply(downloadedArtifact -> {
            HashSet<Artifact> result = new HashSet<Artifact>();
            result.add((Artifact)downloadedArtifact);
            if (maxDepth > 0L) {
                this.resolveDependencyArtifacts((Artifact)downloadedArtifact).forEach(completionStage -> {
                    try {
                        ((CompletableFuture)completionStage.thenCompose(artifact1 -> this.downloadAndAddArtifact((Artifact)artifact1, maxDepth - 1L)).toCompletableFuture().thenAccept(result::addAll)).get();
                    }
                    catch (InterruptedException | ExecutionException exc) {
                        throw new RuntimeException(exc);
                    }
                });
            }
            return result;
        });
    }

    private List<CompletionStage<Artifact>> resolveDependencyArtifacts(Artifact artifact) {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Resolving dependencies for artifact %s...", artifact.getId()));
        }
        try {
            ProjectBuildingResult result = this.projectBuilder.build(pomArtifact, false, (ProjectBuildingRequest)new DefaultProjectBuildingRequest(){
                {
                    this.setValidationLevel(0);
                    this.setResolveDependencies(false);
                    this.setLocalRepository(ArtifactMojo.this.session.getLocalRepository());
                    this.setRemoteRepositories(ArtifactMojo.this.session.getCurrentProject().getRemoteArtifactRepositories());
                    this.setUserProperties(ArtifactMojo.this.session.getUserProperties());
                    this.setSystemProperties(ArtifactMojo.this.session.getSystemProperties());
                    this.setActiveProfileIds(ArtifactMojo.this.session.getRequest().getActiveProfiles());
                    this.setInactiveProfileIds(ArtifactMojo.this.session.getRequest().getInactiveProfiles());
                    this.setRepositorySession(ArtifactMojo.this.session.getRepositorySession());
                    this.setBuildStartTime(ArtifactMojo.this.session.getStartTime());
                }
            });
            return result.getProject().getDependencies().stream().map(this::createDependencyArtifact).map(this::downloadArtifact).collect(Collectors.toList());
        }
        catch (ProjectBuildingException exc) {
            throw new RuntimeException(exc);
        }
    }

    private Artifact createDependencyArtifact(Dependency dep) {
        try {
            return this.artifactFactory.createDependencyArtifact(dep.getGroupId(), dep.getArtifactId(), VersionRange.createFromVersionSpec((String)dep.getVersion()), dep.getType(), dep.getClassifier(), dep.getScope());
        }
        catch (InvalidVersionSpecificationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private CompletionStage<Artifact> downloadArtifact(Artifact artifact) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), this.session.getCurrentProject().getRemoteProjectRepositories(), ((Object)((Object)this)).getClass().getName()));
                artifact.setFile(artifactResult.getArtifact().getFile());
                artifact.setVersion(artifactResult.getArtifact().getVersion());
                artifact.setResolved(artifactResult.isResolved());
                return artifact;
            }
            catch (ArtifactResolutionException exc) {
                throw new RuntimeException(exc);
            }
        });
    }

    private void copyFileToDirectory(Artifact artifact) throws MojoFailureException {
        if (artifact.getFile() == null || !artifact.getFile().exists() || !artifact.getFile().isFile()) {
            throw new MojoFailureException(String.format("Artifact file not resolved for artifact: %s", artifact.getId()));
        }
        try {
            File outputFile = new File(this.outputDirectory, Optional.ofNullable(this.outputFileName).orElse(artifact.getFile().getName()));
            Files.copy(artifact.getFile().toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exc) {
            throw new MojoFailureException(String.format("Error copying the file : %s", exc.getMessage()));
        }
    }

    private void unpackFileToDirectory(Artifact artifact) throws NoSuchArchiverException {
        File toUnpack = artifact.getFile();
        if (toUnpack != null && toUnpack.exists() && toUnpack.isFile()) {
            UnArchiver unarchiver = this.archiverManager.getUnArchiver(toUnpack);
            unarchiver.setSourceFile(toUnpack);
            unarchiver.setDestDirectory(this.outputDirectory);
            unarchiver.extract();
        }
    }

    private void createOutputDirectoryIfNecessary() {
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }
}

