/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UnitLowerTriangBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class BandLU {
    private final int n;
    private final int kl;
    private final int ku;
    private final BandMatrix LU;
    private final int[] ipiv;
    private boolean singular;

    public BandLU(int n, int kl, int ku) {
        this.n = n;
        this.kl = kl;
        this.ku = ku;
        this.LU = new BandMatrix(n, kl, ku + kl);
        this.ipiv = new int[n];
    }

    public static BandLU factorize(BandMatrix A) {
        return new BandLU(A.numRows(), A.kl, A.ku).factor(A, false);
    }

    public BandLU factor(BandMatrix A, boolean inplace) {
        if (inplace) {
            return this.factor(A);
        }
        return this.factor(new BandMatrix(A, this.kl, this.kl + this.ku));
    }

    public BandLU factor(BandMatrix A) {
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (A.ku != this.ku + this.kl) {
            throw new IllegalArgumentException("A.ku != ku + kl");
        }
        this.singular = false;
        intW info = new intW(0);
        LAPACK.getInstance().dgbtrf(this.n, this.n, this.kl, this.ku, A.getData(), 2 * this.kl + this.ku + 1, this.ipiv, info);
        if (info.val > 0) {
            this.singular = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.LU.set(A);
        return this;
    }

    public UnitLowerTriangBandMatrix getL() {
        return new UnitLowerTriangBandMatrix((Matrix)this.LU, this.LU.numSubDiagonals(), false);
    }

    public UpperTriangBandMatrix getU() {
        return new UpperTriangBandMatrix((Matrix)this.LU, this.LU.numSuperDiagonals(), false);
    }

    public BandMatrix getLU() {
        return this.LU;
    }

    public int[] getPivots() {
        return this.ipiv;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double rcond(Matrix A, Matrix.Norm norm) {
        if (norm != Matrix.Norm.One && norm != Matrix.Norm.Infinity) {
            throw new IllegalArgumentException("Only the 1 or the Infinity norms are supported");
        }
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(norm);
        double[] work = new double[3 * this.n];
        int[] lwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        LAPACK.getInstance().dgbcon(norm.netlib(), this.n, this.kl, this.ku, this.LU.getData(), Matrices.ld(2 * this.kl + this.ku + 1), this.ipiv, anorm, rcond, work, lwork, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, Transpose.NoTranspose);
    }

    public DenseMatrix transSolve(DenseMatrix B) throws MatrixSingularException {
        return this.solve(B, Transpose.Transpose);
    }

    private DenseMatrix solve(DenseMatrix B, Transpose trans) throws MatrixSingularException {
        if (this.singular) {
            throw new MatrixSingularException();
        }
        if (B.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgbtrs(trans.netlib(), this.n, this.kl, this.ku, B.numColumns(), this.LU.getData(), 2 * this.kl + this.ku + 1, this.ipiv, B.getData(), Matrices.ld(this.n), info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }
}

