/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.EjmlParameters;
import org.ejml.alg.block.decomposition.hessenberg.TridiagonalDecompositionBlockHouseholder;
import org.ejml.alg.dense.decomposition.BaseDecompositionBlock64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionBlock
extends BaseDecompositionBlock64
implements TridiagonalSimilarDecomposition<DenseMatrix64F> {
    public TridiagonalDecompositionBlock() {
        this(EjmlParameters.BLOCK_WIDTH);
    }

    public TridiagonalDecompositionBlock(int blockSize) {
        super(new TridiagonalDecompositionBlockHouseholder(), blockSize);
    }

    @Override
    public DenseMatrix64F getT(DenseMatrix64F T) {
        int N = this.Ablock.numRows;
        if (T == null) {
            T = new DenseMatrix64F(N, N);
        } else {
            CommonOps.fill(T, 0.0);
        }
        double[] diag = new double[N];
        double[] off = new double[N];
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getDiagonal(diag, off);
        T.unsafe_set(0, 0, diag[0]);
        for (int i = 1; i < N; ++i) {
            T.unsafe_set(i, i, diag[i]);
            T.unsafe_set(i, i - 1, off[i - 1]);
            T.unsafe_set(i - 1, i, off[i - 1]);
        }
        return T;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F Q, boolean transposed) {
        if (Q == null) {
            Q = new DenseMatrix64F(this.Ablock.numRows, this.Ablock.numCols);
        }
        BlockMatrix64F Qblock = new BlockMatrix64F();
        Qblock.numRows = Q.numRows;
        Qblock.numCols = Q.numCols;
        Qblock.blockLength = this.blockLength;
        Qblock.data = Q.data;
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getQ(Qblock, transposed);
        this.convertBlockToRow(Q.numRows, Q.numCols, this.Ablock.blockLength, Q.data);
        return Q;
    }

    @Override
    public void getDiagonal(double[] diag, double[] off) {
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getDiagonal(diag, off);
    }
}

