/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.MapWithProtoValuesFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class MapWithProtoValuesSubject<M extends Message>
extends MapSubject {
    private final FailureMetadata metadata;
    private final Map<?, M> actual;
    private final FluentEqualityConfig config;

    protected MapWithProtoValuesSubject(FailureMetadata failureMetadata, @Nullable Map<?, M> map) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), map);
    }

    MapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Map<?, M> map) {
        super(failureMetadata, map);
        this.metadata = failureMetadata;
        this.actual = map;
        this.config = config;
    }

    MapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        return new MapWithProtoValuesFluentAssertionImpl<M>(new MapWithProtoValuesSubject<M>(this.metadata, newConfig, this.actual));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    public MapWithProtoValuesFluentAssertion<M> unpackingAnyUsingForValues(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        return this.usingConfig(this.config.unpackingAnyUsing(typeRegistry, extensionRegistry));
    }

    private MapSubject.UsingCorrespondence<M, M> usingCorrespondence(Iterable<? extends M> expectedValues) {
        return this.comparingValuesUsing(this.config.withExpectedMessages(expectedValues).toCorrespondence(FieldScopeUtil.getSingleDescriptor(this.actual.values())));
    }

    private static final class MapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MapWithProtoValuesFluentAssertion<M> {
        private final MapWithProtoValuesSubject<M> subject;

        MapWithProtoValuesFluentAssertionImpl(MapWithProtoValuesSubject<M> subject) {
            this.subject = subject;
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldAbsenceOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldAbsenceOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
            return this.subject.ignoringExtraRepeatedFieldElementsForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
            return this.subject.usingDoubleToleranceForValues(tolerance);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingDoubleToleranceForFieldsForValues(tolerance, firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingDoubleToleranceForFieldsForValues(tolerance, fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingDoubleToleranceForFieldDescriptorsForValues(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingDoubleToleranceForFieldDescriptorsForValues(tolerance, fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
            return this.subject.usingFloatToleranceForValues(tolerance);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingFloatToleranceForFieldsForValues(tolerance, firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingFloatToleranceForFieldsForValues(tolerance, fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingFloatToleranceForFieldDescriptorsForValues(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingFloatToleranceForFieldDescriptorsForValues(tolerance, fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
            return this.subject.comparingExpectedFieldsOnlyForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> unpackingAnyUsingForValues(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
            return this.subject.unpackingAnyUsingForValues(typeRegistry, extensionRegistry);
        }

        @Override
        public void containsEntry(@Nullable Object expectedKey, @Nullable M expectedValue) {
            ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(expectedValue)).containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable M excludedValue) {
            ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(excludedValue)).doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable M v0, Object ... rest) {
            ArrayList<Object> expectedValues = new ArrayList<Object>();
            expectedValues.add(v0);
            for (int i = 1; i < rest.length; i += 2) {
                expectedValues.add((Message)rest[i]);
            }
            return ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedValues).containsExactly(k0, v0, rest);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Map<?, ? extends M> expectedMap) {
            return ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedMap.values()).containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }
    }
}

