/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public final class IntStreamSubject
extends Subject<IntStreamSubject, IntStream> {
    private final List<?> actualList;

    private IntStreamSubject(FailureMetadata failureMetadata, @Nullable IntStream stream) {
        super(failureMetadata, (Object)stream);
        this.actualList = stream == null ? null : (List)stream.boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<IntStreamSubject, IntStream> intStreams() {
        return IntStreamSubject::new;
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(int element) {
        this.check().that(this.actualList).contains((Object)element);
    }

    public void doesNotContain(int element) {
        this.check().that(this.actualList).doesNotContain((Object)element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsAnyOf((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllOf(int first, int second, int ... rest) {
        return this.check().that(this.actualList).containsAllOf((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    @CanIgnoreReturnValue
    public Ordered containsAllIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsAllIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(int ... varargs) {
        return this.check().that(this.actualList).containsExactly(IntStreamSubject.box(varargs));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsNoneOf((Object)first, (Object)second, IntStreamSubject.box(rest));
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    private void isInStrictOrder() {
        this.check().that(this.actualList).isStrictlyOrdered();
    }

    private void isInStrictOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isStrictlyOrdered(comparator);
    }

    private void isInOrder() {
        this.check().that(this.actualList).isOrdered();
    }

    private void isInOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isOrdered(comparator);
    }

    private static Object[] box(int[] rest) {
        return IntStream.of(rest).boxed().toArray(Integer[]::new);
    }
}

