/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.google.testing.junit.testparameterinjector.ProtoValueParsing;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

final class ParameterValueParsing {
    static <E extends Enum<E>> Enum<?> parseEnum(String str, Class<?> enumType) {
        return Enum.valueOf(enumType, str);
    }

    static MessageLite parseTextprotoMessage(String textprotoString, Class<?> javaType) {
        return ParameterValueParsing.getProtoValueParser().parseTextprotoMessage(textprotoString, javaType);
    }

    static boolean isValidYamlString(String yamlString) {
        try {
            new Yaml((BaseConstructor)new SafeConstructor()).load(yamlString);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    static Object parseYamlStringToJavaType(String yamlString, Class<?> javaType) {
        return ParameterValueParsing.parseYamlObjectToJavaType(ParameterValueParsing.parseYamlStringToObject(yamlString), TypeToken.of(javaType));
    }

    static Object parseYamlStringToObject(String yamlString) {
        return new Yaml((BaseConstructor)new SafeConstructor()).load(yamlString);
    }

    static Object parseYamlObjectToJavaType(Object parsedYaml, TypeToken<?> javaType) {
        if (parsedYaml == null) {
            return null;
        }
        YamlValueTransformer yamlValueTransformer = new YamlValueTransformer(parsedYaml, javaType.getRawType());
        yamlValueTransformer.ifJavaType(String.class).supportParsedType(String.class, Function.identity()).supportParsedType(Boolean.class, Object::toString).supportParsedType(Integer.class, Object::toString).supportParsedType(Long.class, Object::toString).supportParsedType(Double.class, Object::toString);
        yamlValueTransformer.ifJavaType(Boolean.class).supportParsedType(Boolean.class, Function.identity());
        yamlValueTransformer.ifJavaType(Integer.class).supportParsedType(Integer.class, Function.identity());
        yamlValueTransformer.ifJavaType(Long.class).supportParsedType(Long.class, Function.identity()).supportParsedType(Integer.class, Integer::longValue);
        yamlValueTransformer.ifJavaType(Float.class).supportParsedType(Float.class, Function.identity()).supportParsedType(Double.class, Double::floatValue).supportParsedType(Integer.class, Integer::floatValue);
        yamlValueTransformer.ifJavaType(Double.class).supportParsedType(Double.class, Function.identity()).supportParsedType(Integer.class, Integer::doubleValue).supportParsedType(Long.class, Long::doubleValue);
        yamlValueTransformer.ifJavaType(Enum.class).supportParsedType(String.class, str -> ParameterValueParsing.parseEnum(str, javaType.getRawType()));
        yamlValueTransformer.ifJavaType(MessageLite.class).supportParsedType(String.class, str -> ParameterValueParsing.parseTextprotoMessage(str, javaType.getRawType())).supportParsedType(Map.class, map -> ParameterValueParsing.getProtoValueParser().parseProtobufMessage((Map<String, Object>)map, javaType.getRawType()));
        yamlValueTransformer.ifJavaType(byte[].class).supportParsedType(byte[].class, Function.identity()).supportParsedType(String.class, s -> s.getBytes(StandardCharsets.UTF_8));
        yamlValueTransformer.ifJavaType(ByteString.class).supportParsedType(String.class, ByteString::copyFromUtf8).supportParsedType(byte[].class, ByteString::copyFrom);
        yamlValueTransformer.ifJavaType(List.class).supportParsedType(List.class, list -> Lists.transform((List)list, e -> ParameterValueParsing.parseYamlObjectToJavaType(e, ParameterValueParsing.getGenericParameterType(javaType, 0))));
        yamlValueTransformer.ifJavaType(Map.class).supportParsedType(Map.class, map -> Maps.transformValues((Map)map, v -> ParameterValueParsing.parseYamlObjectToJavaType(v, ParameterValueParsing.getGenericParameterType(javaType, 1))));
        return yamlValueTransformer.transformedJavaValue();
    }

    private static TypeToken<?> getGenericParameterType(TypeToken<?> typeToken, int parameterIndex) {
        Preconditions.checkArgument((boolean)(typeToken.getType() instanceof ParameterizedType), (String)"Could not parse the generic parameter of type %s", typeToken);
        ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
        return TypeToken.of((Type)parameterizedType.getActualTypeArguments()[parameterIndex]);
    }

    static ProtoValueParsing getProtoValueParser() {
        try {
            Class<?> clazz = Class.forName("com.google.testing.junit.testparameterinjector.ProtoValueParsingImpl");
            return (ProtoValueParsing)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException unused) {
            throw new UnsupportedOperationException("Textproto support is not available when using the Android version of testparameterinjector.");
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ParameterValueParsing() {
    }

    private static final class YamlValueTransformer {
        private final Object parsedYaml;
        private final Class<?> javaType;
        @Nullable
        private Object transformedJavaValue;

        YamlValueTransformer(Object parsedYaml, Class<?> javaType) {
            this.parsedYaml = parsedYaml;
            this.javaType = javaType;
        }

        <JavaT> SupportedJavaType<JavaT> ifJavaType(Class<JavaT> supportedJavaType) {
            return new SupportedJavaType(supportedJavaType);
        }

        Object transformedJavaValue() {
            Preconditions.checkArgument((this.transformedJavaValue != null ? 1 : 0) != 0, (String)"Could not map YAML value %s (class = %s) to java class %s", (Object)this.parsedYaml, this.parsedYaml.getClass(), this.javaType);
            return this.transformedJavaValue;
        }

        final class SupportedJavaType<JavaT> {
            private final Class<JavaT> supportedJavaType;

            private SupportedJavaType(Class<JavaT> supportedJavaType) {
                this.supportedJavaType = supportedJavaType;
            }

            <ParsedYamlT> SupportedJavaType<JavaT> supportParsedType(Class<ParsedYamlT> parsedYamlType, Function<ParsedYamlT, JavaT> transformation) {
                if (Primitives.wrap(this.supportedJavaType).isAssignableFrom(Primitives.wrap((Class)YamlValueTransformer.this.javaType)) && Primitives.wrap(parsedYamlType).isInstance(YamlValueTransformer.this.parsedYaml)) {
                    Preconditions.checkState((YamlValueTransformer.this.transformedJavaValue == null ? 1 : 0) != 0, (Object)"This case is already handled. This is a bug in testparameterinjector.TestParametersMethodProcessor.");
                    YamlValueTransformer.this.transformedJavaValue = Preconditions.checkNotNull(transformation.apply(YamlValueTransformer.this.parsedYaml));
                }
                return this;
            }
        }
    }
}

