/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

final class Parser {
    static ParseResult parse(Iterable<? extends JavaFileObject> sources, String sourcesDescription) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        Context context = new Context();
        context.put(DiagnosticListener.class, diagnosticCollector);
        Log log = Log.instance(context);
        JavacFileManager unused = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        ParserFactory parserFactory = ParserFactory.instance(context);
        try {
            ArrayList<JCTree.JCCompilationUnit> parsedCompilationUnits = new ArrayList<JCTree.JCCompilationUnit>();
            for (JavaFileObject javaFileObject : sources) {
                log.useSource(javaFileObject);
                JavacParser parser = parserFactory.newParser(javaFileObject.getCharContent(false), true, true, true);
                JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
                unit.sourcefile = javaFileObject;
                parsedCompilationUnits.add(unit);
            }
            List<Diagnostic<? extends JavaFileObject>> diagnostics = diagnosticCollector.getDiagnostics();
            if (Parser.foundParseErrors(diagnostics)) {
                String string = String.format("Error while parsing %s:\n", sourcesDescription);
                throw new IllegalStateException(string + Joiner.on((char)'\n').join(diagnostics));
            }
            return new ParseResult(Parser.sortDiagnosticsByKind(diagnostics), parsedCompilationUnits, JavacTrees.instance(context));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean foundParseErrors(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return diagnostics.stream().anyMatch(d -> d.getKind().equals((Object)Diagnostic.Kind.ERROR));
    }

    private static ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> sortDiagnosticsByKind(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return Multimaps.index(diagnostics, input -> input.getKind());
    }

    private Parser() {
    }

    static final class ParseResult {
        private final ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics;
        private final ImmutableList<? extends CompilationUnitTree> compilationUnits;
        private final Trees trees;

        ParseResult(ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<? extends CompilationUnitTree> compilationUnits, Trees trees) {
            this.trees = trees;
            this.compilationUnits = ImmutableList.copyOf(compilationUnits);
            this.diagnostics = diagnostics;
        }

        ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnosticsByKind() {
            return this.diagnostics;
        }

        ImmutableList<? extends CompilationUnitTree> compilationUnits() {
            return this.compilationUnits;
        }

        Trees trees() {
            return this.trees;
        }
    }
}

