/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.slf4j;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Slf4jInjectionTypeListener
implements TypeListener {
    Slf4jInjectionTypeListener() {
    }

    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        for (final Field field : type.getRawType().getDeclaredFields()) {
            Class<?> typeOfField = field.getType();
            if (!Logger.class.isAssignableFrom(typeOfField)) continue;
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    try {
                        field.set(injectee, LoggerFactory.getLogger((Class)type.getRawType()));
                    }
                    catch (IllegalAccessException e) {
                        throw new ProvisionException("Unable to inject SLF4J logger", (Throwable)e);
                    }
                }
            });
        }
    }
}

