/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1;

import com.google.geo.type.Viewport;
import com.google.geo.type.ViewportOrBuilder;
import com.google.maps.places.v1.Circle;
import com.google.maps.places.v1.CircleOrBuilder;
import com.google.maps.places.v1.EVConnectorType;
import com.google.maps.places.v1.PlacesServiceProto;
import com.google.maps.places.v1.PriceLevel;
import com.google.maps.places.v1.SearchTextRequestOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SearchTextRequest
extends GeneratedMessageV3
implements SearchTextRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int TEXT_QUERY_FIELD_NUMBER = 1;
    private volatile Object textQuery_ = "";
    public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;
    private volatile Object languageCode_ = "";
    public static final int REGION_CODE_FIELD_NUMBER = 3;
    private volatile Object regionCode_ = "";
    public static final int RANK_PREFERENCE_FIELD_NUMBER = 4;
    private int rankPreference_ = 0;
    public static final int INCLUDED_TYPE_FIELD_NUMBER = 6;
    private volatile Object includedType_ = "";
    public static final int OPEN_NOW_FIELD_NUMBER = 7;
    private boolean openNow_ = false;
    public static final int MIN_RATING_FIELD_NUMBER = 9;
    private double minRating_ = 0.0;
    public static final int MAX_RESULT_COUNT_FIELD_NUMBER = 10;
    private int maxResultCount_ = 0;
    public static final int PRICE_LEVELS_FIELD_NUMBER = 11;
    private List<Integer> priceLevels_;
    private static final Internal.ListAdapter.Converter<Integer, PriceLevel> priceLevels_converter_ = new Internal.ListAdapter.Converter<Integer, PriceLevel>(){

        public PriceLevel convert(Integer from) {
            PriceLevel result = PriceLevel.forNumber(from);
            return result == null ? PriceLevel.UNRECOGNIZED : result;
        }
    };
    private int priceLevelsMemoizedSerializedSize;
    public static final int STRICT_TYPE_FILTERING_FIELD_NUMBER = 12;
    private boolean strictTypeFiltering_ = false;
    public static final int LOCATION_BIAS_FIELD_NUMBER = 13;
    private LocationBias locationBias_;
    public static final int LOCATION_RESTRICTION_FIELD_NUMBER = 14;
    private LocationRestriction locationRestriction_;
    public static final int EV_OPTIONS_FIELD_NUMBER = 15;
    private EVOptions evOptions_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SearchTextRequest DEFAULT_INSTANCE = new SearchTextRequest();
    private static final Parser<SearchTextRequest> PARSER = new AbstractParser<SearchTextRequest>(){

        public SearchTextRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SearchTextRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SearchTextRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SearchTextRequest() {
        this.textQuery_ = "";
        this.languageCode_ = "";
        this.regionCode_ = "";
        this.rankPreference_ = 0;
        this.includedType_ = "";
        this.priceLevels_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SearchTextRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchTextRequest.class, Builder.class);
    }

    @Override
    public String getTextQuery() {
        Object ref = this.textQuery_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.textQuery_ = s;
        return s;
    }

    @Override
    public ByteString getTextQueryBytes() {
        Object ref = this.textQuery_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.textQuery_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getLanguageCode() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.languageCode_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageCodeBytes() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.languageCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRegionCode() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.regionCode_ = s;
        return s;
    }

    @Override
    public ByteString getRegionCodeBytes() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.regionCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getRankPreferenceValue() {
        return this.rankPreference_;
    }

    @Override
    public RankPreference getRankPreference() {
        RankPreference result = RankPreference.forNumber(this.rankPreference_);
        return result == null ? RankPreference.UNRECOGNIZED : result;
    }

    @Override
    public String getIncludedType() {
        Object ref = this.includedType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.includedType_ = s;
        return s;
    }

    @Override
    public ByteString getIncludedTypeBytes() {
        Object ref = this.includedType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.includedType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getOpenNow() {
        return this.openNow_;
    }

    @Override
    public double getMinRating() {
        return this.minRating_;
    }

    @Override
    public int getMaxResultCount() {
        return this.maxResultCount_;
    }

    @Override
    public List<PriceLevel> getPriceLevelsList() {
        return new Internal.ListAdapter(this.priceLevels_, priceLevels_converter_);
    }

    @Override
    public int getPriceLevelsCount() {
        return this.priceLevels_.size();
    }

    @Override
    public PriceLevel getPriceLevels(int index) {
        return (PriceLevel)((Object)priceLevels_converter_.convert((Object)this.priceLevels_.get(index)));
    }

    @Override
    public List<Integer> getPriceLevelsValueList() {
        return this.priceLevels_;
    }

    @Override
    public int getPriceLevelsValue(int index) {
        return this.priceLevels_.get(index);
    }

    @Override
    public boolean getStrictTypeFiltering() {
        return this.strictTypeFiltering_;
    }

    @Override
    public boolean hasLocationBias() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public LocationBias getLocationBias() {
        return this.locationBias_ == null ? LocationBias.getDefaultInstance() : this.locationBias_;
    }

    @Override
    public LocationBiasOrBuilder getLocationBiasOrBuilder() {
        return this.locationBias_ == null ? LocationBias.getDefaultInstance() : this.locationBias_;
    }

    @Override
    public boolean hasLocationRestriction() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public LocationRestriction getLocationRestriction() {
        return this.locationRestriction_ == null ? LocationRestriction.getDefaultInstance() : this.locationRestriction_;
    }

    @Override
    public LocationRestrictionOrBuilder getLocationRestrictionOrBuilder() {
        return this.locationRestriction_ == null ? LocationRestriction.getDefaultInstance() : this.locationRestriction_;
    }

    @Override
    public boolean hasEvOptions() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public EVOptions getEvOptions() {
        return this.evOptions_ == null ? EVOptions.getDefaultInstance() : this.evOptions_;
    }

    @Override
    public EVOptionsOrBuilder getEvOptionsOrBuilder() {
        return this.evOptions_ == null ? EVOptions.getDefaultInstance() : this.evOptions_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.textQuery_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.textQuery_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.languageCode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.regionCode_);
        }
        if (this.rankPreference_ != RankPreference.RANK_PREFERENCE_UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.rankPreference_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.includedType_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.includedType_);
        }
        if (this.openNow_) {
            output.writeBool(7, this.openNow_);
        }
        if (Double.doubleToRawLongBits(this.minRating_) != 0L) {
            output.writeDouble(9, this.minRating_);
        }
        if (this.maxResultCount_ != 0) {
            output.writeInt32(10, this.maxResultCount_);
        }
        if (this.getPriceLevelsList().size() > 0) {
            output.writeUInt32NoTag(90);
            output.writeUInt32NoTag(this.priceLevelsMemoizedSerializedSize);
        }
        for (int i = 0; i < this.priceLevels_.size(); ++i) {
            output.writeEnumNoTag(this.priceLevels_.get(i).intValue());
        }
        if (this.strictTypeFiltering_) {
            output.writeBool(12, this.strictTypeFiltering_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(13, (MessageLite)this.getLocationBias());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(14, (MessageLite)this.getLocationRestriction());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(15, (MessageLite)this.getEvOptions());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.textQuery_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.textQuery_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.languageCode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.regionCode_);
        }
        if (this.rankPreference_ != RankPreference.RANK_PREFERENCE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.rankPreference_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.includedType_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.includedType_);
        }
        if (this.openNow_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.openNow_);
        }
        if (Double.doubleToRawLongBits(this.minRating_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)9, (double)this.minRating_);
        }
        if (this.maxResultCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)10, (int)this.maxResultCount_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.priceLevels_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.priceLevels_.get(i));
        }
        size += dataSize;
        if (!this.getPriceLevelsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.priceLevelsMemoizedSerializedSize = dataSize;
        if (this.strictTypeFiltering_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.strictTypeFiltering_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getLocationBias());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getLocationRestriction());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getEvOptions());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTextRequest)) {
            return super.equals(obj);
        }
        SearchTextRequest other = (SearchTextRequest)obj;
        if (!this.getTextQuery().equals(other.getTextQuery())) {
            return false;
        }
        if (!this.getLanguageCode().equals(other.getLanguageCode())) {
            return false;
        }
        if (!this.getRegionCode().equals(other.getRegionCode())) {
            return false;
        }
        if (this.rankPreference_ != other.rankPreference_) {
            return false;
        }
        if (!this.getIncludedType().equals(other.getIncludedType())) {
            return false;
        }
        if (this.getOpenNow() != other.getOpenNow()) {
            return false;
        }
        if (Double.doubleToLongBits(this.getMinRating()) != Double.doubleToLongBits(other.getMinRating())) {
            return false;
        }
        if (this.getMaxResultCount() != other.getMaxResultCount()) {
            return false;
        }
        if (!this.priceLevels_.equals(other.priceLevels_)) {
            return false;
        }
        if (this.getStrictTypeFiltering() != other.getStrictTypeFiltering()) {
            return false;
        }
        if (this.hasLocationBias() != other.hasLocationBias()) {
            return false;
        }
        if (this.hasLocationBias() && !this.getLocationBias().equals(other.getLocationBias())) {
            return false;
        }
        if (this.hasLocationRestriction() != other.hasLocationRestriction()) {
            return false;
        }
        if (this.hasLocationRestriction() && !this.getLocationRestriction().equals(other.getLocationRestriction())) {
            return false;
        }
        if (this.hasEvOptions() != other.hasEvOptions()) {
            return false;
        }
        if (this.hasEvOptions() && !this.getEvOptions().equals(other.getEvOptions())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SearchTextRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTextQuery().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getLanguageCode().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getRegionCode().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.rankPreference_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getIncludedType().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getOpenNow());
        hash = 37 * hash + 9;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getMinRating()));
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getMaxResultCount();
        if (this.getPriceLevelsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.priceLevels_.hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getStrictTypeFiltering());
        if (this.hasLocationBias()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getLocationBias().hashCode();
        }
        if (this.hasLocationRestriction()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getLocationRestriction().hashCode();
        }
        if (this.hasEvOptions()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getEvOptions().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SearchTextRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data);
    }

    public static SearchTextRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchTextRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data);
    }

    public static SearchTextRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchTextRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data);
    }

    public static SearchTextRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchTextRequest parseFrom(InputStream input) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SearchTextRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchTextRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SearchTextRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchTextRequest parseFrom(CodedInputStream input) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SearchTextRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SearchTextRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SearchTextRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SearchTextRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SearchTextRequest> parser() {
        return PARSER;
    }

    public Parser<SearchTextRequest> getParserForType() {
        return PARSER;
    }

    public SearchTextRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SearchTextRequestOrBuilder {
        private int bitField0_;
        private Object textQuery_ = "";
        private Object languageCode_ = "";
        private Object regionCode_ = "";
        private int rankPreference_ = 0;
        private Object includedType_ = "";
        private boolean openNow_;
        private double minRating_;
        private int maxResultCount_;
        private List<Integer> priceLevels_ = Collections.emptyList();
        private boolean strictTypeFiltering_;
        private LocationBias locationBias_;
        private SingleFieldBuilderV3<LocationBias, LocationBias.Builder, LocationBiasOrBuilder> locationBiasBuilder_;
        private LocationRestriction locationRestriction_;
        private SingleFieldBuilderV3<LocationRestriction, LocationRestriction.Builder, LocationRestrictionOrBuilder> locationRestrictionBuilder_;
        private EVOptions evOptions_;
        private SingleFieldBuilderV3<EVOptions, EVOptions.Builder, EVOptionsOrBuilder> evOptionsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchTextRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLocationBiasFieldBuilder();
                this.getLocationRestrictionFieldBuilder();
                this.getEvOptionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.textQuery_ = "";
            this.languageCode_ = "";
            this.regionCode_ = "";
            this.rankPreference_ = 0;
            this.includedType_ = "";
            this.openNow_ = false;
            this.minRating_ = 0.0;
            this.maxResultCount_ = 0;
            this.priceLevels_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.strictTypeFiltering_ = false;
            this.locationBias_ = null;
            if (this.locationBiasBuilder_ != null) {
                this.locationBiasBuilder_.dispose();
                this.locationBiasBuilder_ = null;
            }
            this.locationRestriction_ = null;
            if (this.locationRestrictionBuilder_ != null) {
                this.locationRestrictionBuilder_.dispose();
                this.locationRestrictionBuilder_ = null;
            }
            this.evOptions_ = null;
            if (this.evOptionsBuilder_ != null) {
                this.evOptionsBuilder_.dispose();
                this.evOptionsBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_descriptor;
        }

        public SearchTextRequest getDefaultInstanceForType() {
            return SearchTextRequest.getDefaultInstance();
        }

        public SearchTextRequest build() {
            SearchTextRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SearchTextRequest buildPartial() {
            SearchTextRequest result = new SearchTextRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(SearchTextRequest result) {
            if ((this.bitField0_ & 0x100) != 0) {
                this.priceLevels_ = Collections.unmodifiableList(this.priceLevels_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.priceLevels_ = this.priceLevels_;
        }

        private void buildPartial0(SearchTextRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.textQuery_ = this.textQuery_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.languageCode_ = this.languageCode_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.regionCode_ = this.regionCode_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.rankPreference_ = this.rankPreference_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.includedType_ = this.includedType_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.openNow_ = this.openNow_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.minRating_ = this.minRating_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.maxResultCount_ = this.maxResultCount_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.strictTypeFiltering_ = this.strictTypeFiltering_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x400) != 0) {
                result.locationBias_ = this.locationBiasBuilder_ == null ? this.locationBias_ : (LocationBias)this.locationBiasBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.locationRestriction_ = this.locationRestrictionBuilder_ == null ? this.locationRestriction_ : (LocationRestriction)this.locationRestrictionBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.evOptions_ = this.evOptionsBuilder_ == null ? this.evOptions_ : (EVOptions)this.evOptionsBuilder_.build();
                to_bitField0_ |= 4;
            }
            SearchTextRequest searchTextRequest = result;
            searchTextRequest.bitField0_ = searchTextRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SearchTextRequest) {
                return this.mergeFrom((SearchTextRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SearchTextRequest other) {
            if (other == SearchTextRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getTextQuery().isEmpty()) {
                this.textQuery_ = other.textQuery_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getLanguageCode().isEmpty()) {
                this.languageCode_ = other.languageCode_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getRegionCode().isEmpty()) {
                this.regionCode_ = other.regionCode_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.rankPreference_ != 0) {
                this.setRankPreferenceValue(other.getRankPreferenceValue());
            }
            if (!other.getIncludedType().isEmpty()) {
                this.includedType_ = other.includedType_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.getOpenNow()) {
                this.setOpenNow(other.getOpenNow());
            }
            if (other.getMinRating() != 0.0) {
                this.setMinRating(other.getMinRating());
            }
            if (other.getMaxResultCount() != 0) {
                this.setMaxResultCount(other.getMaxResultCount());
            }
            if (!other.priceLevels_.isEmpty()) {
                if (this.priceLevels_.isEmpty()) {
                    this.priceLevels_ = other.priceLevels_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensurePriceLevelsIsMutable();
                    this.priceLevels_.addAll(other.priceLevels_);
                }
                this.onChanged();
            }
            if (other.getStrictTypeFiltering()) {
                this.setStrictTypeFiltering(other.getStrictTypeFiltering());
            }
            if (other.hasLocationBias()) {
                this.mergeLocationBias(other.getLocationBias());
            }
            if (other.hasLocationRestriction()) {
                this.mergeLocationRestriction(other.getLocationRestriction());
            }
            if (other.hasEvOptions()) {
                this.mergeEvOptions(other.getEvOptions());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 10: {
                            this.textQuery_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 18: {
                            this.languageCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                        case 26: {
                            this.regionCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 32: {
                            this.rankPreference_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 50: {
                            this.includedType_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 56: {
                            this.openNow_ = input.readBool();
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 73: {
                            this.minRating_ = input.readDouble();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 80: {
                            this.maxResultCount_ = input.readInt32();
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 88: {
                            int tmpRaw = input.readEnum();
                            this.ensurePriceLevelsIsMutable();
                            this.priceLevels_.add(tmpRaw);
                            continue block22;
                        }
                        case 90: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePriceLevelsIsMutable();
                                this.priceLevels_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block22;
                        }
                        case 96: {
                            this.strictTypeFiltering_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block22;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getLocationBiasFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getLocationRestrictionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getEvOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getTextQuery() {
            Object ref = this.textQuery_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.textQuery_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTextQueryBytes() {
            Object ref = this.textQuery_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.textQuery_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTextQuery(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.textQuery_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTextQuery() {
            this.textQuery_ = SearchTextRequest.getDefaultInstance().getTextQuery();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setTextQueryBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.textQuery_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getLanguageCode() {
            Object ref = this.languageCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.languageCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageCodeBytes() {
            Object ref = this.languageCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.languageCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguageCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.languageCode_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearLanguageCode() {
            this.languageCode_ = SearchTextRequest.getDefaultInstance().getLanguageCode();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setLanguageCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.languageCode_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getRegionCode() {
            Object ref = this.regionCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.regionCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRegionCodeBytes() {
            Object ref = this.regionCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.regionCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRegionCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.regionCode_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearRegionCode() {
            this.regionCode_ = SearchTextRequest.getDefaultInstance().getRegionCode();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setRegionCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.regionCode_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getRankPreferenceValue() {
            return this.rankPreference_;
        }

        public Builder setRankPreferenceValue(int value) {
            this.rankPreference_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public RankPreference getRankPreference() {
            RankPreference result = RankPreference.forNumber(this.rankPreference_);
            return result == null ? RankPreference.UNRECOGNIZED : result;
        }

        public Builder setRankPreference(RankPreference value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.rankPreference_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRankPreference() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.rankPreference_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getIncludedType() {
            Object ref = this.includedType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.includedType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIncludedTypeBytes() {
            Object ref = this.includedType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.includedType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setIncludedType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.includedType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearIncludedType() {
            this.includedType_ = SearchTextRequest.getDefaultInstance().getIncludedType();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setIncludedTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.includedType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getOpenNow() {
            return this.openNow_;
        }

        public Builder setOpenNow(boolean value) {
            this.openNow_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearOpenNow() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.openNow_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public double getMinRating() {
            return this.minRating_;
        }

        public Builder setMinRating(double value) {
            this.minRating_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearMinRating() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.minRating_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public int getMaxResultCount() {
            return this.maxResultCount_;
        }

        public Builder setMaxResultCount(int value) {
            this.maxResultCount_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearMaxResultCount() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.maxResultCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePriceLevelsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.priceLevels_ = new ArrayList<Integer>(this.priceLevels_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<PriceLevel> getPriceLevelsList() {
            return new Internal.ListAdapter(this.priceLevels_, priceLevels_converter_);
        }

        @Override
        public int getPriceLevelsCount() {
            return this.priceLevels_.size();
        }

        @Override
        public PriceLevel getPriceLevels(int index) {
            return (PriceLevel)((Object)priceLevels_converter_.convert((Object)this.priceLevels_.get(index)));
        }

        public Builder setPriceLevels(int index, PriceLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePriceLevelsIsMutable();
            this.priceLevels_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPriceLevels(PriceLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePriceLevelsIsMutable();
            this.priceLevels_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPriceLevels(Iterable<? extends PriceLevel> values) {
            this.ensurePriceLevelsIsMutable();
            for (PriceLevel priceLevel : values) {
                this.priceLevels_.add(priceLevel.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPriceLevels() {
            this.priceLevels_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPriceLevelsValueList() {
            return Collections.unmodifiableList(this.priceLevels_);
        }

        @Override
        public int getPriceLevelsValue(int index) {
            return this.priceLevels_.get(index);
        }

        public Builder setPriceLevelsValue(int index, int value) {
            this.ensurePriceLevelsIsMutable();
            this.priceLevels_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPriceLevelsValue(int value) {
            this.ensurePriceLevelsIsMutable();
            this.priceLevels_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPriceLevelsValue(Iterable<Integer> values) {
            this.ensurePriceLevelsIsMutable();
            for (int value : values) {
                this.priceLevels_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean getStrictTypeFiltering() {
            return this.strictTypeFiltering_;
        }

        public Builder setStrictTypeFiltering(boolean value) {
            this.strictTypeFiltering_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearStrictTypeFiltering() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.strictTypeFiltering_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLocationBias() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public LocationBias getLocationBias() {
            if (this.locationBiasBuilder_ == null) {
                return this.locationBias_ == null ? LocationBias.getDefaultInstance() : this.locationBias_;
            }
            return (LocationBias)this.locationBiasBuilder_.getMessage();
        }

        public Builder setLocationBias(LocationBias value) {
            if (this.locationBiasBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.locationBias_ = value;
            } else {
                this.locationBiasBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setLocationBias(LocationBias.Builder builderForValue) {
            if (this.locationBiasBuilder_ == null) {
                this.locationBias_ = builderForValue.build();
            } else {
                this.locationBiasBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeLocationBias(LocationBias value) {
            if (this.locationBiasBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.locationBias_ != null && this.locationBias_ != LocationBias.getDefaultInstance()) {
                    this.getLocationBiasBuilder().mergeFrom(value);
                } else {
                    this.locationBias_ = value;
                }
            } else {
                this.locationBiasBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.locationBias_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLocationBias() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.locationBias_ = null;
            if (this.locationBiasBuilder_ != null) {
                this.locationBiasBuilder_.dispose();
                this.locationBiasBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LocationBias.Builder getLocationBiasBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (LocationBias.Builder)this.getLocationBiasFieldBuilder().getBuilder();
        }

        @Override
        public LocationBiasOrBuilder getLocationBiasOrBuilder() {
            if (this.locationBiasBuilder_ != null) {
                return (LocationBiasOrBuilder)this.locationBiasBuilder_.getMessageOrBuilder();
            }
            return this.locationBias_ == null ? LocationBias.getDefaultInstance() : this.locationBias_;
        }

        private SingleFieldBuilderV3<LocationBias, LocationBias.Builder, LocationBiasOrBuilder> getLocationBiasFieldBuilder() {
            if (this.locationBiasBuilder_ == null) {
                this.locationBiasBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocationBias(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.locationBias_ = null;
            }
            return this.locationBiasBuilder_;
        }

        @Override
        public boolean hasLocationRestriction() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public LocationRestriction getLocationRestriction() {
            if (this.locationRestrictionBuilder_ == null) {
                return this.locationRestriction_ == null ? LocationRestriction.getDefaultInstance() : this.locationRestriction_;
            }
            return (LocationRestriction)this.locationRestrictionBuilder_.getMessage();
        }

        public Builder setLocationRestriction(LocationRestriction value) {
            if (this.locationRestrictionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.locationRestriction_ = value;
            } else {
                this.locationRestrictionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setLocationRestriction(LocationRestriction.Builder builderForValue) {
            if (this.locationRestrictionBuilder_ == null) {
                this.locationRestriction_ = builderForValue.build();
            } else {
                this.locationRestrictionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeLocationRestriction(LocationRestriction value) {
            if (this.locationRestrictionBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.locationRestriction_ != null && this.locationRestriction_ != LocationRestriction.getDefaultInstance()) {
                    this.getLocationRestrictionBuilder().mergeFrom(value);
                } else {
                    this.locationRestriction_ = value;
                }
            } else {
                this.locationRestrictionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.locationRestriction_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLocationRestriction() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.locationRestriction_ = null;
            if (this.locationRestrictionBuilder_ != null) {
                this.locationRestrictionBuilder_.dispose();
                this.locationRestrictionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LocationRestriction.Builder getLocationRestrictionBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (LocationRestriction.Builder)this.getLocationRestrictionFieldBuilder().getBuilder();
        }

        @Override
        public LocationRestrictionOrBuilder getLocationRestrictionOrBuilder() {
            if (this.locationRestrictionBuilder_ != null) {
                return (LocationRestrictionOrBuilder)this.locationRestrictionBuilder_.getMessageOrBuilder();
            }
            return this.locationRestriction_ == null ? LocationRestriction.getDefaultInstance() : this.locationRestriction_;
        }

        private SingleFieldBuilderV3<LocationRestriction, LocationRestriction.Builder, LocationRestrictionOrBuilder> getLocationRestrictionFieldBuilder() {
            if (this.locationRestrictionBuilder_ == null) {
                this.locationRestrictionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocationRestriction(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.locationRestriction_ = null;
            }
            return this.locationRestrictionBuilder_;
        }

        @Override
        public boolean hasEvOptions() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public EVOptions getEvOptions() {
            if (this.evOptionsBuilder_ == null) {
                return this.evOptions_ == null ? EVOptions.getDefaultInstance() : this.evOptions_;
            }
            return (EVOptions)this.evOptionsBuilder_.getMessage();
        }

        public Builder setEvOptions(EVOptions value) {
            if (this.evOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.evOptions_ = value;
            } else {
                this.evOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setEvOptions(EVOptions.Builder builderForValue) {
            if (this.evOptionsBuilder_ == null) {
                this.evOptions_ = builderForValue.build();
            } else {
                this.evOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeEvOptions(EVOptions value) {
            if (this.evOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.evOptions_ != null && this.evOptions_ != EVOptions.getDefaultInstance()) {
                    this.getEvOptionsBuilder().mergeFrom(value);
                } else {
                    this.evOptions_ = value;
                }
            } else {
                this.evOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.evOptions_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEvOptions() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.evOptions_ = null;
            if (this.evOptionsBuilder_ != null) {
                this.evOptionsBuilder_.dispose();
                this.evOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public EVOptions.Builder getEvOptionsBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (EVOptions.Builder)this.getEvOptionsFieldBuilder().getBuilder();
        }

        @Override
        public EVOptionsOrBuilder getEvOptionsOrBuilder() {
            if (this.evOptionsBuilder_ != null) {
                return (EVOptionsOrBuilder)this.evOptionsBuilder_.getMessageOrBuilder();
            }
            return this.evOptions_ == null ? EVOptions.getDefaultInstance() : this.evOptions_;
        }

        private SingleFieldBuilderV3<EVOptions, EVOptions.Builder, EVOptionsOrBuilder> getEvOptionsFieldBuilder() {
            if (this.evOptionsBuilder_ == null) {
                this.evOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEvOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.evOptions_ = null;
            }
            return this.evOptionsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class EVOptions
    extends GeneratedMessageV3
    implements EVOptionsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int MINIMUM_CHARGING_RATE_KW_FIELD_NUMBER = 1;
        private double minimumChargingRateKw_ = 0.0;
        public static final int CONNECTOR_TYPES_FIELD_NUMBER = 2;
        private List<Integer> connectorTypes_;
        private static final Internal.ListAdapter.Converter<Integer, EVConnectorType> connectorTypes_converter_ = new Internal.ListAdapter.Converter<Integer, EVConnectorType>(){

            public EVConnectorType convert(Integer from) {
                EVConnectorType result = EVConnectorType.forNumber(from);
                return result == null ? EVConnectorType.UNRECOGNIZED : result;
            }
        };
        private int connectorTypesMemoizedSerializedSize;
        private byte memoizedIsInitialized = (byte)-1;
        private static final EVOptions DEFAULT_INSTANCE = new EVOptions();
        private static final Parser<EVOptions> PARSER = new AbstractParser<EVOptions>(){

            public EVOptions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = EVOptions.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private EVOptions(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private EVOptions() {
            this.connectorTypes_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new EVOptions();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_EVOptions_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_EVOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(EVOptions.class, Builder.class);
        }

        @Override
        public double getMinimumChargingRateKw() {
            return this.minimumChargingRateKw_;
        }

        @Override
        public List<EVConnectorType> getConnectorTypesList() {
            return new Internal.ListAdapter(this.connectorTypes_, connectorTypes_converter_);
        }

        @Override
        public int getConnectorTypesCount() {
            return this.connectorTypes_.size();
        }

        @Override
        public EVConnectorType getConnectorTypes(int index) {
            return (EVConnectorType)((Object)connectorTypes_converter_.convert((Object)this.connectorTypes_.get(index)));
        }

        @Override
        public List<Integer> getConnectorTypesValueList() {
            return this.connectorTypes_;
        }

        @Override
        public int getConnectorTypesValue(int index) {
            return this.connectorTypes_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            this.getSerializedSize();
            if (Double.doubleToRawLongBits(this.minimumChargingRateKw_) != 0L) {
                output.writeDouble(1, this.minimumChargingRateKw_);
            }
            if (this.getConnectorTypesList().size() > 0) {
                output.writeUInt32NoTag(18);
                output.writeUInt32NoTag(this.connectorTypesMemoizedSerializedSize);
            }
            for (int i = 0; i < this.connectorTypes_.size(); ++i) {
                output.writeEnumNoTag(this.connectorTypes_.get(i).intValue());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (Double.doubleToRawLongBits(this.minimumChargingRateKw_) != 0L) {
                size += CodedOutputStream.computeDoubleSize((int)1, (double)this.minimumChargingRateKw_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.connectorTypes_.size(); ++i) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.connectorTypes_.get(i));
            }
            size += dataSize;
            if (!this.getConnectorTypesList().isEmpty()) {
                ++size;
                size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
            }
            this.connectorTypesMemoizedSerializedSize = dataSize;
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EVOptions)) {
                return super.equals(obj);
            }
            EVOptions other = (EVOptions)obj;
            if (Double.doubleToLongBits(this.getMinimumChargingRateKw()) != Double.doubleToLongBits(other.getMinimumChargingRateKw())) {
                return false;
            }
            if (!this.connectorTypes_.equals(other.connectorTypes_)) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + EVOptions.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getMinimumChargingRateKw()));
            if (this.getConnectorTypesCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.connectorTypes_.hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static EVOptions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data);
        }

        public static EVOptions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static EVOptions parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data);
        }

        public static EVOptions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static EVOptions parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data);
        }

        public static EVOptions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (EVOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static EVOptions parseFrom(InputStream input) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static EVOptions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static EVOptions parseDelimitedFrom(InputStream input) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static EVOptions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static EVOptions parseFrom(CodedInputStream input) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static EVOptions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (EVOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return EVOptions.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(EVOptions prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static EVOptions getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<EVOptions> parser() {
            return PARSER;
        }

        public Parser<EVOptions> getParserForType() {
            return PARSER;
        }

        public EVOptions getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements EVOptionsOrBuilder {
            private int bitField0_;
            private double minimumChargingRateKw_;
            private List<Integer> connectorTypes_ = Collections.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_EVOptions_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_EVOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(EVOptions.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.minimumChargingRateKw_ = 0.0;
                this.connectorTypes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_EVOptions_descriptor;
            }

            public EVOptions getDefaultInstanceForType() {
                return EVOptions.getDefaultInstance();
            }

            public EVOptions build() {
                EVOptions result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public EVOptions buildPartial() {
                EVOptions result = new EVOptions(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(EVOptions result) {
                if ((this.bitField0_ & 2) != 0) {
                    this.connectorTypes_ = Collections.unmodifiableList(this.connectorTypes_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.connectorTypes_ = this.connectorTypes_;
            }

            private void buildPartial0(EVOptions result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.minimumChargingRateKw_ = this.minimumChargingRateKw_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof EVOptions) {
                    return this.mergeFrom((EVOptions)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(EVOptions other) {
                if (other == EVOptions.getDefaultInstance()) {
                    return this;
                }
                if (other.getMinimumChargingRateKw() != 0.0) {
                    this.setMinimumChargingRateKw(other.getMinimumChargingRateKw());
                }
                if (!other.connectorTypes_.isEmpty()) {
                    if (this.connectorTypes_.isEmpty()) {
                        this.connectorTypes_ = other.connectorTypes_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureConnectorTypesIsMutable();
                        this.connectorTypes_.addAll(other.connectorTypes_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 9: {
                                this.minimumChargingRateKw_ = input.readDouble();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 16: {
                                int tmpRaw = input.readEnum();
                                this.ensureConnectorTypesIsMutable();
                                this.connectorTypes_.add(tmpRaw);
                                continue block11;
                            }
                            case 18: {
                                int length = input.readRawVarint32();
                                int oldLimit = input.pushLimit(length);
                                while (input.getBytesUntilLimit() > 0) {
                                    int tmpRaw = input.readEnum();
                                    this.ensureConnectorTypesIsMutable();
                                    this.connectorTypes_.add(tmpRaw);
                                }
                                input.popLimit(oldLimit);
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public double getMinimumChargingRateKw() {
                return this.minimumChargingRateKw_;
            }

            public Builder setMinimumChargingRateKw(double value) {
                this.minimumChargingRateKw_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearMinimumChargingRateKw() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.minimumChargingRateKw_ = 0.0;
                this.onChanged();
                return this;
            }

            private void ensureConnectorTypesIsMutable() {
                if ((this.bitField0_ & 2) == 0) {
                    this.connectorTypes_ = new ArrayList<Integer>(this.connectorTypes_);
                    this.bitField0_ |= 2;
                }
            }

            @Override
            public List<EVConnectorType> getConnectorTypesList() {
                return new Internal.ListAdapter(this.connectorTypes_, connectorTypes_converter_);
            }

            @Override
            public int getConnectorTypesCount() {
                return this.connectorTypes_.size();
            }

            @Override
            public EVConnectorType getConnectorTypes(int index) {
                return (EVConnectorType)((Object)connectorTypes_converter_.convert((Object)this.connectorTypes_.get(index)));
            }

            public Builder setConnectorTypes(int index, EVConnectorType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConnectorTypesIsMutable();
                this.connectorTypes_.set(index, value.getNumber());
                this.onChanged();
                return this;
            }

            public Builder addConnectorTypes(EVConnectorType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConnectorTypesIsMutable();
                this.connectorTypes_.add(value.getNumber());
                this.onChanged();
                return this;
            }

            public Builder addAllConnectorTypes(Iterable<? extends EVConnectorType> values) {
                this.ensureConnectorTypesIsMutable();
                for (EVConnectorType eVConnectorType : values) {
                    this.connectorTypes_.add(eVConnectorType.getNumber());
                }
                this.onChanged();
                return this;
            }

            public Builder clearConnectorTypes() {
                this.connectorTypes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            @Override
            public List<Integer> getConnectorTypesValueList() {
                return Collections.unmodifiableList(this.connectorTypes_);
            }

            @Override
            public int getConnectorTypesValue(int index) {
                return this.connectorTypes_.get(index);
            }

            public Builder setConnectorTypesValue(int index, int value) {
                this.ensureConnectorTypesIsMutable();
                this.connectorTypes_.set(index, value);
                this.onChanged();
                return this;
            }

            public Builder addConnectorTypesValue(int value) {
                this.ensureConnectorTypesIsMutable();
                this.connectorTypes_.add(value);
                this.onChanged();
                return this;
            }

            public Builder addAllConnectorTypesValue(Iterable<Integer> values) {
                this.ensureConnectorTypesIsMutable();
                for (int value : values) {
                    this.connectorTypes_.add(value);
                }
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface EVOptionsOrBuilder
    extends MessageOrBuilder {
        public double getMinimumChargingRateKw();

        public List<EVConnectorType> getConnectorTypesList();

        public int getConnectorTypesCount();

        public EVConnectorType getConnectorTypes(int var1);

        public List<Integer> getConnectorTypesValueList();

        public int getConnectorTypesValue(int var1);
    }

    public static final class LocationRestriction
    extends GeneratedMessageV3
    implements LocationRestrictionOrBuilder {
        private static final long serialVersionUID = 0L;
        private int typeCase_ = 0;
        private Object type_;
        public static final int RECTANGLE_FIELD_NUMBER = 1;
        private byte memoizedIsInitialized = (byte)-1;
        private static final LocationRestriction DEFAULT_INSTANCE = new LocationRestriction();
        private static final Parser<LocationRestriction> PARSER = new AbstractParser<LocationRestriction>(){

            public LocationRestriction parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = LocationRestriction.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private LocationRestriction(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private LocationRestriction() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new LocationRestriction();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationRestriction_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationRestriction_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationRestriction.class, Builder.class);
        }

        @Override
        public TypeCase getTypeCase() {
            return TypeCase.forNumber(this.typeCase_);
        }

        @Override
        public boolean hasRectangle() {
            return this.typeCase_ == 1;
        }

        @Override
        public Viewport getRectangle() {
            if (this.typeCase_ == 1) {
                return (Viewport)this.type_;
            }
            return Viewport.getDefaultInstance();
        }

        @Override
        public ViewportOrBuilder getRectangleOrBuilder() {
            if (this.typeCase_ == 1) {
                return (Viewport)this.type_;
            }
            return Viewport.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.typeCase_ == 1) {
                output.writeMessage(1, (MessageLite)((Viewport)this.type_));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.typeCase_ == 1) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((Viewport)this.type_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LocationRestriction)) {
                return super.equals(obj);
            }
            LocationRestriction other = (LocationRestriction)obj;
            if (!this.getTypeCase().equals((Object)other.getTypeCase())) {
                return false;
            }
            switch (this.typeCase_) {
                case 1: {
                    if (this.getRectangle().equals((Object)other.getRectangle())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + LocationRestriction.getDescriptor().hashCode();
            switch (this.typeCase_) {
                case 1: {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getRectangle().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static LocationRestriction parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data);
        }

        public static LocationRestriction parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationRestriction parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data);
        }

        public static LocationRestriction parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationRestriction parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data);
        }

        public static LocationRestriction parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationRestriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationRestriction parseFrom(InputStream input) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static LocationRestriction parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationRestriction parseDelimitedFrom(InputStream input) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static LocationRestriction parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationRestriction parseFrom(CodedInputStream input) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static LocationRestriction parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationRestriction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return LocationRestriction.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(LocationRestriction prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static LocationRestriction getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<LocationRestriction> parser() {
            return PARSER;
        }

        public Parser<LocationRestriction> getParserForType() {
            return PARSER;
        }

        public LocationRestriction getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LocationRestrictionOrBuilder {
            private int typeCase_ = 0;
            private Object type_;
            private int bitField0_;
            private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> rectangleBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationRestriction_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationRestriction_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationRestriction.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.rectangleBuilder_ != null) {
                    this.rectangleBuilder_.clear();
                }
                this.typeCase_ = 0;
                this.type_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationRestriction_descriptor;
            }

            public LocationRestriction getDefaultInstanceForType() {
                return LocationRestriction.getDefaultInstance();
            }

            public LocationRestriction build() {
                LocationRestriction result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public LocationRestriction buildPartial() {
                LocationRestriction result = new LocationRestriction(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(LocationRestriction result) {
                int from_bitField0_ = this.bitField0_;
            }

            private void buildPartialOneofs(LocationRestriction result) {
                result.typeCase_ = this.typeCase_;
                result.type_ = this.type_;
                if (this.typeCase_ == 1 && this.rectangleBuilder_ != null) {
                    result.type_ = this.rectangleBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof LocationRestriction) {
                    return this.mergeFrom((LocationRestriction)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(LocationRestriction other) {
                if (other == LocationRestriction.getDefaultInstance()) {
                    return this;
                }
                switch (other.getTypeCase()) {
                    case RECTANGLE: {
                        this.mergeRectangle(other.getRectangle());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getRectangleFieldBuilder().getBuilder(), extensionRegistry);
                                this.typeCase_ = 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public TypeCase getTypeCase() {
                return TypeCase.forNumber(this.typeCase_);
            }

            public Builder clearType() {
                this.typeCase_ = 0;
                this.type_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRectangle() {
                return this.typeCase_ == 1;
            }

            @Override
            public Viewport getRectangle() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ == 1) {
                        return (Viewport)this.type_;
                    }
                    return Viewport.getDefaultInstance();
                }
                if (this.typeCase_ == 1) {
                    return (Viewport)this.rectangleBuilder_.getMessage();
                }
                return Viewport.getDefaultInstance();
            }

            public Builder setRectangle(Viewport value) {
                if (this.rectangleBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.type_ = value;
                    this.onChanged();
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder setRectangle(Viewport.Builder builderForValue) {
                if (this.rectangleBuilder_ == null) {
                    this.type_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder mergeRectangle(Viewport value) {
                if (this.rectangleBuilder_ == null) {
                    this.type_ = this.typeCase_ == 1 && this.type_ != Viewport.getDefaultInstance() ? Viewport.newBuilder((Viewport)((Viewport)this.type_)).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.typeCase_ == 1) {
                    this.rectangleBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder clearRectangle() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ == 1) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.typeCase_ == 1) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                    }
                    this.rectangleBuilder_.clear();
                }
                return this;
            }

            public Viewport.Builder getRectangleBuilder() {
                return (Viewport.Builder)this.getRectangleFieldBuilder().getBuilder();
            }

            @Override
            public ViewportOrBuilder getRectangleOrBuilder() {
                if (this.typeCase_ == 1 && this.rectangleBuilder_ != null) {
                    return (ViewportOrBuilder)this.rectangleBuilder_.getMessageOrBuilder();
                }
                if (this.typeCase_ == 1) {
                    return (Viewport)this.type_;
                }
                return Viewport.getDefaultInstance();
            }

            private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> getRectangleFieldBuilder() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ != 1) {
                        this.type_ = Viewport.getDefaultInstance();
                    }
                    this.rectangleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Viewport)this.type_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.type_ = null;
                }
                this.typeCase_ = 1;
                this.onChanged();
                return this.rectangleBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum TypeCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            RECTANGLE(1),
            TYPE_NOT_SET(0);

            private final int value;

            private TypeCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static TypeCase valueOf(int value) {
                return TypeCase.forNumber(value);
            }

            public static TypeCase forNumber(int value) {
                switch (value) {
                    case 1: {
                        return RECTANGLE;
                    }
                    case 0: {
                        return TYPE_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static interface LocationRestrictionOrBuilder
    extends MessageOrBuilder {
        public boolean hasRectangle();

        public Viewport getRectangle();

        public ViewportOrBuilder getRectangleOrBuilder();

        public LocationRestriction.TypeCase getTypeCase();
    }

    public static final class LocationBias
    extends GeneratedMessageV3
    implements LocationBiasOrBuilder {
        private static final long serialVersionUID = 0L;
        private int typeCase_ = 0;
        private Object type_;
        public static final int RECTANGLE_FIELD_NUMBER = 1;
        public static final int CIRCLE_FIELD_NUMBER = 2;
        private byte memoizedIsInitialized = (byte)-1;
        private static final LocationBias DEFAULT_INSTANCE = new LocationBias();
        private static final Parser<LocationBias> PARSER = new AbstractParser<LocationBias>(){

            public LocationBias parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = LocationBias.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private LocationBias(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private LocationBias() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new LocationBias();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationBias_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationBias_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationBias.class, Builder.class);
        }

        @Override
        public TypeCase getTypeCase() {
            return TypeCase.forNumber(this.typeCase_);
        }

        @Override
        public boolean hasRectangle() {
            return this.typeCase_ == 1;
        }

        @Override
        public Viewport getRectangle() {
            if (this.typeCase_ == 1) {
                return (Viewport)this.type_;
            }
            return Viewport.getDefaultInstance();
        }

        @Override
        public ViewportOrBuilder getRectangleOrBuilder() {
            if (this.typeCase_ == 1) {
                return (Viewport)this.type_;
            }
            return Viewport.getDefaultInstance();
        }

        @Override
        public boolean hasCircle() {
            return this.typeCase_ == 2;
        }

        @Override
        public Circle getCircle() {
            if (this.typeCase_ == 2) {
                return (Circle)this.type_;
            }
            return Circle.getDefaultInstance();
        }

        @Override
        public CircleOrBuilder getCircleOrBuilder() {
            if (this.typeCase_ == 2) {
                return (Circle)this.type_;
            }
            return Circle.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.typeCase_ == 1) {
                output.writeMessage(1, (MessageLite)((Viewport)this.type_));
            }
            if (this.typeCase_ == 2) {
                output.writeMessage(2, (MessageLite)((Circle)this.type_));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.typeCase_ == 1) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((Viewport)this.type_));
            }
            if (this.typeCase_ == 2) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((Circle)this.type_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LocationBias)) {
                return super.equals(obj);
            }
            LocationBias other = (LocationBias)obj;
            if (!this.getTypeCase().equals((Object)other.getTypeCase())) {
                return false;
            }
            switch (this.typeCase_) {
                case 1: {
                    if (this.getRectangle().equals((Object)other.getRectangle())) break;
                    return false;
                }
                case 2: {
                    if (this.getCircle().equals(other.getCircle())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + LocationBias.getDescriptor().hashCode();
            switch (this.typeCase_) {
                case 1: {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getRectangle().hashCode();
                    break;
                }
                case 2: {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getCircle().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static LocationBias parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data);
        }

        public static LocationBias parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationBias parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data);
        }

        public static LocationBias parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationBias parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data);
        }

        public static LocationBias parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationBias)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationBias parseFrom(InputStream input) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static LocationBias parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationBias parseDelimitedFrom(InputStream input) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static LocationBias parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationBias parseFrom(CodedInputStream input) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static LocationBias parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationBias)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return LocationBias.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(LocationBias prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static LocationBias getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<LocationBias> parser() {
            return PARSER;
        }

        public Parser<LocationBias> getParserForType() {
            return PARSER;
        }

        public LocationBias getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LocationBiasOrBuilder {
            private int typeCase_ = 0;
            private Object type_;
            private int bitField0_;
            private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> rectangleBuilder_;
            private SingleFieldBuilderV3<Circle, Circle.Builder, CircleOrBuilder> circleBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationBias_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationBias_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationBias.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.rectangleBuilder_ != null) {
                    this.rectangleBuilder_.clear();
                }
                if (this.circleBuilder_ != null) {
                    this.circleBuilder_.clear();
                }
                this.typeCase_ = 0;
                this.type_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return PlacesServiceProto.internal_static_google_maps_places_v1_SearchTextRequest_LocationBias_descriptor;
            }

            public LocationBias getDefaultInstanceForType() {
                return LocationBias.getDefaultInstance();
            }

            public LocationBias build() {
                LocationBias result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public LocationBias buildPartial() {
                LocationBias result = new LocationBias(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(LocationBias result) {
                int from_bitField0_ = this.bitField0_;
            }

            private void buildPartialOneofs(LocationBias result) {
                result.typeCase_ = this.typeCase_;
                result.type_ = this.type_;
                if (this.typeCase_ == 1 && this.rectangleBuilder_ != null) {
                    result.type_ = this.rectangleBuilder_.build();
                }
                if (this.typeCase_ == 2 && this.circleBuilder_ != null) {
                    result.type_ = this.circleBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof LocationBias) {
                    return this.mergeFrom((LocationBias)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(LocationBias other) {
                if (other == LocationBias.getDefaultInstance()) {
                    return this;
                }
                switch (other.getTypeCase()) {
                    case RECTANGLE: {
                        this.mergeRectangle(other.getRectangle());
                        break;
                    }
                    case CIRCLE: {
                        this.mergeCircle(other.getCircle());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getRectangleFieldBuilder().getBuilder(), extensionRegistry);
                                this.typeCase_ = 1;
                                continue block10;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getCircleFieldBuilder().getBuilder(), extensionRegistry);
                                this.typeCase_ = 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public TypeCase getTypeCase() {
                return TypeCase.forNumber(this.typeCase_);
            }

            public Builder clearType() {
                this.typeCase_ = 0;
                this.type_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRectangle() {
                return this.typeCase_ == 1;
            }

            @Override
            public Viewport getRectangle() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ == 1) {
                        return (Viewport)this.type_;
                    }
                    return Viewport.getDefaultInstance();
                }
                if (this.typeCase_ == 1) {
                    return (Viewport)this.rectangleBuilder_.getMessage();
                }
                return Viewport.getDefaultInstance();
            }

            public Builder setRectangle(Viewport value) {
                if (this.rectangleBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.type_ = value;
                    this.onChanged();
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder setRectangle(Viewport.Builder builderForValue) {
                if (this.rectangleBuilder_ == null) {
                    this.type_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder mergeRectangle(Viewport value) {
                if (this.rectangleBuilder_ == null) {
                    this.type_ = this.typeCase_ == 1 && this.type_ != Viewport.getDefaultInstance() ? Viewport.newBuilder((Viewport)((Viewport)this.type_)).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.typeCase_ == 1) {
                    this.rectangleBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.rectangleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 1;
                return this;
            }

            public Builder clearRectangle() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ == 1) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.typeCase_ == 1) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                    }
                    this.rectangleBuilder_.clear();
                }
                return this;
            }

            public Viewport.Builder getRectangleBuilder() {
                return (Viewport.Builder)this.getRectangleFieldBuilder().getBuilder();
            }

            @Override
            public ViewportOrBuilder getRectangleOrBuilder() {
                if (this.typeCase_ == 1 && this.rectangleBuilder_ != null) {
                    return (ViewportOrBuilder)this.rectangleBuilder_.getMessageOrBuilder();
                }
                if (this.typeCase_ == 1) {
                    return (Viewport)this.type_;
                }
                return Viewport.getDefaultInstance();
            }

            private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> getRectangleFieldBuilder() {
                if (this.rectangleBuilder_ == null) {
                    if (this.typeCase_ != 1) {
                        this.type_ = Viewport.getDefaultInstance();
                    }
                    this.rectangleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Viewport)this.type_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.type_ = null;
                }
                this.typeCase_ = 1;
                this.onChanged();
                return this.rectangleBuilder_;
            }

            @Override
            public boolean hasCircle() {
                return this.typeCase_ == 2;
            }

            @Override
            public Circle getCircle() {
                if (this.circleBuilder_ == null) {
                    if (this.typeCase_ == 2) {
                        return (Circle)this.type_;
                    }
                    return Circle.getDefaultInstance();
                }
                if (this.typeCase_ == 2) {
                    return (Circle)this.circleBuilder_.getMessage();
                }
                return Circle.getDefaultInstance();
            }

            public Builder setCircle(Circle value) {
                if (this.circleBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.type_ = value;
                    this.onChanged();
                } else {
                    this.circleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 2;
                return this;
            }

            public Builder setCircle(Circle.Builder builderForValue) {
                if (this.circleBuilder_ == null) {
                    this.type_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.circleBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.typeCase_ = 2;
                return this;
            }

            public Builder mergeCircle(Circle value) {
                if (this.circleBuilder_ == null) {
                    this.type_ = this.typeCase_ == 2 && this.type_ != Circle.getDefaultInstance() ? Circle.newBuilder((Circle)this.type_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.typeCase_ == 2) {
                    this.circleBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.circleBuilder_.setMessage((AbstractMessage)value);
                }
                this.typeCase_ = 2;
                return this;
            }

            public Builder clearCircle() {
                if (this.circleBuilder_ == null) {
                    if (this.typeCase_ == 2) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.typeCase_ == 2) {
                        this.typeCase_ = 0;
                        this.type_ = null;
                    }
                    this.circleBuilder_.clear();
                }
                return this;
            }

            public Circle.Builder getCircleBuilder() {
                return (Circle.Builder)this.getCircleFieldBuilder().getBuilder();
            }

            @Override
            public CircleOrBuilder getCircleOrBuilder() {
                if (this.typeCase_ == 2 && this.circleBuilder_ != null) {
                    return (CircleOrBuilder)this.circleBuilder_.getMessageOrBuilder();
                }
                if (this.typeCase_ == 2) {
                    return (Circle)this.type_;
                }
                return Circle.getDefaultInstance();
            }

            private SingleFieldBuilderV3<Circle, Circle.Builder, CircleOrBuilder> getCircleFieldBuilder() {
                if (this.circleBuilder_ == null) {
                    if (this.typeCase_ != 2) {
                        this.type_ = Circle.getDefaultInstance();
                    }
                    this.circleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Circle)this.type_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.type_ = null;
                }
                this.typeCase_ = 2;
                this.onChanged();
                return this.circleBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum TypeCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            RECTANGLE(1),
            CIRCLE(2),
            TYPE_NOT_SET(0);

            private final int value;

            private TypeCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static TypeCase valueOf(int value) {
                return TypeCase.forNumber(value);
            }

            public static TypeCase forNumber(int value) {
                switch (value) {
                    case 1: {
                        return RECTANGLE;
                    }
                    case 2: {
                        return CIRCLE;
                    }
                    case 0: {
                        return TYPE_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static interface LocationBiasOrBuilder
    extends MessageOrBuilder {
        public boolean hasRectangle();

        public Viewport getRectangle();

        public ViewportOrBuilder getRectangleOrBuilder();

        public boolean hasCircle();

        public Circle getCircle();

        public CircleOrBuilder getCircleOrBuilder();

        public LocationBias.TypeCase getTypeCase();
    }

    public static enum RankPreference implements ProtocolMessageEnum
    {
        RANK_PREFERENCE_UNSPECIFIED(0),
        DISTANCE(1),
        RELEVANCE(2),
        UNRECOGNIZED(-1);

        public static final int RANK_PREFERENCE_UNSPECIFIED_VALUE = 0;
        public static final int DISTANCE_VALUE = 1;
        public static final int RELEVANCE_VALUE = 2;
        private static final Internal.EnumLiteMap<RankPreference> internalValueMap;
        private static final RankPreference[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static RankPreference valueOf(int value) {
            return RankPreference.forNumber(value);
        }

        public static RankPreference forNumber(int value) {
            switch (value) {
                case 0: {
                    return RANK_PREFERENCE_UNSPECIFIED;
                }
                case 1: {
                    return DISTANCE;
                }
                case 2: {
                    return RELEVANCE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<RankPreference> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)RankPreference.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return RankPreference.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)SearchTextRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static RankPreference valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != RankPreference.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private RankPreference(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<RankPreference>(){

                public RankPreference findValueByNumber(int number) {
                    return RankPreference.forNumber(number);
                }
            };
            VALUES = RankPreference.values();
        }
    }
}

