/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.projection;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.projection.Point;

public class SphericalMercatorProjection {
    final double mWorldWidth;

    public SphericalMercatorProjection(double worldWidth) {
        this.mWorldWidth = worldWidth;
    }

    public Point toPoint(LatLng latLng) {
        double x = latLng.longitude / 360.0 + 0.5;
        double siny = Math.sin(Math.toRadians(latLng.latitude));
        double y = 0.5 * Math.log((1.0 + siny) / (1.0 - siny)) / (Math.PI * -2) + 0.5;
        return new Point(x * this.mWorldWidth, y * this.mWorldWidth);
    }

    public LatLng toLatLng(com.google.maps.android.geometry.Point point) {
        double x = point.x / this.mWorldWidth - 0.5;
        double lng = x * 360.0;
        double y = 0.5 - point.y / this.mWorldWidth;
        double lat = 90.0 - Math.toDegrees(Math.atan(Math.exp(-y * 2.0 * Math.PI)) * 2.0);
        return new LatLng(lat, lng);
    }
}

