/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.maps.android.data.Style;
import com.google.maps.android.data.geojson.GeoJsonStyle;
import java.util.Arrays;
import java.util.List;

public class GeoJsonPolygonStyle
extends Style
implements GeoJsonStyle {
    private static final String[] GEOMETRY_TYPE = new String[]{"Polygon", "MultiPolygon", "GeometryCollection"};

    public GeoJsonPolygonStyle() {
        this.mPolygonOptions = new PolygonOptions();
        this.mPolygonOptions.clickable(true);
    }

    @Override
    public String[] getGeometryType() {
        return GEOMETRY_TYPE;
    }

    public int getFillColor() {
        return this.mPolygonOptions.getFillColor();
    }

    public void setFillColor(int fillColor) {
        this.setPolygonFillColor(fillColor);
        this.styleChanged();
    }

    public boolean isGeodesic() {
        return this.mPolygonOptions.isGeodesic();
    }

    public void setGeodesic(boolean geodesic) {
        this.mPolygonOptions.geodesic(geodesic);
        this.styleChanged();
    }

    public int getStrokeColor() {
        return this.mPolygonOptions.getStrokeColor();
    }

    public void setStrokeColor(int strokeColor) {
        this.mPolygonOptions.strokeColor(strokeColor);
        this.styleChanged();
    }

    public int getStrokeJointType() {
        return this.mPolygonOptions.getStrokeJointType();
    }

    public void setStrokeJointType(int strokeJointType) {
        this.mPolygonOptions.strokeJointType(strokeJointType);
        this.styleChanged();
    }

    public List<PatternItem> getStrokePattern() {
        return this.mPolygonOptions.getStrokePattern();
    }

    public void setStrokePattern(List<PatternItem> strokePattern) {
        this.mPolygonOptions.strokePattern(strokePattern);
        this.styleChanged();
    }

    public float getStrokeWidth() {
        return this.mPolygonOptions.getStrokeWidth();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.setPolygonStrokeWidth(strokeWidth);
        this.styleChanged();
    }

    public float getZIndex() {
        return this.mPolygonOptions.getZIndex();
    }

    public void setZIndex(float zIndex) {
        this.mPolygonOptions.zIndex(zIndex);
        this.styleChanged();
    }

    @Override
    public boolean isVisible() {
        return this.mPolygonOptions.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.mPolygonOptions.visible(visible);
        this.styleChanged();
    }

    private void styleChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public PolygonOptions toPolygonOptions() {
        PolygonOptions polygonOptions = new PolygonOptions();
        polygonOptions.fillColor(this.mPolygonOptions.getFillColor());
        polygonOptions.geodesic(this.mPolygonOptions.isGeodesic());
        polygonOptions.strokeColor(this.mPolygonOptions.getStrokeColor());
        polygonOptions.strokeJointType(this.mPolygonOptions.getStrokeJointType());
        polygonOptions.strokePattern(this.mPolygonOptions.getStrokePattern());
        polygonOptions.strokeWidth(this.mPolygonOptions.getStrokeWidth());
        polygonOptions.visible(this.mPolygonOptions.isVisible());
        polygonOptions.zIndex(this.mPolygonOptions.getZIndex());
        polygonOptions.clickable(this.mPolygonOptions.isClickable());
        return polygonOptions;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("PolygonStyle{");
        sb.append("\n geometry type=").append(Arrays.toString(GEOMETRY_TYPE));
        sb.append(",\n fill color=").append(this.getFillColor());
        sb.append(",\n geodesic=").append(this.isGeodesic());
        sb.append(",\n stroke color=").append(this.getStrokeColor());
        sb.append(",\n stroke joint type=").append(this.getStrokeJointType());
        sb.append(",\n stroke pattern=").append(this.getStrokePattern());
        sb.append(",\n stroke width=").append(this.getStrokeWidth());
        sb.append(",\n visible=").append(this.isVisible());
        sb.append(",\n z index=").append(this.getZIndex());
        sb.append(",\n clickable=").append(this.isClickable());
        sb.append("\n}\n");
        return sb.toString();
    }

    public void setClickable(boolean clickable) {
        this.mPolygonOptions.clickable(clickable);
        this.styleChanged();
    }

    public boolean isClickable() {
        return this.mPolygonOptions.isClickable();
    }
}

