/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlLineString;
import com.google.maps.android.data.kml.KmlMultiGeometry;
import com.google.maps.android.data.kml.KmlMultiTrack;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlPoint;
import com.google.maps.android.data.kml.KmlPolygon;
import com.google.maps.android.data.kml.KmlStyle;
import com.google.maps.android.data.kml.KmlStyleParser;
import com.google.maps.android.data.kml.KmlTrack;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class KmlFeatureParser {
    private static final String GEOMETRY_REGEX = "Point|LineString|Polygon|MultiGeometry|Track|MultiTrack";
    private static final int LONGITUDE_INDEX = 0;
    private static final int LATITUDE_INDEX = 1;
    private static final int ALTITUDE_INDEX = 2;
    private static final String PROPERTY_REGEX = "name|description|drawOrder|visibility|open|address|phoneNumber";
    private static final String BOUNDARY_REGEX = "outerBoundaryIs|innerBoundaryIs";
    private static final String EXTENDED_DATA = "ExtendedData";
    private static final String STYLE_URL_TAG = "styleUrl";
    private static final String STYLE_TAG = "Style";
    private static final String COMPASS_REGEX = "north|south|east|west";
    private static final String LAT_LNG_ALT_SEPARATOR = ",";

    KmlFeatureParser() {
    }

    static KmlPlacemark createPlacemark(XmlPullParser parser) throws IOException, XmlPullParserException {
        String styleId = null;
        KmlStyle inlineStyle = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        Geometry geometry = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Placemark")) {
            if (eventType == 2) {
                if (parser.getName().equals(STYLE_URL_TAG)) {
                    styleId = parser.nextText();
                } else if (parser.getName().matches(GEOMETRY_REGEX)) {
                    geometry = KmlFeatureParser.createGeometry(parser, parser.getName());
                } else if (parser.getName().matches(PROPERTY_REGEX)) {
                    properties.put(parser.getName(), parser.nextText());
                } else if (parser.getName().equals(EXTENDED_DATA)) {
                    properties.putAll(KmlFeatureParser.setExtendedDataProperties(parser));
                } else if (parser.getName().equals(STYLE_TAG)) {
                    inlineStyle = KmlStyleParser.createStyle(parser);
                }
            }
            eventType = parser.next();
        }
        return new KmlPlacemark(geometry, styleId, inlineStyle, properties);
    }

    static KmlGroundOverlay createGroundOverlay(XmlPullParser parser) throws IOException, XmlPullParserException {
        float drawOrder = 0.0f;
        float rotation = 0.0f;
        int visibility = 1;
        String imageUrl = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, Double> compassPoints = new HashMap<String, Double>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("GroundOverlay")) {
            if (eventType == 2) {
                if (parser.getName().equals("Icon")) {
                    imageUrl = KmlFeatureParser.getImageUrl(parser);
                } else if (parser.getName().equals("drawOrder")) {
                    drawOrder = Float.parseFloat(parser.nextText());
                } else if (parser.getName().equals("visibility")) {
                    visibility = Integer.parseInt(parser.nextText());
                } else if (parser.getName().equals(EXTENDED_DATA)) {
                    properties.putAll(KmlFeatureParser.setExtendedDataProperties(parser));
                } else if (parser.getName().equals("rotation")) {
                    rotation = KmlFeatureParser.getRotation(parser);
                } else if (parser.getName().matches(PROPERTY_REGEX) || parser.getName().equals("color")) {
                    properties.put(parser.getName(), parser.nextText());
                } else if (parser.getName().matches(COMPASS_REGEX)) {
                    compassPoints.put(parser.getName(), Double.parseDouble(parser.nextText()));
                }
            }
            eventType = parser.next();
        }
        LatLngBounds latLonBox = KmlFeatureParser.createLatLngBounds((Double)compassPoints.get("north"), (Double)compassPoints.get("south"), (Double)compassPoints.get("east"), (Double)compassPoints.get("west"));
        return new KmlGroundOverlay(imageUrl, latLonBox, drawOrder, visibility, properties, rotation);
    }

    private static float getRotation(XmlPullParser parser) throws IOException, XmlPullParserException {
        return -Float.parseFloat(parser.nextText());
    }

    private static String getImageUrl(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Icon")) {
            if (eventType == 2 && parser.getName().equals("href")) {
                return parser.nextText();
            }
            eventType = parser.next();
        }
        return null;
    }

    private static Geometry createGeometry(XmlPullParser parser, String geometryType) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals(geometryType)) {
            if (eventType == 2) {
                if (parser.getName().equals("Point")) {
                    return KmlFeatureParser.createPoint(parser);
                }
                if (parser.getName().equals("LineString")) {
                    return KmlFeatureParser.createLineString(parser);
                }
                if (parser.getName().equals("Track")) {
                    return KmlFeatureParser.createTrack(parser);
                }
                if (parser.getName().equals("Polygon")) {
                    return KmlFeatureParser.createPolygon(parser);
                }
                if (parser.getName().equals("MultiGeometry")) {
                    return KmlFeatureParser.createMultiGeometry(parser);
                }
                if (parser.getName().equals("MultiTrack")) {
                    return KmlFeatureParser.createMultiTrack(parser);
                }
            }
            eventType = parser.next();
        }
        return null;
    }

    private static HashMap<String, String> setExtendedDataProperties(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String propertyKey = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals(EXTENDED_DATA)) {
            if (eventType == 2) {
                if (parser.getName().equals("Data")) {
                    propertyKey = parser.getAttributeValue(null, "name");
                } else if (parser.getName().equals("value") && propertyKey != null) {
                    properties.put(propertyKey, parser.nextText());
                    propertyKey = null;
                }
            }
            eventType = parser.next();
        }
        return properties;
    }

    private static KmlPoint createPoint(XmlPullParser parser) throws XmlPullParserException, IOException {
        LatLngAlt latLngAlt = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Point")) {
            if (eventType == 2 && parser.getName().equals("coordinates")) {
                latLngAlt = KmlFeatureParser.convertToLatLngAlt(parser.nextText());
            }
            eventType = parser.next();
        }
        return new KmlPoint(latLngAlt.latLng, latLngAlt.altitude);
    }

    private static KmlLineString createLineString(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<LatLng> coordinates = new ArrayList<LatLng>();
        ArrayList<Double> altitudes = new ArrayList<Double>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("LineString")) {
            if (eventType == 2 && parser.getName().equals("coordinates")) {
                ArrayList<LatLngAlt> latLngAlts = KmlFeatureParser.convertToLatLngAltArray(parser.nextText());
                for (LatLngAlt latLngAlt : latLngAlts) {
                    coordinates.add(latLngAlt.latLng);
                    if (latLngAlt.altitude == null) continue;
                    altitudes.add(latLngAlt.altitude);
                }
            }
            eventType = parser.next();
        }
        return new KmlLineString(coordinates, altitudes);
    }

    private static KmlTrack createTrack(XmlPullParser parser) throws XmlPullParserException, IOException {
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        ArrayList<Double> altitudes = new ArrayList<Double>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        HashMap<String, String> properties = new HashMap<String, String>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Track")) {
            if (eventType == 2) {
                if (parser.getName().equals("coord")) {
                    String coordinateString = parser.nextText();
                    LatLngAlt latLngAlt = KmlFeatureParser.convertToLatLngAlt(coordinateString, " ");
                    latLngs.add(latLngAlt.latLng);
                    if (latLngAlt.altitude != null) {
                        altitudes.add(latLngAlt.altitude);
                    }
                } else if (parser.getName().equals("when")) {
                    try {
                        String dateString = parser.nextText();
                        Date date = iso8601.parse(dateString);
                        long millis = date.getTime();
                        timestamps.add(millis);
                    }
                    catch (ParseException e) {
                        throw new XmlPullParserException("Invalid date", parser, (Throwable)e);
                    }
                } else if (parser.getName().equals(EXTENDED_DATA)) {
                    properties.putAll(KmlFeatureParser.setExtendedDataProperties(parser));
                }
            }
            eventType = parser.next();
        }
        return new KmlTrack(latLngs, altitudes, timestamps, properties);
    }

    private static KmlPolygon createPolygon(XmlPullParser parser) throws XmlPullParserException, IOException {
        boolean isOuterBoundary = false;
        ArrayList<LatLng> outerBoundary = new ArrayList<LatLng>();
        ArrayList<List<LatLng>> innerBoundaries = new ArrayList<List<LatLng>>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Polygon")) {
            if (eventType == 2) {
                if (parser.getName().matches(BOUNDARY_REGEX)) {
                    isOuterBoundary = parser.getName().equals("outerBoundaryIs");
                } else if (parser.getName().equals("coordinates")) {
                    if (isOuterBoundary) {
                        outerBoundary = KmlFeatureParser.convertToLatLngArray(parser.nextText());
                    } else {
                        innerBoundaries.add(KmlFeatureParser.convertToLatLngArray(parser.nextText()));
                    }
                }
            }
            eventType = parser.next();
        }
        return new KmlPolygon(outerBoundary, innerBoundaries);
    }

    private static KmlMultiGeometry createMultiGeometry(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        int eventType = parser.next();
        while (eventType != 3 || !parser.getName().equals("MultiGeometry")) {
            if (eventType == 2 && parser.getName().matches(GEOMETRY_REGEX)) {
                geometries.add(KmlFeatureParser.createGeometry(parser, parser.getName()));
            }
            eventType = parser.next();
        }
        return new KmlMultiGeometry(geometries);
    }

    private static KmlMultiTrack createMultiTrack(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<KmlTrack> tracks = new ArrayList<KmlTrack>();
        int eventType = parser.next();
        while (eventType != 3 || !parser.getName().equals("MultiTrack")) {
            if (eventType == 2 && parser.getName().matches("Track")) {
                tracks.add(KmlFeatureParser.createTrack(parser));
            }
            eventType = parser.next();
        }
        return new KmlMultiTrack(tracks);
    }

    private static ArrayList<LatLng> convertToLatLngArray(String coordinatesString) {
        ArrayList<LatLngAlt> latLngAltsArray = KmlFeatureParser.convertToLatLngAltArray(coordinatesString);
        ArrayList<LatLng> coordinatesArray = new ArrayList<LatLng>();
        for (LatLngAlt latLngAlt : latLngAltsArray) {
            coordinatesArray.add(latLngAlt.latLng);
        }
        return coordinatesArray;
    }

    private static ArrayList<LatLngAlt> convertToLatLngAltArray(String coordinatesString) {
        String[] coordinates;
        ArrayList<LatLngAlt> latLngAltsArray = new ArrayList<LatLngAlt>();
        for (String coordinate : coordinates = coordinatesString.trim().split("(\\s+)")) {
            latLngAltsArray.add(KmlFeatureParser.convertToLatLngAlt(coordinate));
        }
        return latLngAltsArray;
    }

    private static LatLngAlt convertToLatLngAlt(String coordinateString) {
        return KmlFeatureParser.convertToLatLngAlt(coordinateString, LAT_LNG_ALT_SEPARATOR);
    }

    private static LatLngAlt convertToLatLngAlt(String coordinateString, String separator) {
        String[] coordinate = coordinateString.split(separator);
        if (coordinate.length < 2) {
            throw new IllegalArgumentException("Wrong coordinate, latitude and longitude must be set");
        }
        double lat = Double.parseDouble(coordinate[1]);
        double lon = Double.parseDouble(coordinate[0]);
        Double alt = coordinate.length > 2 ? Double.valueOf(Double.parseDouble(coordinate[2])) : null;
        LatLng latLng = new LatLng(lat, lon);
        return new LatLngAlt(latLng, alt);
    }

    private static LatLngBounds createLatLngBounds(Double north, Double south, Double east, Double west) {
        LatLng southWest = new LatLng(south.doubleValue(), west.doubleValue());
        LatLng northEast = new LatLng(north.doubleValue(), east.doubleValue());
        return new LatLngBounds(southWest, northEast);
    }

    private static class LatLngAlt {
        public final LatLng latLng;
        public final Double altitude;

        LatLngAlt(LatLng latLng, Double altitude) {
            this.latLng = latLng;
            this.altitude = altitude;
        }
    }
}

