/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data;

import com.google.android.gms.maps.GoogleMap;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Renderer;
import com.google.maps.android.data.geojson.GeoJsonLineStringStyle;
import com.google.maps.android.data.geojson.GeoJsonPointStyle;
import com.google.maps.android.data.geojson.GeoJsonPolygonStyle;
import com.google.maps.android.data.geojson.GeoJsonRenderer;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlRenderer;

public abstract class Layer {
    private Renderer mRenderer;

    protected void addKMLToMap() {
        if (!(this.mRenderer instanceof KmlRenderer)) {
            throw new UnsupportedOperationException("Stored renderer is not a KmlRenderer");
        }
        ((KmlRenderer)this.mRenderer).addLayerToMap();
    }

    protected void addGeoJsonToMap() {
        if (!(this.mRenderer instanceof GeoJsonRenderer)) {
            throw new UnsupportedOperationException("Stored renderer is not a GeoJsonRenderer");
        }
        ((GeoJsonRenderer)this.mRenderer).addLayerToMap();
    }

    public abstract void addLayerToMap();

    public void removeLayerFromMap() {
        if (this.mRenderer instanceof GeoJsonRenderer) {
            ((GeoJsonRenderer)this.mRenderer).removeLayerFromMap();
        } else if (this.mRenderer instanceof KmlRenderer) {
            ((KmlRenderer)this.mRenderer).removeLayerFromMap();
        }
    }

    public void setOnFeatureClickListener(OnFeatureClickListener listener) {
        this.mRenderer.setOnFeatureClickListener(listener);
    }

    protected void storeRenderer(Renderer renderer) {
        this.mRenderer = renderer;
    }

    public Iterable<? extends Feature> getFeatures() {
        return this.mRenderer.getFeatures();
    }

    public Feature getFeature(Object mapObject) {
        return this.mRenderer.getFeature(mapObject);
    }

    public Feature getContainerFeature(Object mapObject) {
        return this.mRenderer.getContainerFeature(mapObject);
    }

    protected boolean hasFeatures() {
        return this.mRenderer.hasFeatures();
    }

    protected boolean hasContainers() {
        if (this.mRenderer instanceof KmlRenderer) {
            return ((KmlRenderer)this.mRenderer).hasNestedContainers();
        }
        return false;
    }

    protected Iterable<KmlContainer> getContainers() {
        if (this.mRenderer instanceof KmlRenderer) {
            return ((KmlRenderer)this.mRenderer).getNestedContainers();
        }
        return null;
    }

    protected Iterable<KmlGroundOverlay> getGroundOverlays() {
        if (this.mRenderer instanceof KmlRenderer) {
            return ((KmlRenderer)this.mRenderer).getGroundOverlays();
        }
        return null;
    }

    public GoogleMap getMap() {
        return this.mRenderer.getMap();
    }

    public void setMap(GoogleMap map) {
        this.mRenderer.setMap(map);
    }

    public boolean isLayerOnMap() {
        return this.mRenderer.isLayerOnMap();
    }

    protected void addFeature(Feature feature) {
        this.mRenderer.addFeature(feature);
    }

    protected void removeFeature(Feature feature) {
        this.mRenderer.removeFeature(feature);
    }

    public GeoJsonPointStyle getDefaultPointStyle() {
        return this.mRenderer.getDefaultPointStyle();
    }

    public GeoJsonLineStringStyle getDefaultLineStringStyle() {
        return this.mRenderer.getDefaultLineStringStyle();
    }

    public GeoJsonPolygonStyle getDefaultPolygonStyle() {
        return this.mRenderer.getDefaultPolygonStyle();
    }

    public static interface OnFeatureClickListener {
        public void onFeatureClick(Feature var1);
    }
}

