/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.heatmaps;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.geometry.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import com.google.maps.android.quadtree.PointQuadTree;

public class WeightedLatLng
implements PointQuadTree.Item {
    public static final double DEFAULT_INTENSITY = 1.0;
    private static final SphericalMercatorProjection sProjection = new SphericalMercatorProjection(1.0);
    private Point mPoint;
    private double mIntensity;

    public WeightedLatLng(LatLng latLng, double intensity) {
        this.mPoint = sProjection.toPoint(latLng);
        this.mIntensity = intensity >= 0.0 ? intensity : 1.0;
    }

    public WeightedLatLng(LatLng latLng) {
        this(latLng, 1.0);
    }

    @Override
    public Point getPoint() {
        return this.mPoint;
    }

    public double getIntensity() {
        return this.mIntensity;
    }
}

