/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.collections;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.maps.android.collections.MapObjectManager;

public class PolygonManager
extends MapObjectManager<Polygon, Collection>
implements GoogleMap.OnPolygonClickListener {
    public PolygonManager(GoogleMap map) {
        super(map);
    }

    @Override
    void setListenersOnUiThread() {
        if (this.mMap != null) {
            this.mMap.setOnPolygonClickListener((GoogleMap.OnPolygonClickListener)this);
        }
    }

    @Override
    public Collection newCollection() {
        return new Collection();
    }

    @Override
    protected void removeObjectFromMap(Polygon object) {
        object.remove();
    }

    public void onPolygonClick(@NonNull Polygon polygon) {
        Collection collection = (Collection)this.mAllObjects.get(polygon);
        if (collection != null && collection.mPolygonClickListener != null) {
            collection.mPolygonClickListener.onPolygonClick(polygon);
        }
    }

    public class Collection
    extends MapObjectManager.Collection {
        private GoogleMap.OnPolygonClickListener mPolygonClickListener;

        public Polygon addPolygon(PolygonOptions opts) {
            Polygon polygon = PolygonManager.this.mMap.addPolygon(opts);
            super.add(polygon);
            return polygon;
        }

        public void addAll(java.util.Collection<PolygonOptions> opts) {
            for (PolygonOptions opt : opts) {
                this.addPolygon(opt);
            }
        }

        public void addAll(java.util.Collection<PolygonOptions> opts, boolean defaultVisible) {
            for (PolygonOptions opt : opts) {
                this.addPolygon(opt).setVisible(defaultVisible);
            }
        }

        public void showAll() {
            for (Polygon polygon : this.getPolygons()) {
                polygon.setVisible(true);
            }
        }

        public void hideAll() {
            for (Polygon polygon : this.getPolygons()) {
                polygon.setVisible(false);
            }
        }

        public boolean remove(Polygon polygon) {
            return super.remove(polygon);
        }

        public java.util.Collection<Polygon> getPolygons() {
            return this.getObjects();
        }

        public void setOnPolygonClickListener(GoogleMap.OnPolygonClickListener polygonClickListener) {
            this.mPolygonClickListener = polygonClickListener;
        }
    }
}

