/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.MathUtil;
import com.google.maps.android.SphericalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J0\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0007J0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0007J6\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0007J6\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0016\u0010\u001d\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0007J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0007J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010#\u001a\u00020$H\u0007J\u0016\u0010%\u001a\u00020$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0007J\u001c\u0010%\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060+j\u0002`,H\u0002J(\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J(\u00102\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J8\u00103\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0002J8\u00105\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J@\u00107\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/google/maps/android/PolyUtil;", "", "<init>", "()V", "DEFAULT_TOLERANCE", "", "containsLocation", "", "point", "Lcom/google/android/gms/maps/model/LatLng;", "polygon", "", "geodesic", "latitude", "longitude", "isLocationOnEdge", "tolerance", "isLocationOnPath", "polyline", "isLocationOnEdgeOrPath", "poly", "closed", "toleranceEarth", "locationIndexOnPath", "", "locationIndexOnEdgeOrPath", "simplify", "douglasPeucker", "", "isClosedPolygon", "distanceToLine", "p", "start", "end", "decode", "encodedPath", "", "encode", "path", "", "v", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tanLatGC", "lat1", "lat2", "lng2", "lng3", "mercatorLatRhumb", "intersects", "lat3", "sinDeltaBearing", "lng1", "isOnSegmentGC", "havTolerance", "library_release"})
@SourceDebugExtension(value={"SMAP\nPolyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolyUtil.kt\ncom/google/maps/android/PolyUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,646:1\n1#2:647\n785#3:648\n796#3:649\n1878#3,2:650\n797#3,2:652\n1880#3:654\n799#3:655\n*S KotlinDebug\n*F\n+ 1 PolyUtil.kt\ncom/google/maps/android/PolyUtil\n*L\n331#1:648\n331#1:649\n331#1:650,2\n331#1:652,2\n331#1:654\n331#1:655\n*E\n"})
public final class PolyUtil {
    @NotNull
    public static final PolyUtil INSTANCE = new PolyUtil();
    public static final double DEFAULT_TOLERANCE = 0.1;

    private PolyUtil() {
    }

    @JvmStatic
    public static final boolean containsLocation(@NotNull LatLng point, @NotNull List<LatLng> polygon, boolean geodesic) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        return PolyUtil.containsLocation(point.latitude, point.longitude, polygon, geodesic);
    }

    @JvmStatic
    public static final boolean containsLocation(double latitude, double longitude, @NotNull List<LatLng> polygon, boolean geodesic) {
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        if (polygon.isEmpty()) {
            return false;
        }
        double lat3 = Math.toRadians(latitude);
        double lng3 = Math.toRadians(longitude);
        LatLng prev = (LatLng)CollectionsKt.last(polygon);
        double lat1 = Math.toRadians(prev.latitude);
        double lng1 = Math.toRadians(prev.longitude);
        int nIntersect = 0;
        for (LatLng point2 : polygon) {
            double lng2;
            double dLng3 = MathUtil.wrap(lng3 - lng1, -Math.PI, Math.PI);
            if (lat3 == lat1 && dLng3 == 0.0) {
                return true;
            }
            double lat2 = Math.toRadians(point2.latitude);
            if (INSTANCE.intersects(lat1, lat2, MathUtil.wrap((lng2 = Math.toRadians(point2.longitude)) - lng1, -Math.PI, Math.PI), lat3, dLng3, geodesic)) {
                ++nIntersect;
            }
            lat1 = lat2;
            lng1 = lng2;
        }
        return nIntersect & true;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isLocationOnEdge(@NotNull LatLng point, @NotNull List<LatLng> polygon, boolean geodesic, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        return INSTANCE.isLocationOnEdgeOrPath(point, polygon, true, geodesic, tolerance);
    }

    public static /* synthetic */ boolean isLocationOnEdge$default(LatLng latLng, List list, boolean bl, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 0.1;
        }
        return PolyUtil.isLocationOnEdge(latLng, list, bl, d);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isLocationOnPath(@NotNull LatLng point, @NotNull List<LatLng> polyline, boolean geodesic, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(polyline, (String)"polyline");
        return INSTANCE.isLocationOnEdgeOrPath(point, polyline, false, geodesic, tolerance);
    }

    public static /* synthetic */ boolean isLocationOnPath$default(LatLng latLng, List list, boolean bl, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 0.1;
        }
        return PolyUtil.isLocationOnPath(latLng, list, bl, d);
    }

    private final boolean isLocationOnEdgeOrPath(LatLng point, List<LatLng> poly, boolean closed, boolean geodesic, double toleranceEarth) {
        int idx = PolyUtil.locationIndexOnEdgeOrPath(point, poly, closed, geodesic, toleranceEarth);
        return idx >= 0;
    }

    @JvmStatic
    @JvmOverloads
    public static final int locationIndexOnPath(@NotNull LatLng point, @NotNull List<LatLng> poly, boolean geodesic, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(poly, (String)"poly");
        return PolyUtil.locationIndexOnEdgeOrPath(point, poly, false, geodesic, tolerance);
    }

    public static /* synthetic */ int locationIndexOnPath$default(LatLng latLng, List list, boolean bl, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 0.1;
        }
        return PolyUtil.locationIndexOnPath(latLng, list, bl, d);
    }

    @JvmStatic
    public static final int locationIndexOnEdgeOrPath(@NotNull LatLng point, @NotNull List<LatLng> poly, boolean closed, boolean geodesic, double toleranceEarth) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(poly, (String)"poly");
        if (poly.isEmpty()) {
            return -1;
        }
        double tolerance = toleranceEarth / 6371009.0;
        double havTolerance = MathUtil.hav(tolerance);
        double lat3 = Math.toRadians(point.latitude);
        double lng3 = Math.toRadians(point.longitude);
        LatLng prev = poly.get(closed ? poly.size() - 1 : 0);
        double lat1 = Math.toRadians(prev.latitude);
        double lng1 = Math.toRadians(prev.longitude);
        int idx = 0;
        if (geodesic) {
            for (LatLng point2 : poly) {
                double lng2;
                double lat2 = Math.toRadians(point2.latitude);
                if (INSTANCE.isOnSegmentGC(lat1, lng1, lat2, lng2 = Math.toRadians(point2.longitude), lat3, lng3, havTolerance)) {
                    return Math.max(0, idx - 1);
                }
                lat1 = lat2;
                lng1 = lng2;
                ++idx;
            }
        } else {
            double minAcceptable = lat3 - tolerance;
            double maxAcceptable = lat3 + tolerance;
            double y1 = MathUtil.mercator(lat1);
            double y3 = MathUtil.mercator(lat3);
            double[] xTry = new double[3];
            for (LatLng point2 : poly) {
                double lat2 = Math.toRadians(point2.latitude);
                double y2 = MathUtil.mercator(lat2);
                double lng2 = Math.toRadians(point2.longitude);
                if (Math.max(lat1, lat2) >= minAcceptable && Math.min(lat1, lat2) <= maxAcceptable) {
                    double x3Base;
                    double x2 = MathUtil.wrap(lng2 - lng1, -Math.PI, Math.PI);
                    xTry[0] = x3Base = MathUtil.wrap(lng3 - lng1, -Math.PI, Math.PI);
                    xTry[1] = x3Base + Math.PI * 2;
                    xTry[2] = x3Base - Math.PI * 2;
                    for (double x3 : xTry) {
                        double dy = y2 - y1;
                        double len2 = x2 * x2 + dy * dy;
                        double t = len2 <= 0.0 ? 0.0 : MathUtil.clamp((x3 * x2 + (y3 - y1) * dy) / len2, 0.0, 1.0);
                        double xClosest = t * x2;
                        double yClosest = y1 + t * dy;
                        double latClosest = MathUtil.inverseMercator(yClosest);
                        double havDist = MathUtil.havDistance(lat3, latClosest, x3 - xClosest);
                        if (!(havDist < havTolerance)) continue;
                        return Math.max(0, idx - 1);
                    }
                }
                lat1 = lat2;
                lng1 = lng2;
                y1 = y2;
                ++idx;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<LatLng> simplify(@NotNull List<LatLng> poly, double tolerance) {
        void $this$filterIndexedTo$iv$iv;
        Iterable iterable;
        Iterable iterable2;
        Intrinsics.checkNotNullParameter(poly, (String)"poly");
        if (!(!((Collection)poly).isEmpty())) {
            boolean $i$a$-require-PolyUtil$simplify$32 = false;
            String $i$a$-require-PolyUtil$simplify$32 = "Polyline must have at least 1 point";
            throw new IllegalArgumentException($i$a$-require-PolyUtil$simplify$32.toString());
        }
        if (!(tolerance > 0.0)) {
            boolean $i$a$-require-PolyUtil$simplify$42 = false;
            String $i$a$-require-PolyUtil$simplify$42 = "Tolerance must be greater than zero";
            throw new IllegalArgumentException($i$a$-require-PolyUtil$simplify$42.toString());
        }
        if (PolyUtil.isClosedPolygon(poly)) {
            LatLng lastPoint = (LatLng)CollectionsKt.last(poly);
            double offset = 1.0E-11;
            List $this$simplify_u24lambda_u242 = iterable2 = CollectionsKt.toMutableList((Collection)poly);
            boolean bl = false;
            $this$simplify_u24lambda_u242.remove($this$simplify_u24lambda_u242.size() - 1);
            $this$simplify_u24lambda_u242.add(new LatLng(lastPoint.latitude + offset, lastPoint.longitude + offset));
            iterable = iterable2;
        } else {
            iterable = poly;
        }
        Iterable workingPoly = iterable;
        boolean[] pointsToKeep = INSTANCE.douglasPeucker((List<LatLng>)workingPoly, tolerance);
        Iterable $this$filterIndexed$iv = poly;
        boolean $i$f$filterIndexed = false;
        iterable2 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            LatLng cfr_ignored_0 = (LatLng)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!pointsToKeep[index]) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean[] douglasPeucker(List<LatLng> poly, double tolerance) {
        int n = poly.size();
        int n2 = 0;
        Object object = new boolean[n];
        while (n2 < n) {
            int n3 = n2++;
            object[n3] = false;
        }
        boolean[] keepPoint = object;
        keepPoint[0] = true;
        keepPoint[n - 1] = true;
        if (n > 2) {
            ArrayDeque stack = new ArrayDeque();
            stack.addLast((Object)TuplesKt.to((Object)0, (Object)(n - 1)));
            while (!((Collection)stack).isEmpty()) {
                object = (Pair)stack.removeLast();
                int start = ((Number)object.component1()).intValue();
                int end = ((Number)object.component2()).intValue();
                double maxDist = 0.0;
                int maxIdx = 0;
                for (int idx = start + 1; idx < end; ++idx) {
                    double dist = PolyUtil.distanceToLine(poly.get(idx), poly.get(start), poly.get(end));
                    if (!(dist > maxDist)) continue;
                    maxDist = dist;
                    maxIdx = idx;
                }
                if (!(maxDist > tolerance)) continue;
                keepPoint[maxIdx] = true;
                stack.addLast((Object)TuplesKt.to((Object)start, (Object)maxIdx));
                stack.addLast((Object)TuplesKt.to((Object)maxIdx, (Object)end));
            }
        }
        return keepPoint;
    }

    @JvmStatic
    public static final boolean isClosedPolygon(@NotNull List<LatLng> poly) {
        Intrinsics.checkNotNullParameter(poly, (String)"poly");
        return !((Collection)poly).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.first(poly), (Object)CollectionsKt.last(poly));
    }

    @JvmStatic
    public static final double distanceToLine(@NotNull LatLng p, @NotNull LatLng start, @NotNull LatLng end) {
        double s2s1lng;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (Intrinsics.areEqual((Object)start, (Object)end)) {
            return SphericalUtil.computeDistanceBetween(end, p);
        }
        double s0lat = Math.toRadians(p.latitude);
        double s0lng = Math.toRadians(p.longitude);
        double s1lat = Math.toRadians(start.latitude);
        double s1lng = Math.toRadians(start.longitude);
        double s2lat = Math.toRadians(end.latitude);
        double s2lng = Math.toRadians(end.longitude);
        double s2s1lat = s2lat - s1lat;
        double lonCorrection = Math.cos(s1lat);
        double u = ((s0lat - s1lat) * s2s1lat + (s0lng - s1lng) * lonCorrection * (s2s1lng = (s2lng - s1lng) * lonCorrection)) / (s2s1lat * s2s1lat + s2s1lng * s2s1lng);
        if (u <= 0.0) {
            return SphericalUtil.computeDistanceBetween(p, start);
        }
        if (u >= 1.0) {
            return SphericalUtil.computeDistanceBetween(p, end);
        }
        LatLng su = new LatLng(start.latitude + u * (end.latitude - start.latitude), start.longitude + u * (end.longitude - start.longitude));
        return SphericalUtil.computeDistanceBetween(p, su);
    }

    @JvmStatic
    @NotNull
    public static final List<LatLng> decode(@NotNull String encodedPath) {
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        int len = encodedPath.length();
        List path = new ArrayList();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int result = 1;
            int shift = 0;
            int b = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            path.add(new LatLng((double)lat * 1.0E-5, (double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) * 1.0E-5));
        }
        return path;
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull List<LatLng> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuilder result = new StringBuilder();
        for (LatLng point : path) {
            long lat = (long)Math.rint(point.latitude * 100000.0);
            long lng = (long)Math.rint(point.longitude * 100000.0);
            long dLat = lat - lastLat;
            long dLng = lng - lastLng;
            INSTANCE.encode(dLat, result);
            INSTANCE.encode(dLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void encode(long v, StringBuilder result) {
        long value;
        long l = value = v < 0L ? v << 1 ^ 0xFFFFFFFFFFFFFFFFL : v << 1;
        while (value >= 32L) {
            result.append(Character.toChars((0x20 | (int)(value & 0x1FL)) + 63));
            value >>= 5;
        }
        result.append(Character.toChars((int)(value + (long)63)));
    }

    private final double tanLatGC(double lat1, double lat2, double lng2, double lng3) {
        return (Math.tan(lat1) * Math.sin(lng2 - lng3) + Math.tan(lat2) * Math.sin(lng3)) / Math.sin(lng2);
    }

    private final double mercatorLatRhumb(double lat1, double lat2, double lng2, double lng3) {
        return (MathUtil.mercator(lat1) * (lng2 - lng3) + MathUtil.mercator(lat2) * lng3) / lng2;
    }

    private final boolean intersects(double lat1, double lat2, double lng2, double lat3, double lng3, boolean geodesic) {
        if (lng3 >= 0.0 && lng3 >= lng2 || lng3 < 0.0 && lng3 < lng2) {
            return false;
        }
        if (lat3 <= -1.5707963267948966) {
            return false;
        }
        if (lat1 <= -1.5707963267948966 || lat2 <= -1.5707963267948966 || lat1 >= 1.5707963267948966 || lat2 >= 1.5707963267948966) {
            return false;
        }
        if (lng2 <= -Math.PI) {
            return false;
        }
        double linearLat = (lat1 * (lng2 - lng3) + lat2 * lng3) / lng2;
        if (lat1 >= 0.0 && lat2 >= 0.0 && lat3 < linearLat) {
            return false;
        }
        if (lat1 <= 0.0 && lat2 <= 0.0 && lat3 >= linearLat) {
            return true;
        }
        if (lat3 >= 1.5707963267948966) {
            return true;
        }
        return geodesic ? Math.tan(lat3) >= this.tanLatGC(lat1, lat2, lng2, lng3) : MathUtil.mercator(lat3) >= this.mercatorLatRhumb(lat1, lat2, lng2, lng3);
    }

    private final double sinDeltaBearing(double lat1, double lng1, double lat2, double lng2, double lat3, double lng3) {
        double d;
        double sinLat1 = Math.sin(lat1);
        double cosLat2 = Math.cos(lat2);
        double cosLat3 = Math.cos(lat3);
        double lat31 = lat3 - lat1;
        double lng31 = lng3 - lng1;
        double lat21 = lat2 - lat1;
        double lng21 = lng2 - lng1;
        double a = Math.sin(lng31) * cosLat3;
        double c = Math.sin(lng21) * cosLat2;
        double b = Math.sin(lat31) + (double)2 * sinLat1 * cosLat3 * MathUtil.hav(lng31);
        double denom = (a * a + b * b) * (c * c + (d = Math.sin(lat21) + (double)2 * sinLat1 * cosLat2 * MathUtil.hav(lng21)) * d);
        return denom <= 0.0 ? 1.0 : (a * d - b * c) / Math.sqrt(denom);
    }

    private final boolean isOnSegmentGC(double lat1, double lng1, double lat2, double lng2, double lat3, double lng3, double havTolerance) {
        double havDist13 = MathUtil.havDistance(lat1, lat3, lng1 - lng3);
        if (havDist13 <= havTolerance) {
            return true;
        }
        double havDist23 = MathUtil.havDistance(lat2, lat3, lng2 - lng3);
        if (havDist23 <= havTolerance) {
            return true;
        }
        double sinBearing = this.sinDeltaBearing(lat1, lng1, lat2, lng2, lat3, lng3);
        double sinDist13 = MathUtil.sinFromHav(havDist13);
        double havCrossTrack = MathUtil.havFromSin(sinDist13 * sinBearing);
        if (havCrossTrack > havTolerance) {
            return false;
        }
        double havDist12 = MathUtil.havDistance(lat1, lat2, lng1 - lng2);
        double term = havDist12 + havCrossTrack * (1.0 - (double)2 * havDist12);
        if (havDist13 > term || havDist23 > term) {
            return false;
        }
        if (havDist12 < 0.74) {
            return true;
        }
        double cosCrossTrack = 1.0 - (double)2 * havCrossTrack;
        double havAlongTrack13 = (havDist13 - havCrossTrack) / cosCrossTrack;
        double havAlongTrack23 = (havDist23 - havCrossTrack) / cosCrossTrack;
        double sinSumAlongTrack = MathUtil.sinSumFromHav(havAlongTrack13, havAlongTrack23);
        return sinSumAlongTrack > 0.0;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isLocationOnEdge(@NotNull LatLng point, @NotNull List<LatLng> polygon, boolean geodesic) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        return PolyUtil.isLocationOnEdge$default(point, polygon, geodesic, 0.0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isLocationOnPath(@NotNull LatLng point, @NotNull List<LatLng> polyline, boolean geodesic) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(polyline, (String)"polyline");
        return PolyUtil.isLocationOnPath$default(point, polyline, geodesic, 0.0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int locationIndexOnPath(@NotNull LatLng point, @NotNull List<LatLng> poly, boolean geodesic) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(poly, (String)"poly");
        return PolyUtil.locationIndexOnPath$default(point, poly, geodesic, 0.0, 8, null);
    }
}

