/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.MathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J \u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\"\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J \u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0016\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0007J\u0016\u0010\u0019\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0007J\u0016\u0010\u001a\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0007J\u001e\u0010\u001a\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J \u0010\u001f\u001a\u0004\u0018\u00010\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010!\u001a\u00020\u0005H\u0007J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010!\u001a\u00020\u0005H\u0007\u00a8\u0006#"}, d2={"Lcom/google/maps/android/SphericalUtil;", "", "<init>", "()V", "computeHeading", "", "from", "Lcom/google/android/gms/maps/model/LatLng;", "to", "computeOffset", "distance", "heading", "computeOffsetOrigin", "interpolate", "fraction", "distanceRadians", "lat1", "lng1", "lat2", "lng2", "computeAngleBetween", "computeDistanceBetween", "computeLength", "path", "", "computeArea", "computeSignedArea", "radius", "polarTriangleArea", "tan1", "tan2", "getPointOnPolyline", "polyline", "percentage", "getPolylinePrefix", "library_release"})
public final class SphericalUtil {
    @NotNull
    public static final SphericalUtil INSTANCE = new SphericalUtil();

    private SphericalUtil() {
    }

    @JvmStatic
    public static final double computeHeading(@NotNull LatLng from, @NotNull LatLng to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double toLat = Math.toRadians(to.latitude);
        double toLng = Math.toRadians(to.longitude);
        double dLng = toLng - fromLng;
        double heading = Math.atan2(Math.sin(dLng) * Math.cos(toLat), Math.cos(fromLat) * Math.sin(toLat) - Math.sin(fromLat) * Math.cos(toLat) * Math.cos(dLng));
        return MathUtil.wrap(Math.toDegrees(heading), -180.0, 180.0);
    }

    @JvmStatic
    @NotNull
    public static final LatLng computeOffset(@NotNull LatLng from, double distance, double heading) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        double distance2 = distance;
        double heading2 = heading;
        heading2 = Math.toRadians(heading2);
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double cosDistance = Math.cos(distance2 /= 6371009.0);
        double sinDistance = Math.sin(distance2);
        double sinFromLat = Math.sin(fromLat);
        double cosFromLat = Math.cos(fromLat);
        double sinLat = cosDistance * sinFromLat + sinDistance * cosFromLat * Math.cos(heading2);
        double dLng = Math.atan2(sinDistance * cosFromLat * Math.sin(heading2), cosDistance - sinFromLat * sinLat);
        return new LatLng(Math.toDegrees(Math.asin(sinLat)), Math.toDegrees(fromLng + dLng));
    }

    @JvmStatic
    @Nullable
    public static final LatLng computeOffsetOrigin(@NotNull LatLng to, double distance, double heading) {
        double fromLatRadians;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double distance2 = distance;
        double heading2 = heading;
        heading2 = Math.toRadians(heading2);
        double n1 = Math.cos(distance2 /= 6371009.0);
        double n2 = Math.sin(distance2) * Math.cos(heading2);
        double n3 = Math.sin(distance2) * Math.sin(heading2);
        double n4 = Math.sin(Math.toRadians(to.latitude));
        double n12 = n1 * n1;
        double discriminant = n2 * n2 * n12 + n12 * n12 - n12 * n4 * n4;
        if (discriminant < 0.0) {
            return null;
        }
        double b = n2 * n4 + Math.sqrt(discriminant);
        double a = (n4 - n2 * (b /= n1 * n1 + n2 * n2)) / n1;
        if ((fromLatRadians = Math.atan2(a, b)) < -1.5707963267948966 || fromLatRadians > 1.5707963267948966) {
            b = n2 * n4 - Math.sqrt(discriminant);
            fromLatRadians = Math.atan2(a, b /= n1 * n1 + n2 * n2);
        }
        if (fromLatRadians < -1.5707963267948966 || fromLatRadians > 1.5707963267948966) {
            return null;
        }
        double fromLngRadians = Math.toRadians(to.longitude) - Math.atan2(n3, n1 * Math.cos(fromLatRadians) - n2 * Math.sin(fromLatRadians));
        return new LatLng(Math.toDegrees(fromLatRadians), Math.toDegrees(fromLngRadians));
    }

    @JvmStatic
    @NotNull
    public static final LatLng interpolate(@NotNull LatLng from, @NotNull LatLng to, double fraction) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double toLat = Math.toRadians(to.latitude);
        double toLng = Math.toRadians(to.longitude);
        double cosFromLat = Math.cos(fromLat);
        double cosToLat = Math.cos(toLat);
        double angle = SphericalUtil.computeAngleBetween(from, to);
        double sinAngle = Math.sin(angle);
        if (sinAngle < 1.0E-6) {
            return new LatLng(from.latitude + fraction * (to.latitude - from.latitude), from.longitude + fraction * (to.longitude - from.longitude));
        }
        double a = Math.sin((1.0 - fraction) * angle) / sinAngle;
        double b = Math.sin(fraction * angle) / sinAngle;
        double x = a * cosFromLat * Math.cos(fromLng) + b * cosToLat * Math.cos(toLng);
        double y = a * cosFromLat * Math.sin(fromLng) + b * cosToLat * Math.sin(toLng);
        double z = a * Math.sin(fromLat) + b * Math.sin(toLat);
        double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lng = Math.atan2(y, x);
        return new LatLng(Math.toDegrees(lat), Math.toDegrees(lng));
    }

    private final double distanceRadians(double lat1, double lng1, double lat2, double lng2) {
        return MathUtil.arcHav(MathUtil.havDistance(lat1, lat2, lng1 - lng2));
    }

    @JvmStatic
    public static final double computeAngleBetween(@NotNull LatLng from, @NotNull LatLng to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return INSTANCE.distanceRadians(Math.toRadians(from.latitude), Math.toRadians(from.longitude), Math.toRadians(to.latitude), Math.toRadians(to.longitude));
    }

    @JvmStatic
    public static final double computeDistanceBetween(@NotNull LatLng from, @NotNull LatLng to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SphericalUtil.computeAngleBetween(from, to) * 6371009.0;
    }

    @JvmStatic
    public static final double computeLength(@NotNull List<LatLng> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (path.size() < 2) {
            return 0.0;
        }
        double length = 0.0;
        LatLng prev = null;
        for (LatLng point : path) {
            if (prev != null) {
                double prevLat = Math.toRadians(prev.latitude);
                double prevLng = Math.toRadians(prev.longitude);
                double lat = Math.toRadians(point.latitude);
                double lng = Math.toRadians(point.longitude);
                length += INSTANCE.distanceRadians(prevLat, prevLng, lat, lng);
            }
            prev = point;
        }
        return length * 6371009.0;
    }

    @JvmStatic
    public static final double computeArea(@NotNull List<LatLng> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Math.abs(SphericalUtil.computeSignedArea(path));
    }

    @JvmStatic
    public static final double computeSignedArea(@NotNull List<LatLng> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return SphericalUtil.computeSignedArea(path, 6371009.0);
    }

    @JvmStatic
    public static final double computeSignedArea(@NotNull List<LatLng> path, double radius) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        int size = path.size();
        if (size < 3) {
            return 0.0;
        }
        double total = 0.0;
        LatLng prev = path.get(size - 1);
        double prevTanLat = Math.tan((1.5707963267948966 - Math.toRadians(prev.latitude)) / (double)2);
        double prevLng = Math.toRadians(prev.longitude);
        for (LatLng point : path) {
            double tanLat = Math.tan((1.5707963267948966 - Math.toRadians(point.latitude)) / (double)2);
            double lng = Math.toRadians(point.longitude);
            total += INSTANCE.polarTriangleArea(tanLat, lng, prevTanLat, prevLng);
            prevTanLat = tanLat;
            prevLng = lng;
        }
        return total * (radius * radius);
    }

    private final double polarTriangleArea(double tan1, double lng1, double tan2, double lng2) {
        double deltaLng = lng1 - lng2;
        double t = tan1 * tan2;
        return (double)2 * Math.atan2(t * Math.sin(deltaLng), 1.0 + t * Math.cos(deltaLng));
    }

    @JvmStatic
    @Nullable
    public static final LatLng getPointOnPolyline(@NotNull List<LatLng> polyline, double percentage) {
        Intrinsics.checkNotNullParameter(polyline, (String)"polyline");
        return (LatLng)CollectionsKt.lastOrNull(SphericalUtil.getPolylinePrefix(polyline, percentage));
    }

    @JvmStatic
    @NotNull
    public static final List<LatLng> getPolylinePrefix(@NotNull List<LatLng> polyline, double percentage) {
        List list;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(polyline, (String)"polyline");
                if (polyline.isEmpty()) break block7;
                if (0.0 <= percentage ? percentage <= 1.0 : false) break block8;
            }
            return CollectionsKt.emptyList();
        }
        double d = percentage;
        if (d == 0.0) {
            return CollectionsKt.listOf((Object)CollectionsKt.first(polyline));
        }
        if (d == 1.0) {
            return CollectionsKt.toList((Iterable)polyline);
        }
        double targetDistance = SphericalUtil.computeLength(polyline) * percentage;
        List $this$getPolylinePrefix_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getPolylinePrefix_u24lambda_u240.add(CollectionsKt.first(polyline));
        double accumulatedDistance = 0.0;
        for (Pair pair : CollectionsKt.zipWithNext((Iterable)polyline)) {
            LatLng p2;
            LatLng p1 = (LatLng)pair.component1();
            double segmentLength = SphericalUtil.computeDistanceBetween(p1, p2 = (LatLng)pair.component2());
            if (accumulatedDistance + segmentLength >= targetDistance) {
                double fraction = (targetDistance - accumulatedDistance) / segmentLength;
                $this$getPolylinePrefix_u24lambda_u240.add(SphericalUtil.interpolate(p1, p2, fraction));
                break;
            }
            $this$getPolylinePrefix_u24lambda_u240.add(p2);
            accumulatedDistance += segmentLength;
        }
        return CollectionsKt.build((List)list);
    }
}

