/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/google/maps/android/lint/checks/GoogleMapDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class GoogleMapDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String migrationGuideUrl = "https://bit.ly/3kTpQmY";
    @NotNull
    private static final Issue POTENTIAL_BEHAVIOR_OVERRIDE = Issue.Companion.create("PotentialBehaviorOverride", "Using this method may override behaviors set by the Maps SDK for Android Utility Library. If you are not using clustering, GeoJson, or KML, you can safely suppress this warning, otherwise, refer to the utility library's migration guide: " + migrationGuideUrl, "\n                This lint warns for potential behavior override while using clustering, GeoJson, or\n                KML since these features use this method in their internal implementations. As such,\n                to achieve the desired behavior requires using an alternative API.\n                \n                For example, if you are using the clustering feature and want to set a custom info\n                window, rather than invoking `GoogleMap#setInfoWindowAdapter(...)`, you would need\n                to set the custom info window on the MarkerManager.Collection object instead.\n                \n                e.g.\n                \n                ```\n                ClusterManager clusterManager = // ...\n                MarkerManager.Collection collection = clusterManager.getMarkerCollection();\n                collection.setInfoWindowAdapter(...);\n                ```\n                \n                Refer to the migration guide for more info: " + migrationGuideUrl + "\n            ", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(GoogleMapDetector.class, Scope.JAVA_FILE_SCOPE));

    @Nullable
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setInfoWindowAdapter", "setOnInfoWindowClickListener", "setOnInfoWindowLongClickListener", "setOnMarkerClickListener", "setOnMarkerDragListener"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, "com.google.android.gms.maps.GoogleMap")) {
            return;
        }
        JavaContext.report$default((JavaContext)context, (Issue)POTENTIAL_BEHAVIOR_OVERRIDE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)POTENTIAL_BEHAVIOR_OVERRIDE.getBriefDescription(TextFormat.TEXT), null, (int)16, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/maps/android/lint/checks/GoogleMapDetector$Companion;", "", "()V", "POTENTIAL_BEHAVIOR_OVERRIDE", "Lcom/android/tools/lint/detector/api/Issue;", "getPOTENTIAL_BEHAVIOR_OVERRIDE", "()Lcom/android/tools/lint/detector/api/Issue;", "migrationGuideUrl", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getPOTENTIAL_BEHAVIOR_OVERRIDE() {
            return POTENTIAL_BEHAVIOR_OVERRIDE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

