/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.clustering.algo.ScreenBasedAlgorithm;
import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.projection.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import com.google.maps.android.quadtree.PointQuadTree;
import java.util.ArrayList;
import java.util.Collection;

public class NonHierarchicalViewBasedAlgorithm<T extends ClusterItem>
extends NonHierarchicalDistanceBasedAlgorithm<T>
implements ScreenBasedAlgorithm<T> {
    private static final SphericalMercatorProjection PROJECTION = new SphericalMercatorProjection(1.0);
    private int mViewWidth;
    private int mViewHeight;
    private LatLng mMapCenter;

    public NonHierarchicalViewBasedAlgorithm(int screenWidth, int screenHeight) {
        this.mViewWidth = screenWidth;
        this.mViewHeight = screenHeight;
    }

    @Override
    public void onCameraChange(CameraPosition cameraPosition) {
        this.mMapCenter = cameraPosition.target;
    }

    @Override
    protected Collection<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> getClusteringItems(PointQuadTree<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> quadTree, float zoom) {
        Bounds wrappedBounds;
        Bounds visibleBounds = this.getVisibleBounds(zoom);
        ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> items = new ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>>();
        if (visibleBounds.minX < 0.0) {
            wrappedBounds = new Bounds(visibleBounds.minX + 1.0, 1.0, visibleBounds.minY, visibleBounds.maxY);
            items.addAll(quadTree.search(wrappedBounds));
            visibleBounds = new Bounds(0.0, visibleBounds.maxX, visibleBounds.minY, visibleBounds.maxY);
        }
        if (visibleBounds.maxX > 1.0) {
            wrappedBounds = new Bounds(0.0, visibleBounds.maxX - 1.0, visibleBounds.minY, visibleBounds.maxY);
            items.addAll(quadTree.search(wrappedBounds));
            visibleBounds = new Bounds(visibleBounds.minX, 1.0, visibleBounds.minY, visibleBounds.maxY);
        }
        items.addAll(quadTree.search(visibleBounds));
        return items;
    }

    @Override
    public boolean shouldReclusterOnMapMovement() {
        return true;
    }

    public void updateViewSize(int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
    }

    private Bounds getVisibleBounds(float zoom) {
        if (this.mMapCenter == null) {
            return new Bounds(0.0, 0.0, 0.0, 0.0);
        }
        Point p = PROJECTION.toPoint(this.mMapCenter);
        double halfWidthSpan = (double)this.mViewWidth / Math.pow(2.0, zoom) / 256.0 / 2.0;
        double halfHeightSpan = (double)this.mViewHeight / Math.pow(2.0, zoom) / 256.0 / 2.0;
        return new Bounds(p.x - halfWidthSpan, p.x + halfWidthSpan, p.y - halfHeightSpan, p.y + halfHeightSpan);
    }
}

