/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import com.google.android.gms.maps.GoogleMap;
import com.google.maps.android.collections.GroundOverlayManager;
import com.google.maps.android.collections.MarkerManager;
import com.google.maps.android.collections.PolygonManager;
import com.google.maps.android.collections.PolylineManager;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Renderer;
import com.google.maps.android.data.geojson.GeoJsonFeature;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class GeoJsonRenderer
extends Renderer
implements Observer {
    private static final Object FEATURE_NOT_ON_MAP = null;

    GeoJsonRenderer(GoogleMap map, HashMap<GeoJsonFeature, Object> features, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager) {
        super(map, features, markerManager, polygonManager, polylineManager, groundOverlayManager);
    }

    @Override
    public void setMap(GoogleMap map) {
        super.setMap(map);
        for (Feature feature : super.getFeatures()) {
            this.redrawFeatureToMap((GeoJsonFeature)feature, map);
        }
    }

    public void addLayerToMap() {
        if (!this.isLayerOnMap()) {
            this.setLayerVisibility(true);
            for (Feature feature : super.getFeatures()) {
                this.addFeature((GeoJsonFeature)feature);
            }
        }
    }

    public void addFeature(GeoJsonFeature feature) {
        super.addFeature(feature);
        if (this.isLayerOnMap()) {
            feature.addObserver(this);
        }
    }

    public void removeLayerFromMap() {
        if (this.isLayerOnMap()) {
            for (Feature feature : super.getFeatures()) {
                this.removeFromMap(super.getAllFeatures().get(feature));
                feature.deleteObserver(this);
            }
            this.setLayerVisibility(false);
        }
    }

    public void removeFeature(GeoJsonFeature feature) {
        super.removeFeature(feature);
        if (super.getFeatures().contains(feature)) {
            feature.deleteObserver(this);
        }
    }

    private void redrawFeatureToMap(GeoJsonFeature feature) {
        this.redrawFeatureToMap(feature, this.getMap());
    }

    private void redrawFeatureToMap(GeoJsonFeature feature, GoogleMap map) {
        this.removeFromMap(this.getAllFeatures().get(feature));
        this.putFeatures(feature, FEATURE_NOT_ON_MAP);
        if (map != null && feature.hasGeometry()) {
            this.putFeatures(feature, this.addGeoJsonFeatureToMap(feature, feature.getGeometry()));
        }
    }

    @Override
    public void update(Observable observable, Object data) {
        if (observable instanceof GeoJsonFeature) {
            boolean featureIsOnMap;
            GeoJsonFeature feature = (GeoJsonFeature)observable;
            boolean bl = featureIsOnMap = this.getAllFeatures().get(feature) != FEATURE_NOT_ON_MAP;
            if (featureIsOnMap && feature.hasGeometry()) {
                this.redrawFeatureToMap(feature);
            } else if (featureIsOnMap && !feature.hasGeometry()) {
                this.removeFromMap(this.getAllFeatures().get(feature));
                this.putFeatures(feature, FEATURE_NOT_ON_MAP);
            } else if (!featureIsOnMap && feature.hasGeometry()) {
                this.addFeature(feature);
            }
        }
    }
}

