/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.Renderer;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlStyle;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class KmlRenderer
extends Renderer {
    private static final String LOG_TAG = "KmlRenderer";
    private final ArrayList<String> mGroundOverlayUrls = new ArrayList();
    private boolean mMarkerIconsDownloaded = false;
    private boolean mGroundOverlayImagesDownloaded = false;
    private HashMap<KmlGroundOverlay, GroundOverlay> mGroundOverlays;
    private ArrayList<KmlContainer> mContainers;

    KmlRenderer(GoogleMap map, Context context) {
        super(map, context);
    }

    private static BitmapDescriptor scaleIcon(Bitmap unscaledBitmap, Double scale) {
        int width = (int)((double)unscaledBitmap.getWidth() * scale);
        int height = (int)((double)unscaledBitmap.getHeight() * scale);
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)unscaledBitmap, (int)width, (int)height, (boolean)false);
        return BitmapDescriptorFactory.fromBitmap((Bitmap)scaledBitmap);
    }

    private void removePlacemarks(HashMap<? extends Feature, Object> placemarks) {
        KmlRenderer.removeFeatures(placemarks);
    }

    static boolean getContainerVisibility(KmlContainer kmlContainer, boolean isParentContainerVisible) {
        String placemarkVisibility;
        boolean isChildContainerVisible = true;
        if (kmlContainer.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = kmlContainer.getProperty("visibility")) == 0) {
            isChildContainerVisible = false;
        }
        return isParentContainerVisible && isChildContainerVisible;
    }

    private void removeGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (GroundOverlay groundOverlay : groundOverlays.values()) {
            groundOverlay.remove();
        }
    }

    private void removeContainers(Iterable<KmlContainer> containers) {
        for (KmlContainer container : containers) {
            this.removePlacemarks(container.getPlacemarksHashMap());
            this.removeGroundOverlays(container.getGroundOverlayHashMap());
            this.removeContainers(container.getContainers());
        }
    }

    public void addLayerToMap() {
        this.setLayerVisibility(true);
        this.mGroundOverlays = this.getGroundOverlayMap();
        this.mContainers = this.getContainerList();
        this.putStyles();
        this.assignStyleMap(this.getStyleMaps(), this.getStylesRenderer());
        this.addGroundOverlays(this.mGroundOverlays, this.mContainers);
        this.addContainerGroupToMap(this.mContainers, true);
        this.addPlacemarksToMap(this.getAllFeatures());
        if (!this.mGroundOverlayImagesDownloaded) {
            this.downloadGroundOverlays();
        }
        if (!this.mMarkerIconsDownloaded) {
            this.downloadMarkerIcons();
        }
    }

    void storeKmlData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> features, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        this.storeData(styles, styleMaps, features, folders, groundOverlays);
    }

    @Override
    public void setMap(GoogleMap map) {
        this.removeLayerFromMap();
        super.setMap(map);
        this.addLayerToMap();
    }

    boolean hasKmlPlacemarks() {
        return this.hasFeatures();
    }

    Iterable<? extends Feature> getKmlPlacemarks() {
        return this.getFeatures();
    }

    public boolean hasNestedContainers() {
        return this.mContainers.size() > 0;
    }

    public Iterable<KmlContainer> getNestedContainers() {
        return this.mContainers;
    }

    public Iterable<KmlGroundOverlay> getGroundOverlays() {
        return this.mGroundOverlays.keySet();
    }

    public void removeLayerFromMap() {
        this.removePlacemarks(this.getAllFeatures());
        this.removeGroundOverlays(this.mGroundOverlays);
        if (this.hasNestedContainers()) {
            this.removeContainers(this.getNestedContainers());
        }
        this.setLayerVisibility(false);
        this.clearStylesRenderer();
    }

    private void addPlacemarksToMap(HashMap<? extends Feature, Object> placemarks) {
        for (Feature feature : placemarks.keySet()) {
            this.addFeature(feature);
        }
    }

    private void addContainerGroupToMap(Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            if (container.getStyles() != null) {
                this.putStyles(container.getStyles());
            }
            if (container.getStyleMap() != null) {
                super.assignStyleMap(container.getStyleMap(), this.getStylesRenderer());
            }
            this.addContainerObjectToMap(container, isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addContainerGroupToMap(container.getContainers(), isContainerVisible);
        }
    }

    private void addContainerObjectToMap(KmlContainer kmlContainer, boolean isContainerVisible) {
        for (Feature feature : kmlContainer.getPlacemarks()) {
            boolean isObjectVisible;
            boolean isPlacemarkVisible = KmlRenderer.getPlacemarkVisibility(feature);
            boolean bl = isObjectVisible = isContainerVisible && isPlacemarkVisible;
            if (feature.getGeometry() == null) continue;
            String placemarkId = feature.getId();
            Geometry geometry = feature.getGeometry();
            KmlStyle style = this.getPlacemarkStyle(placemarkId);
            KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
            Object mapObject = this.addKmlPlacemarkToMap((KmlPlacemark)feature, geometry, style, inlineStyle, isObjectVisible);
            kmlContainer.setPlacemark((KmlPlacemark)feature, mapObject);
            this.putContainerFeature(mapObject, feature);
        }
    }

    private void downloadMarkerIcons() {
        this.mMarkerIconsDownloaded = true;
        Iterator<String> iterator = this.getMarkerIconUrls().iterator();
        while (iterator.hasNext()) {
            String markerIconUrl = iterator.next();
            new MarkerIconImageDownload(markerIconUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addIconToMarkers(String iconUrl, HashMap<KmlPlacemark, Object> placemarks) {
        for (Feature feature : placemarks.keySet()) {
            boolean isPlacemarkStyleIcon;
            KmlStyle urlStyle = this.getStylesRenderer().get(feature.getId());
            KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
            if (!"Point".equals(feature.getGeometry().getGeometryType())) continue;
            boolean isInlineStyleIcon = inlineStyle != null && iconUrl.equals(inlineStyle.getIconUrl());
            boolean bl = isPlacemarkStyleIcon = urlStyle != null && iconUrl.equals(urlStyle.getIconUrl());
            if (isInlineStyleIcon) {
                this.scaleBitmap(inlineStyle, placemarks, (KmlPlacemark)feature);
                continue;
            }
            if (!isPlacemarkStyleIcon) continue;
            this.scaleBitmap(urlStyle, placemarks, (KmlPlacemark)feature);
        }
    }

    private void scaleBitmap(KmlStyle style, HashMap<KmlPlacemark, Object> placemarks, KmlPlacemark placemark) {
        double bitmapScale = style.getIconScale();
        String bitmapUrl = style.getIconUrl();
        Bitmap bitmapImage = (Bitmap)this.getImagesCache().get((Object)bitmapUrl);
        BitmapDescriptor scaledBitmap = KmlRenderer.scaleIcon(bitmapImage, bitmapScale);
        ((Marker)placemarks.get(placemark)).setIcon(scaledBitmap);
    }

    private void addContainerGroupIconsToMarkers(String iconUrl, Iterable<KmlContainer> kmlContainers) {
        for (KmlContainer container : kmlContainers) {
            this.addIconToMarkers(iconUrl, container.getPlacemarksHashMap());
            if (!container.hasContainers()) continue;
            this.addContainerGroupIconsToMarkers(iconUrl, container.getContainers());
        }
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, Iterable<KmlContainer> kmlContainers) {
        this.addGroundOverlays(groundOverlays);
        for (KmlContainer container : kmlContainers) {
            this.addGroundOverlays(container.getGroundOverlayHashMap(), container.getContainers());
        }
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (KmlGroundOverlay groundOverlay : groundOverlays.keySet()) {
            String groundOverlayUrl = groundOverlay.getImageUrl();
            if (groundOverlayUrl == null || groundOverlay.getLatLngBox() == null) continue;
            if (this.getImagesCache().get((Object)groundOverlayUrl) != null) {
                this.addGroundOverlayToMap(groundOverlayUrl, this.mGroundOverlays, true);
                continue;
            }
            if (this.mGroundOverlayUrls.contains(groundOverlayUrl)) continue;
            this.mGroundOverlayUrls.add(groundOverlayUrl);
        }
    }

    private void downloadGroundOverlays() {
        this.mGroundOverlayImagesDownloaded = true;
        Iterator<String> iterator = this.mGroundOverlayUrls.iterator();
        while (iterator.hasNext()) {
            String groundOverlayUrl = iterator.next();
            new GroundOverlayImageDownload(groundOverlayUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addGroundOverlayToMap(String groundOverlayUrl, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, boolean containerVisibility) {
        BitmapDescriptor groundOverlayBitmap = BitmapDescriptorFactory.fromBitmap((Bitmap)((Bitmap)this.getImagesCache().get((Object)groundOverlayUrl)));
        for (KmlGroundOverlay kmlGroundOverlay : groundOverlays.keySet()) {
            if (!kmlGroundOverlay.getImageUrl().equals(groundOverlayUrl)) continue;
            GroundOverlayOptions groundOverlayOptions = kmlGroundOverlay.getGroundOverlayOptions().image(groundOverlayBitmap);
            GroundOverlay mapGroundOverlay = this.attachGroundOverlay(groundOverlayOptions);
            if (!containerVisibility) {
                mapGroundOverlay.setVisible(false);
            }
            groundOverlays.put(kmlGroundOverlay, mapGroundOverlay);
        }
    }

    private void addGroundOverlayInContainerGroups(String groundOverlayUrl, Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            this.addGroundOverlayToMap(groundOverlayUrl, container.getGroundOverlayHashMap(), isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addGroundOverlayInContainerGroups(groundOverlayUrl, container.getContainers(), isContainerVisible);
        }
    }

    private class GroundOverlayImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mGroundOverlayUrl;

        public GroundOverlayImageDownload(String groundOverlayUrl) {
            this.mGroundOverlayUrl = groundOverlayUrl;
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return BitmapFactory.decodeStream((InputStream)((InputStream)new URL(this.mGroundOverlayUrl).getContent()));
            }
            catch (MalformedURLException e) {
                return BitmapFactory.decodeFile((String)this.mGroundOverlayUrl);
            }
            catch (IOException e) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image [" + this.mGroundOverlayUrl + "] download issue"), (Throwable)e);
                return null;
            }
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image at this URL could not be found " + this.mGroundOverlayUrl));
            } else {
                KmlRenderer.this.putImagesCache(this.mGroundOverlayUrl, bitmap);
                if (KmlRenderer.this.isLayerOnMap()) {
                    KmlRenderer.this.addGroundOverlayToMap(this.mGroundOverlayUrl, KmlRenderer.this.mGroundOverlays, true);
                    KmlRenderer.this.addGroundOverlayInContainerGroups(this.mGroundOverlayUrl, KmlRenderer.this.mContainers, true);
                }
            }
        }
    }

    private class MarkerIconImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mIconUrl;

        public MarkerIconImageDownload(String iconUrl) {
            this.mIconUrl = iconUrl;
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return BitmapFactory.decodeStream((InputStream)((InputStream)new URL(this.mIconUrl).getContent()));
            }
            catch (MalformedURLException e) {
                return BitmapFactory.decodeFile((String)this.mIconUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image at this URL could not be found " + this.mIconUrl));
            } else {
                KmlRenderer.this.putImagesCache(this.mIconUrl, bitmap);
                if (KmlRenderer.this.isLayerOnMap()) {
                    KmlRenderer.this.addIconToMarkers(this.mIconUrl, KmlRenderer.this.getAllFeatures());
                    KmlRenderer.this.addContainerGroupIconsToMarkers(this.mIconUrl, KmlRenderer.this.mContainers);
                }
            }
        }
    }
}

