/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlLineString;
import com.google.maps.android.data.kml.KmlMultiGeometry;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlPoint;
import com.google.maps.android.data.kml.KmlPolygon;
import com.google.maps.android.data.kml.KmlStyle;
import com.google.maps.android.data.kml.KmlStyleParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class KmlFeatureParser {
    private static final String GEOMETRY_REGEX = "Point|LineString|Polygon|MultiGeometry";
    private static final int LONGITUDE_INDEX = 0;
    private static final int LATITUDE_INDEX = 1;
    private static final String PROPERTY_REGEX = "name|description|drawOrder|visibility|open|address|phoneNumber";
    private static final String BOUNDARY_REGEX = "outerBoundaryIs|innerBoundaryIs";
    private static final String EXTENDED_DATA = "ExtendedData";
    private static final String STYLE_URL_TAG = "styleUrl";
    private static final String STYLE_TAG = "Style";
    private static final String COMPASS_REGEX = "north|south|east|west";

    KmlFeatureParser() {
    }

    static KmlPlacemark createPlacemark(XmlPullParser parser) throws IOException, XmlPullParserException {
        String styleId = null;
        KmlStyle inlineStyle = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        Geometry geometry = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Placemark")) {
            if (eventType == 2) {
                if (parser.getName().equals(STYLE_URL_TAG)) {
                    styleId = parser.nextText();
                } else if (parser.getName().matches(GEOMETRY_REGEX)) {
                    geometry = KmlFeatureParser.createGeometry(parser, parser.getName());
                } else if (parser.getName().matches(PROPERTY_REGEX)) {
                    properties.put(parser.getName(), parser.nextText());
                } else if (parser.getName().equals(EXTENDED_DATA)) {
                    properties.putAll(KmlFeatureParser.setExtendedDataProperties(parser));
                } else if (parser.getName().equals(STYLE_TAG)) {
                    inlineStyle = KmlStyleParser.createStyle(parser);
                }
            }
            eventType = parser.next();
        }
        return new KmlPlacemark(geometry, styleId, inlineStyle, properties);
    }

    static KmlGroundOverlay createGroundOverlay(XmlPullParser parser) throws IOException, XmlPullParserException {
        float drawOrder = 0.0f;
        float rotation = 0.0f;
        int visibility = 1;
        String imageUrl = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, Double> compassPoints = new HashMap<String, Double>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("GroundOverlay")) {
            if (eventType == 2) {
                if (parser.getName().equals("Icon")) {
                    imageUrl = KmlFeatureParser.getImageUrl(parser);
                } else if (parser.getName().equals("drawOrder")) {
                    drawOrder = Float.parseFloat(parser.nextText());
                } else if (parser.getName().equals("visibility")) {
                    visibility = Integer.parseInt(parser.nextText());
                } else if (parser.getName().equals(EXTENDED_DATA)) {
                    properties.putAll(KmlFeatureParser.setExtendedDataProperties(parser));
                } else if (parser.getName().equals("rotation")) {
                    rotation = KmlFeatureParser.getRotation(parser);
                } else if (parser.getName().matches(PROPERTY_REGEX) || parser.getName().equals("color")) {
                    properties.put(parser.getName(), parser.nextText());
                } else if (parser.getName().matches(COMPASS_REGEX)) {
                    compassPoints.put(parser.getName(), Double.parseDouble(parser.nextText()));
                }
            }
            eventType = parser.next();
        }
        LatLngBounds latLonBox = KmlFeatureParser.createLatLngBounds((Double)compassPoints.get("north"), (Double)compassPoints.get("south"), (Double)compassPoints.get("east"), (Double)compassPoints.get("west"));
        return new KmlGroundOverlay(imageUrl, latLonBox, drawOrder, visibility, properties, rotation);
    }

    private static float getRotation(XmlPullParser parser) throws IOException, XmlPullParserException {
        return -Float.parseFloat(parser.nextText());
    }

    private static String getImageUrl(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Icon")) {
            if (eventType == 2 && parser.getName().equals("href")) {
                return parser.nextText();
            }
            eventType = parser.next();
        }
        return null;
    }

    private static Geometry createGeometry(XmlPullParser parser, String geometryType) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals(geometryType)) {
            if (eventType == 2) {
                if (parser.getName().equals("Point")) {
                    return KmlFeatureParser.createPoint(parser);
                }
                if (parser.getName().equals("LineString")) {
                    return KmlFeatureParser.createLineString(parser);
                }
                if (parser.getName().equals("Polygon")) {
                    return KmlFeatureParser.createPolygon(parser);
                }
                if (parser.getName().equals("MultiGeometry")) {
                    return KmlFeatureParser.createMultiGeometry(parser);
                }
            }
            eventType = parser.next();
        }
        return null;
    }

    private static HashMap<String, String> setExtendedDataProperties(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String propertyKey = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals(EXTENDED_DATA)) {
            if (eventType == 2) {
                if (parser.getName().equals("Data")) {
                    propertyKey = parser.getAttributeValue(null, "name");
                } else if (parser.getName().equals("value") && propertyKey != null) {
                    properties.put(propertyKey, parser.nextText());
                    propertyKey = null;
                }
            }
            eventType = parser.next();
        }
        return properties;
    }

    private static KmlPoint createPoint(XmlPullParser parser) throws XmlPullParserException, IOException {
        LatLng coordinate = null;
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Point")) {
            if (eventType == 2 && parser.getName().equals("coordinates")) {
                coordinate = KmlFeatureParser.convertToLatLng(parser.nextText());
            }
            eventType = parser.next();
        }
        return new KmlPoint(coordinate);
    }

    private static KmlLineString createLineString(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<LatLng> coordinates = new ArrayList<LatLng>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("LineString")) {
            if (eventType == 2 && parser.getName().equals("coordinates")) {
                coordinates = KmlFeatureParser.convertToLatLngArray(parser.nextText());
            }
            eventType = parser.next();
        }
        return new KmlLineString(coordinates);
    }

    private static KmlPolygon createPolygon(XmlPullParser parser) throws XmlPullParserException, IOException {
        Boolean isOuterBoundary = false;
        ArrayList<LatLng> outerBoundary = new ArrayList<LatLng>();
        ArrayList<List<LatLng>> innerBoundaries = new ArrayList<List<LatLng>>();
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Polygon")) {
            if (eventType == 2) {
                if (parser.getName().matches(BOUNDARY_REGEX)) {
                    isOuterBoundary = parser.getName().equals("outerBoundaryIs");
                } else if (parser.getName().equals("coordinates")) {
                    if (isOuterBoundary.booleanValue()) {
                        outerBoundary = KmlFeatureParser.convertToLatLngArray(parser.nextText());
                    } else {
                        innerBoundaries.add(KmlFeatureParser.convertToLatLngArray(parser.nextText()));
                    }
                }
            }
            eventType = parser.next();
        }
        return new KmlPolygon(outerBoundary, innerBoundaries);
    }

    private static KmlMultiGeometry createMultiGeometry(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        int eventType = parser.next();
        while (eventType != 3 || !parser.getName().equals("MultiGeometry")) {
            if (eventType == 2 && parser.getName().matches(GEOMETRY_REGEX)) {
                geometries.add(KmlFeatureParser.createGeometry(parser, parser.getName()));
            }
            eventType = parser.next();
        }
        return new KmlMultiGeometry(geometries);
    }

    private static ArrayList<LatLng> convertToLatLngArray(String coordinatesString) {
        String[] coordinates;
        ArrayList<LatLng> coordinatesArray = new ArrayList<LatLng>();
        for (String coordinate : coordinates = coordinatesString.trim().split("(\\s+)")) {
            coordinatesArray.add(KmlFeatureParser.convertToLatLng(coordinate));
        }
        return coordinatesArray;
    }

    private static LatLng convertToLatLng(String coordinateString) {
        String[] coordinate = coordinateString.split(",");
        Double lat = Double.parseDouble(coordinate[1]);
        Double lon = Double.parseDouble(coordinate[0]);
        return new LatLng(lat.doubleValue(), lon.doubleValue());
    }

    private static LatLngBounds createLatLngBounds(Double north, Double south, Double east, Double west) {
        LatLng southWest = new LatLng(south.doubleValue(), west.doubleValue());
        LatLng northEast = new LatLng(north.doubleValue(), east.doubleValue());
        return new LatLngBounds(southWest, northEast);
    }
}

