/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.kml;

import com.google.maps.android.kml.KmlGeometry;
import com.google.maps.android.kml.KmlStyle;
import java.util.HashMap;

public class KmlPlacemark {
    private final KmlGeometry mGeometry;
    private final String mStyle;
    private final KmlStyle mInlineStyle;
    private HashMap<String, String> mProperties = new HashMap();

    public KmlPlacemark(KmlGeometry geometry, String style2, KmlStyle inlineStyle, HashMap<String, String> properties) {
        this.mGeometry = geometry;
        this.mStyle = style2;
        this.mInlineStyle = inlineStyle;
        this.mProperties = properties;
    }

    public String getStyleId() {
        return this.mStyle;
    }

    public KmlStyle getInlineStyle() {
        return this.mInlineStyle;
    }

    public Iterable getProperties() {
        return this.mProperties.entrySet();
    }

    public String getProperty(String keyValue) {
        return this.mProperties.get(keyValue);
    }

    public KmlGeometry getGeometry() {
        return this.mGeometry;
    }

    public boolean hasProperty(String keyValue) {
        return this.mProperties.containsKey(keyValue);
    }

    public boolean hasProperties() {
        return this.mProperties.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Placemark").append("{");
        sb.append("\n style id=").append(this.mStyle);
        sb.append(",\n inline style=").append(this.mInlineStyle);
        sb.append(",\n properties=").append(this.mProperties);
        sb.append(",\n geometry=").append(this.mGeometry);
        sb.append("\n}\n");
        return sb.toString();
    }
}

