/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.MathUtil;
import com.google.maps.android.SphericalUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class PolyUtil {
    private static final double DEFAULT_TOLERANCE = 0.1;

    private PolyUtil() {
    }

    private static double tanLatGC(double lat1, double lat2, double lng2, double lng3) {
        return (Math.tan(lat1) * Math.sin(lng2 - lng3) + Math.tan(lat2) * Math.sin(lng3)) / Math.sin(lng2);
    }

    private static double mercatorLatRhumb(double lat1, double lat2, double lng2, double lng3) {
        return (MathUtil.mercator(lat1) * (lng2 - lng3) + MathUtil.mercator(lat2) * lng3) / lng2;
    }

    private static boolean intersects(double lat1, double lat2, double lng2, double lat3, double lng3, boolean geodesic) {
        if (lng3 >= 0.0 && lng3 >= lng2 || lng3 < 0.0 && lng3 < lng2) {
            return false;
        }
        if (lat3 <= -1.5707963267948966) {
            return false;
        }
        if (lat1 <= -1.5707963267948966 || lat2 <= -1.5707963267948966 || lat1 >= 1.5707963267948966 || lat2 >= 1.5707963267948966) {
            return false;
        }
        if (lng2 <= -Math.PI) {
            return false;
        }
        double linearLat = (lat1 * (lng2 - lng3) + lat2 * lng3) / lng2;
        if (lat1 >= 0.0 && lat2 >= 0.0 && lat3 < linearLat) {
            return false;
        }
        if (lat1 <= 0.0 && lat2 <= 0.0 && lat3 >= linearLat) {
            return true;
        }
        if (lat3 >= 1.5707963267948966) {
            return true;
        }
        return geodesic ? Math.tan(lat3) >= PolyUtil.tanLatGC(lat1, lat2, lng2, lng3) : MathUtil.mercator(lat3) >= PolyUtil.mercatorLatRhumb(lat1, lat2, lng2, lng3);
    }

    public static boolean containsLocation(LatLng point, List<LatLng> polygon, boolean geodesic) {
        int size = polygon.size();
        if (size == 0) {
            return false;
        }
        double lat3 = Math.toRadians(point.latitude);
        double lng3 = Math.toRadians(point.longitude);
        LatLng prev = polygon.get(size - 1);
        double lat1 = Math.toRadians(prev.latitude);
        double lng1 = Math.toRadians(prev.longitude);
        int nIntersect = 0;
        for (LatLng point2 : polygon) {
            double lng2;
            double dLng3 = MathUtil.wrap(lng3 - lng1, -Math.PI, Math.PI);
            if (lat3 == lat1 && dLng3 == 0.0) {
                return true;
            }
            double lat2 = Math.toRadians(point2.latitude);
            if (PolyUtil.intersects(lat1, lat2, MathUtil.wrap((lng2 = Math.toRadians(point2.longitude)) - lng1, -Math.PI, Math.PI), lat3, dLng3, geodesic)) {
                ++nIntersect;
            }
            lat1 = lat2;
            lng1 = lng2;
        }
        return nIntersect & true;
    }

    public static boolean isLocationOnEdge(LatLng point, List<LatLng> polygon, boolean geodesic, double tolerance) {
        return PolyUtil.isLocationOnEdgeOrPath(point, polygon, true, geodesic, tolerance);
    }

    public static boolean isLocationOnEdge(LatLng point, List<LatLng> polygon, boolean geodesic) {
        return PolyUtil.isLocationOnEdge(point, polygon, geodesic, 0.1);
    }

    public static boolean isLocationOnPath(LatLng point, List<LatLng> polyline, boolean geodesic, double tolerance) {
        return PolyUtil.isLocationOnEdgeOrPath(point, polyline, false, geodesic, tolerance);
    }

    public static boolean isLocationOnPath(LatLng point, List<LatLng> polyline, boolean geodesic) {
        return PolyUtil.isLocationOnPath(point, polyline, geodesic, 0.1);
    }

    private static boolean isLocationOnEdgeOrPath(LatLng point, List<LatLng> poly, boolean closed, boolean geodesic, double toleranceEarth) {
        int size = poly.size();
        if (size == 0) {
            return false;
        }
        double tolerance = toleranceEarth / 6371009.0;
        double havTolerance = MathUtil.hav(tolerance);
        double lat3 = Math.toRadians(point.latitude);
        double lng3 = Math.toRadians(point.longitude);
        LatLng prev = poly.get(closed ? size - 1 : 0);
        double lat1 = Math.toRadians(prev.latitude);
        double lng1 = Math.toRadians(prev.longitude);
        if (geodesic) {
            for (LatLng point2 : poly) {
                double lng2;
                double lat2 = Math.toRadians(point2.latitude);
                if (PolyUtil.isOnSegmentGC(lat1, lng1, lat2, lng2 = Math.toRadians(point2.longitude), lat3, lng3, havTolerance)) {
                    return true;
                }
                lat1 = lat2;
                lng1 = lng2;
            }
        } else {
            double minAcceptable = lat3 - tolerance;
            double maxAcceptable = lat3 + tolerance;
            double y1 = MathUtil.mercator(lat1);
            double y3 = MathUtil.mercator(lat3);
            double[] xTry = new double[3];
            for (LatLng point2 : poly) {
                double lat2 = Math.toRadians(point2.latitude);
                double y2 = MathUtil.mercator(lat2);
                double lng2 = Math.toRadians(point2.longitude);
                if (Math.max(lat1, lat2) >= minAcceptable && Math.min(lat1, lat2) <= maxAcceptable) {
                    double x3Base;
                    double x2 = MathUtil.wrap(lng2 - lng1, -Math.PI, Math.PI);
                    xTry[0] = x3Base = MathUtil.wrap(lng3 - lng1, -Math.PI, Math.PI);
                    xTry[1] = x3Base + Math.PI * 2;
                    xTry[2] = x3Base - Math.PI * 2;
                    for (double x3 : xTry) {
                        double dy = y2 - y1;
                        double len2 = x2 * x2 + dy * dy;
                        double t = len2 <= 0.0 ? 0.0 : MathUtil.clamp((x3 * x2 + (y3 - y1) * dy) / len2, 0.0, 1.0);
                        double xClosest = t * x2;
                        double yClosest = y1 + t * dy;
                        double latClosest = MathUtil.inverseMercator(yClosest);
                        double havDist = MathUtil.havDistance(lat3, latClosest, x3 - xClosest);
                        if (!(havDist < havTolerance)) continue;
                        return true;
                    }
                }
                lat1 = lat2;
                lng1 = lng2;
                y1 = y2;
            }
        }
        return false;
    }

    private static double sinDeltaBearing(double lat1, double lng1, double lat2, double lng2, double lat3, double lng3) {
        double d;
        double sinLat1 = Math.sin(lat1);
        double cosLat2 = Math.cos(lat2);
        double cosLat3 = Math.cos(lat3);
        double lat31 = lat3 - lat1;
        double lng31 = lng3 - lng1;
        double lat21 = lat2 - lat1;
        double lng21 = lng2 - lng1;
        double a = Math.sin(lng31) * cosLat3;
        double c = Math.sin(lng21) * cosLat2;
        double b = Math.sin(lat31) + 2.0 * sinLat1 * cosLat3 * MathUtil.hav(lng31);
        double denom = (a * a + b * b) * (c * c + (d = Math.sin(lat21) + 2.0 * sinLat1 * cosLat2 * MathUtil.hav(lng21)) * d);
        return denom <= 0.0 ? 1.0 : (a * d - b * c) / Math.sqrt(denom);
    }

    private static boolean isOnSegmentGC(double lat1, double lng1, double lat2, double lng2, double lat3, double lng3, double havTolerance) {
        double havDist13 = MathUtil.havDistance(lat1, lat3, lng1 - lng3);
        if (havDist13 <= havTolerance) {
            return true;
        }
        double havDist23 = MathUtil.havDistance(lat2, lat3, lng2 - lng3);
        if (havDist23 <= havTolerance) {
            return true;
        }
        double sinBearing = PolyUtil.sinDeltaBearing(lat1, lng1, lat2, lng2, lat3, lng3);
        double sinDist13 = MathUtil.sinFromHav(havDist13);
        double havCrossTrack = MathUtil.havFromSin(sinDist13 * sinBearing);
        if (havCrossTrack > havTolerance) {
            return false;
        }
        double havDist12 = MathUtil.havDistance(lat1, lat2, lng1 - lng2);
        double term = havDist12 + havCrossTrack * (1.0 - 2.0 * havDist12);
        if (havDist13 > term || havDist23 > term) {
            return false;
        }
        if (havDist12 < 0.74) {
            return true;
        }
        double cosCrossTrack = 1.0 - 2.0 * havCrossTrack;
        double havAlongTrack13 = (havDist13 - havCrossTrack) / cosCrossTrack;
        double havAlongTrack23 = (havDist23 - havCrossTrack) / cosCrossTrack;
        double sinSumAlongTrack = MathUtil.sinSumFromHav(havAlongTrack13, havAlongTrack23);
        return sinSumAlongTrack > 0.0;
    }

    public static List<LatLng> simplify(List<LatLng> poly, double tolerance) {
        int n = poly.size();
        if (n < 1) {
            throw new IllegalArgumentException("Polyline must have at least 1 point");
        }
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than zero");
        }
        boolean closedPolygon = PolyUtil.isClosedPolygon(poly);
        if (closedPolygon) {
            double OFFSET = 1.0E-11;
            LatLng lastPoint = poly.get(poly.size() - 1);
            poly.remove(poly.size() - 1);
            poly.add(new LatLng(lastPoint.latitude + 1.0E-11, lastPoint.longitude + 1.0E-11));
        }
        int maxIdx = 0;
        Stack<int[]> stack = new Stack<int[]>();
        double[] dists = new double[n];
        dists[0] = 1.0;
        dists[n - 1] = 1.0;
        double dist = 0.0;
        if (n > 2) {
            int[] stackVal = new int[]{0, n - 1};
            stack.push(stackVal);
            while (stack.size() > 0) {
                int[] current = (int[])stack.pop();
                double maxDist = 0.0;
                for (int idx = current[0] + 1; idx < current[1]; ++idx) {
                    dist = PolyUtil.distanceToLine(poly.get(idx), poly.get(current[0]), poly.get(current[1]));
                    if (!(dist > maxDist)) continue;
                    maxDist = dist;
                    maxIdx = idx;
                }
                if (!(maxDist > tolerance)) continue;
                dists[maxIdx] = maxDist;
                int[] stackValCurMax = new int[]{current[0], maxIdx};
                stack.push(stackValCurMax);
                int[] stackValMaxCur = new int[]{maxIdx, current[1]};
                stack.push(stackValMaxCur);
            }
        }
        if (closedPolygon) {
            poly.remove(poly.size() - 1);
            poly.add(new LatLng(poly.get((int)0).latitude, poly.get((int)0).longitude));
        }
        int idx = 0;
        ArrayList<LatLng> simplifiedLine = new ArrayList<LatLng>();
        for (LatLng l : poly) {
            if (dists[idx] != 0.0) {
                simplifiedLine.add(l);
            }
            ++idx;
        }
        return simplifiedLine;
    }

    public static boolean isClosedPolygon(List<LatLng> poly) {
        LatLng lastPoint;
        LatLng firstPoint = poly.get(0);
        return firstPoint.equals((Object)(lastPoint = poly.get(poly.size() - 1)));
    }

    public static double distanceToLine(LatLng p, LatLng start, LatLng end) {
        double s2lng;
        double s2s1lng;
        if (start.equals((Object)end)) {
            SphericalUtil.computeDistanceBetween(end, p);
        }
        double s0lat = Math.toRadians(p.latitude);
        double s0lng = Math.toRadians(p.longitude);
        double s1lat = Math.toRadians(start.latitude);
        double s1lng = Math.toRadians(start.longitude);
        double s2lat = Math.toRadians(end.latitude);
        double s2s1lat = s2lat - s1lat;
        double u = ((s0lat - s1lat) * s2s1lat + (s0lng - s1lng) * (s2s1lng = (s2lng = Math.toRadians(end.longitude)) - s1lng)) / (s2s1lat * s2s1lat + s2s1lng * s2s1lng);
        if (u <= 0.0) {
            return SphericalUtil.computeDistanceBetween(p, start);
        }
        if (u >= 1.0) {
            return SphericalUtil.computeDistanceBetween(p, end);
        }
        LatLng sa = new LatLng(p.latitude - start.latitude, p.longitude - start.longitude);
        LatLng sb = new LatLng(u * (end.latitude - start.latitude), u * (end.longitude - start.longitude));
        return SphericalUtil.computeDistanceBetween(sa, sb);
    }

    public static List<LatLng> decode(String encodedPath) {
        int len = encodedPath.length();
        ArrayList<LatLng> path = new ArrayList<LatLng>();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int b;
            int result = 1;
            int shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            path.add(new LatLng((double)lat * 1.0E-5, (double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) * 1.0E-5));
        }
        return path;
    }

    public static String encode(List<LatLng> path) {
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuffer result = new StringBuffer();
        for (LatLng point : path) {
            long lat = Math.round(point.latitude * 100000.0);
            long lng = Math.round(point.longitude * 100000.0);
            long dLat = lat - lastLat;
            long dLng = lng - lastLng;
            PolyUtil.encode(dLat, result);
            PolyUtil.encode(dLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        return result.toString();
    }

    private static void encode(long v, StringBuffer result) {
        long l = v = v < 0L ? v << 1 ^ 0xFFFFFFFFFFFFFFFFL : v << 1;
        while (v >= 32L) {
            result.append(Character.toChars((int)((0x20L | v & 0x1FL) + 63L)));
            v >>= 5;
        }
        result.append(Character.toChars((int)(v + 63L)));
    }
}

