/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.quadtree;

import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.geometry.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PointQuadTree<T extends Item> {
    private final Bounds mBounds;
    private final int mDepth;
    private static final int MAX_ELEMENTS = 60;
    private List<T> mItems;
    private static final int MAX_DEPTH = 30;
    private PointQuadTree<T>[] mChildren = null;

    public PointQuadTree(double minX, double maxX, double minY, double maxY) {
        this(new Bounds(minX, maxX, minY, maxY));
    }

    public PointQuadTree(Bounds bounds) {
        this(bounds, 0);
    }

    private PointQuadTree(double minX, double maxX, double minY, double maxY, int depth) {
        this(new Bounds(minX, maxX, minY, maxY), depth);
    }

    private PointQuadTree(Bounds bounds, int depth) {
        this.mBounds = bounds;
        this.mDepth = depth;
    }

    public void add(T item) {
        Point point = item.getPoint();
        this.insert(point.x, point.y, item);
    }

    private boolean insert(double x, double y, T item) {
        if (!this.mBounds.contains(x, y)) {
            return false;
        }
        if (this.mChildren != null) {
            for (PointQuadTree<T> quad : this.mChildren) {
                if (!super.insert(x, y, item)) continue;
                return true;
            }
            return false;
        }
        if (this.mItems == null) {
            this.mItems = new ArrayList<T>();
        }
        this.mItems.add(item);
        if (this.mItems.size() > 60 && this.mDepth < 30) {
            this.split();
        }
        return true;
    }

    private void split() {
        this.mChildren = new PointQuadTree[]{new PointQuadTree<T>(this.mBounds.minX, this.mBounds.midX, this.mBounds.minY, this.mBounds.midY, this.mDepth + 1), new PointQuadTree<T>(this.mBounds.midX, this.mBounds.maxX, this.mBounds.minY, this.mBounds.midY, this.mDepth + 1), new PointQuadTree<T>(this.mBounds.minX, this.mBounds.midX, this.mBounds.midY, this.mBounds.maxY, this.mDepth + 1), new PointQuadTree<T>(this.mBounds.midX, this.mBounds.maxX, this.mBounds.midY, this.mBounds.maxY, this.mDepth + 1)};
        List<T> items = this.mItems;
        this.mItems = null;
        for (Item item : items) {
            this.add(item);
        }
    }

    public boolean remove(T item) {
        Point point = item.getPoint();
        return this.remove(point.x, point.y, item);
    }

    private boolean remove(double x, double y, T item) {
        if (!this.mBounds.contains(x, y)) {
            return false;
        }
        if (this.mChildren != null) {
            for (PointQuadTree<T> quad : this.mChildren) {
                if (!super.remove(x, y, item)) continue;
                return true;
            }
            return false;
        }
        return this.mItems.remove(item);
    }

    public void clear() {
        this.mChildren = null;
        if (this.mItems != null) {
            this.mItems.clear();
        }
    }

    public Collection<T> search(Bounds searchBounds) {
        ArrayList results = new ArrayList();
        this.search(searchBounds, results);
        return results;
    }

    private void search(Bounds searchBounds, Collection<T> results) {
        block4: {
            block3: {
                if (!this.mBounds.intersects(searchBounds)) {
                    return;
                }
                if (this.mChildren == null) break block3;
                for (PointQuadTree<T> quad : this.mChildren) {
                    super.search(searchBounds, results);
                }
                break block4;
            }
            if (this.mItems == null) break block4;
            for (Item item : this.mItems) {
                if (!searchBounds.contains(item.getPoint())) continue;
                results.add(item);
            }
        }
    }

    public static interface Item {
        public Point getPoint();
    }
}

