/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DiscreteDistribution<T> {
    private Random random;
    private List<T> items;
    private List<Double> weights;

    public DiscreteDistribution(Random random, ArrayList<T> items, ArrayList<Double> weights) {
        this.random = random;
        this.items = items;
        this.weights = weights;
        double sum = 0.0;
        for (Double w : weights) {
            Preconditions.checkArgument((w >= 0.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!Double.isInfinite(w) ? 1 : 0) != 0);
            Preconditions.checkArgument((!Double.isNaN(w) ? 1 : 0) != 0);
            sum += w.doubleValue();
        }
        for (int i = 0; i < weights.size(); ++i) {
            weights.set(i, weights.get(i) / sum);
        }
    }

    public T nextItem() {
        double randomValue = this.random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (Double.compare(randomValue, sum += this.weights.get(i).doubleValue()) > 0) continue;
            return this.items.get(i);
        }
        return null;
    }
}

