/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import java.io.PrintStream;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.StringTokenizer;

class JvmMetrics {
    private static final int TABULAR_COLON_POS = 40;
    private static final long ONE_KILO_BYTE = 1024L;
    private static final long ONE_MEGA_BYTE = 0x100000L;
    private static final long ONE_GIGA_BYTE = 0x40000000L;

    JvmMetrics() {
    }

    public static void maybeWriteJvmMetrics(PrintStream out, String options) {
        String mode;
        if (options == null) {
            return;
        }
        boolean verboseMode = false;
        boolean prettyMode = false;
        StringTokenizer st = new StringTokenizer(options, ":");
        if (st.hasMoreTokens() && (mode = st.nextToken()).equalsIgnoreCase("verbose")) {
            verboseMode = true;
        }
        if (st.hasMoreTokens() && (mode = st.nextToken()).equalsIgnoreCase("pretty")) {
            prettyMode = true;
        }
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String types = st.nextToken();
                StringTokenizer typeSt = new StringTokenizer(types, ",");
                while (typeSt.hasMoreElements()) {
                    String type = typeSt.nextToken();
                    JvmMetrics.writeMetrics(out, type, verboseMode, prettyMode);
                }
            }
        } else {
            JvmMetrics.writeMetrics(out, "all", verboseMode, prettyMode);
        }
    }

    private static void writeMetrics(PrintStream out, String type, boolean verbose, boolean pretty) {
        if (type.equals("gc") || type.equalsIgnoreCase("all")) {
            JvmMetrics.writeGarbageCollectionStats(out, verbose, pretty);
        }
        if (type.equals("mem") || type.equalsIgnoreCase("all")) {
            JvmMetrics.writeMemoryMetrics(out, verbose, pretty);
        }
        if (type.equals("jit") || type.equalsIgnoreCase("all")) {
            JvmMetrics.writeJitMetrics(out, verbose, pretty);
        }
    }

    private static void writeJitMetrics(PrintStream out, boolean verbose, boolean pretty) {
        CompilationMXBean cBean = ManagementFactory.getCompilationMXBean();
        String name = verbose ? cBean.getName() : "total";
        if (pretty) {
            out.println("\nJIT Stats");
            out.println(String.format("\t%s jit time: %d ms", name, cBean.getTotalCompilationTime()));
        } else {
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-jit-time-ms : %d", JvmMetrics.normalizeName(name), cBean.getTotalCompilationTime())));
        }
    }

    private static void writeOverallMemoryUsage(PrintStream out, MemoryUsage usage, String prefix, boolean pretty) {
        if (pretty) {
            out.format("\t%s\n", prefix);
            out.format("\t\tavailable         : %s\n", JvmMetrics.formatBytes(usage.getMax()));
            out.format("\t\tcurrent           : %s\n", JvmMetrics.formatBytes(usage.getUsed()));
        } else {
            prefix = JvmMetrics.normalizeName(prefix);
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-available-bytes : %d", prefix, usage.getMax())));
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-current-bytes : %d", prefix, usage.getUsed())));
        }
    }

    private static void writePoolMemoryUsage(PrintStream out, MemoryUsage usage, MemoryUsage peakUsage, String prefix, boolean pretty) {
        if (pretty) {
            out.format("\t\tavailable         : %s\n", JvmMetrics.formatBytes(usage.getMax()));
            out.format("\t\tpeak              : %s\n", JvmMetrics.formatBytes(peakUsage.getUsed()));
            out.format("\t\tcurrent           : %s\n", JvmMetrics.formatBytes(usage.getUsed()));
        } else {
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-available-bytes : %d", prefix, usage.getMax())));
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-peak-bytes : %d", prefix, peakUsage.getUsed())));
            out.println(JvmMetrics.normalizeTabularColonPos(String.format("%s-current-bytes : %d", prefix, usage.getUsed())));
        }
    }

    private static void writeMemoryMetrics(PrintStream out, boolean verbose, boolean pretty) {
        if (pretty) {
            out.println("\nMemory usage");
        }
        if (verbose) {
            MemoryMXBean overallMemBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage usage = overallMemBean.getHeapMemoryUsage();
            JvmMetrics.writeOverallMemoryUsage(out, usage, "Heap", pretty);
            usage = overallMemBean.getNonHeapMemoryUsage();
            JvmMetrics.writeOverallMemoryUsage(out, usage, "Non-heap", pretty);
        }
        if (verbose) {
            List<MemoryPoolMXBean> mpBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean mpBean : mpBeans) {
                MemoryUsage currentUsage = mpBean.getUsage();
                MemoryUsage peakUsage = mpBean.getPeakUsage();
                if (pretty) {
                    out.println("\tPool " + mpBean.getName());
                    JvmMetrics.writePoolMemoryUsage(out, currentUsage, peakUsage, null, true);
                    continue;
                }
                JvmMetrics.writePoolMemoryUsage(out, currentUsage, peakUsage, "mem-pool-" + JvmMetrics.normalizeName(mpBean.getName()), false);
            }
        } else {
            long available = 0L;
            long current = 0L;
            long peak = 0L;
            List<MemoryPoolMXBean> mpBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean mpBean : mpBeans) {
                MemoryUsage currentUsage = mpBean.getUsage();
                available += currentUsage.getMax();
                current += currentUsage.getUsed();
                MemoryUsage peakUsage = mpBean.getPeakUsage();
                peak += peakUsage.getUsed();
            }
            MemoryUsage summaryUsage = new MemoryUsage(0L, current, current, available);
            MemoryUsage summaryPeakUsage = new MemoryUsage(0L, peak, peak, peak);
            if (pretty) {
                out.format("\tAggregate of %d memory pools\n", mpBeans.size());
                JvmMetrics.writePoolMemoryUsage(out, summaryUsage, summaryPeakUsage, null, true);
            } else {
                JvmMetrics.writePoolMemoryUsage(out, summaryUsage, summaryPeakUsage, "mem", false);
            }
        }
    }

    private static void writeGarbageCollectionStats(PrintStream out, boolean verbose, boolean pretty) {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        if (verbose) {
            if (pretty) {
                out.println("\nGarbage collection stats");
                for (GarbageCollectorMXBean gcBean : gcBeans) {
                    out.println("\tCollector " + gcBean.getName());
                    out.format("\t\tcollection count   : %d\n", gcBean.getCollectionCount());
                    out.format("\t\tcollection time    : %d ms\n", gcBean.getCollectionTime());
                }
            } else {
                for (GarbageCollectorMXBean gcBean : gcBeans) {
                    String name = JvmMetrics.normalizeName(gcBean.getName());
                    out.println(JvmMetrics.normalizeTabularColonPos(String.format("gc-" + name + "-collection-count : %d", gcBean.getCollectionCount())));
                    out.println(JvmMetrics.normalizeTabularColonPos(String.format("gc-" + name + "-collection-time-ms : %d", gcBean.getCollectionTime())));
                }
            }
        } else {
            long collectionCount = 0L;
            long collectionTime = 0L;
            int collectorCount = gcBeans.size();
            for (GarbageCollectorMXBean gcBean : gcBeans) {
                collectionCount += gcBean.getCollectionCount();
                collectionTime += gcBean.getCollectionTime();
            }
            if (pretty) {
                out.println("\nGarbage collection stats");
                out.format("\tAggregate of %d collectors\n", collectorCount);
                out.format("\t\tcollection count   : %d\n", collectionCount);
                out.format("\t\tcollection time    : %d ms\n", collectionTime);
            } else {
                String name = JvmMetrics.normalizeName("aggregate");
                out.println(JvmMetrics.normalizeTabularColonPos(String.format("gc-%s-collection-count : %d", name, collectionCount)));
                out.println(JvmMetrics.normalizeTabularColonPos(String.format("gc-%s-collection-time-ms : %d", name, collectionTime)));
            }
        }
    }

    private static String normalizeName(String name) {
        return name.replace(" ", "_").toLowerCase();
    }

    private static String normalizeTabularColonPos(String string) {
        StringBuilder sb = new StringBuilder(string);
        for (int index = sb.indexOf(":"); index < 40; ++index) {
            sb.insert(index, ' ');
        }
        return sb.toString();
    }

    private static String formatBytes(long numBytes) {
        if (numBytes < 1024L) {
            return String.format("%d B", numBytes);
        }
        if (numBytes < 0x100000L) {
            return String.format("%d KB", numBytes / 1024L);
        }
        if (numBytes < 0x40000000L) {
            return String.format("%d MB", numBytes / 0x100000L);
        }
        return String.format("%d GB", numBytes / 0x40000000L);
    }
}

