/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=it

/**
 * Localized names for the "it" locale.
 */
public class LocalizedNamesImpl_it extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IT",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "BQ",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "RU",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GS",
        "DE",
        "GH",
        "JM",
        "JP",
        "GI",
        "DJ",
        "JO",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GF",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "BV",
        "AC",
        "CX",
        "CP",
        "IM",
        "NF",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "HM",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "IL",
        "IT",
        "JE",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "HK",
        "MO",
        "GB",
        "CZ",
        "CF",
        "MK",
        "DO",
        "RE",
        "RO",
        "RW",
        "EH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "AS",
        "BL",
        "SM",
        "SH",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "US",
        "ZA",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SE",
        "CH",
        "SZ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "IO",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UG",
        "HU",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mondo");
    namesMap.put("003", "Nord America");
    namesMap.put("005", "America del Sud");
    namesMap.put("011", "Africa occidentale");
    namesMap.put("013", "America centrale");
    namesMap.put("014", "Africa orientale");
    namesMap.put("015", "Africa del Nord");
    namesMap.put("017", "Africa centrale");
    namesMap.put("018", "Africa del Sud");
    namesMap.put("019", "Americhe");
    namesMap.put("021", "America del Nord");
    namesMap.put("029", "Caraibi");
    namesMap.put("030", "Asia orientale");
    namesMap.put("034", "Asia del Sud");
    namesMap.put("035", "Asia sudorientale");
    namesMap.put("039", "Europa del Sud");
    namesMap.put("057", "Regione Micronesiana");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia centrale");
    namesMap.put("145", "Asia occidentale");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa orientale");
    namesMap.put("154", "Europa del Nord");
    namesMap.put("155", "Europa occidentale");
    namesMap.put("419", "America Latina");
    namesMap.put("AC", "Isola di Ascensione");
    namesMap.put("AE", "Emirati Arabi Uniti");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AN", "Antille Olandesi");
    namesMap.put("AQ", "Antartide");
    namesMap.put("AS", "Samoa Americane");
    namesMap.put("AX", "Isole Aland");
    namesMap.put("AZ", "Azerbaigian");
    namesMap.put("BA", "Bosnia Erzegovina");
    namesMap.put("BE", "Belgio");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "San Bartolomeo");
    namesMap.put("BQ", "Caraibi Olandesi");
    namesMap.put("BR", "Brasile");
    namesMap.put("BV", "Isola Bouvet");
    namesMap.put("BY", "Bielorussia");
    namesMap.put("CC", "Isole Cocos");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CF", "Repubblica Centrafricana");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Svizzera");
    namesMap.put("CI", "Costa d’Avorio");
    namesMap.put("CK", "Isole Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Camerun");
    namesMap.put("CN", "Cina");
    namesMap.put("CP", "Isola di Clipperton");
    namesMap.put("CV", "Capo Verde");
    namesMap.put("CX", "Isola di Christmas");
    namesMap.put("CY", "Cipro");
    namesMap.put("CZ", "Repubblica Ceca");
    namesMap.put("DE", "Germania");
    namesMap.put("DJ", "Gibuti");
    namesMap.put("DK", "Danimarca");
    namesMap.put("DO", "Repubblica Dominicana");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EG", "Egitto");
    namesMap.put("EH", "Sahara Occidentale");
    namesMap.put("ES", "Spagna");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Unione Europea");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Figi");
    namesMap.put("FK", "Isole Falkland");
    namesMap.put("FO", "Isole Faroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GB", "Regno Unito");
    namesMap.put("GF", "Guiana Francese");
    namesMap.put("GI", "Gibilterra");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GP", "Guadalupa");
    namesMap.put("GQ", "Guinea Equatoriale");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Georgia del Sud e Isole Sandwich del Sud");
    namesMap.put("HK", "RAS di Hong Kong");
    namesMap.put("HM", "Isole Heard ed Isole McDonald");
    namesMap.put("HR", "Croazia");
    namesMap.put("HU", "Ungheria");
    namesMap.put("IC", "Isole Canarie");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IL", "Israele");
    namesMap.put("IM", "Isola di Man");
    namesMap.put("IO", "Territorio Britannico dell’Oceano Indiano");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Giamaica");
    namesMap.put("JO", "Giordania");
    namesMap.put("JP", "Giappone");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Cambogia");
    namesMap.put("KM", "Comore");
    namesMap.put("KN", "Saint Kitts e Nevis");
    namesMap.put("KP", "Corea del Nord");
    namesMap.put("KR", "Corea del Sud");
    namesMap.put("KY", "Isole Cayman");
    namesMap.put("KZ", "Kazakistan");
    namesMap.put("LB", "Libano");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Lussemburgo");
    namesMap.put("LV", "Lettonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marocco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MH", "Isole Marshall");
    namesMap.put("MK", "Repubblica di Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "RAS di Macao");
    namesMap.put("MP", "Isole Marianne Settentrionali");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MV", "Maldive");
    namesMap.put("MX", "Messico");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Mozambico");
    namesMap.put("NC", "Nuova Caledonia");
    namesMap.put("NF", "Isola Norfolk");
    namesMap.put("NL", "Paesi Bassi");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Nuova Zelanda");
    namesMap.put("PE", "Perù");
    namesMap.put("PF", "Polinesia Francese");
    namesMap.put("PG", "Papua Nuova Guinea");
    namesMap.put("PH", "Filippine");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint Pierre e Miquelon");
    namesMap.put("PN", "Isole Pitcairn");
    namesMap.put("PR", "Portorico");
    namesMap.put("PS", "Territori palestinesi");
    namesMap.put("PT", "Portogallo");
    namesMap.put("QO", "Oceania lontana");
    namesMap.put("RU", "Federazione Russa");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Isole Solomon");
    namesMap.put("SE", "Svezia");
    namesMap.put("SH", "Sant’Elena");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Slovacchia");
    namesMap.put("SS", "Sudan del Sud");
    namesMap.put("ST", "Sao Tomé e Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("TC", "Isole Turks e Caicos");
    namesMap.put("TD", "Ciad");
    namesMap.put("TF", "Territori australi francesi");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Tagikistan");
    namesMap.put("TL", "Timor Est");
    namesMap.put("TR", "Turchia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("UA", "Ucraina");
    namesMap.put("UM", "Isole minori lontane dagli USA");
    namesMap.put("US", "Stati Uniti");
    namesMap.put("VA", "Città del Vaticano");
    namesMap.put("VC", "Saint Vincent e Grenadines");
    namesMap.put("VG", "Isole Vergini Britanniche");
    namesMap.put("VI", "Isole Vergini Americane");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("ZA", "Sudafrica");
    namesMap.put("ZZ", "Regione non valida o sconosciuta");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mondo",
        "003": "Nord America",
        "005": "America del Sud",
        "011": "Africa occidentale",
        "013": "America centrale",
        "014": "Africa orientale",
        "015": "Africa del Nord",
        "017": "Africa centrale",
        "018": "Africa del Sud",
        "019": "Americhe",
        "021": "America del Nord",
        "029": "Caraibi",
        "030": "Asia orientale",
        "034": "Asia del Sud",
        "035": "Asia sudorientale",
        "039": "Europa del Sud",
        "057": "Regione Micronesiana",
        "061": "Polinesia",
        "143": "Asia centrale",
        "145": "Asia occidentale",
        "150": "Europa",
        "151": "Europa orientale",
        "154": "Europa del Nord",
        "155": "Europa occidentale",
        "419": "America Latina",
        "AC": "Isola di Ascensione",
        "AE": "Emirati Arabi Uniti",
        "AG": "Antigua e Barbuda",
        "AN": "Antille Olandesi",
        "AQ": "Antartide",
        "AS": "Samoa Americane",
        "AX": "Isole Aland",
        "AZ": "Azerbaigian",
        "BA": "Bosnia Erzegovina",
        "BE": "Belgio",
        "BH": "Bahrein",
        "BL": "San Bartolomeo",
        "BQ": "Caraibi Olandesi",
        "BR": "Brasile",
        "BV": "Isola Bouvet",
        "BY": "Bielorussia",
        "CC": "Isole Cocos",
        "CD": "Congo - Kinshasa",
        "CF": "Repubblica Centrafricana",
        "CG": "Congo",
        "CH": "Svizzera",
        "CI": "Costa d’Avorio",
        "CK": "Isole Cook",
        "CL": "Cile",
        "CM": "Camerun",
        "CN": "Cina",
        "CP": "Isola di Clipperton",
        "CV": "Capo Verde",
        "CX": "Isola di Christmas",
        "CY": "Cipro",
        "CZ": "Repubblica Ceca",
        "DE": "Germania",
        "DJ": "Gibuti",
        "DK": "Danimarca",
        "DO": "Repubblica Dominicana",
        "EA": "Ceuta e Melilla",
        "EG": "Egitto",
        "EH": "Sahara Occidentale",
        "ES": "Spagna",
        "ET": "Etiopia",
        "EU": "Unione Europea",
        "FI": "Finlandia",
        "FJ": "Figi",
        "FK": "Isole Falkland",
        "FO": "Isole Faroe",
        "FR": "Francia",
        "GB": "Regno Unito",
        "GF": "Guiana Francese",
        "GI": "Gibilterra",
        "GL": "Groenlandia",
        "GP": "Guadalupa",
        "GQ": "Guinea Equatoriale",
        "GR": "Grecia",
        "GS": "Georgia del Sud e Isole Sandwich del Sud",
        "HK": "RAS di Hong Kong",
        "HM": "Isole Heard ed Isole McDonald",
        "HR": "Croazia",
        "HU": "Ungheria",
        "IC": "Isole Canarie",
        "IE": "Irlanda",
        "IL": "Israele",
        "IM": "Isola di Man",
        "IO": "Territorio Britannico dell’Oceano Indiano",
        "IS": "Islanda",
        "IT": "Italia",
        "JM": "Giamaica",
        "JO": "Giordania",
        "JP": "Giappone",
        "KG": "Kirghizistan",
        "KH": "Cambogia",
        "KM": "Comore",
        "KN": "Saint Kitts e Nevis",
        "KP": "Corea del Nord",
        "KR": "Corea del Sud",
        "KY": "Isole Cayman",
        "KZ": "Kazakistan",
        "LB": "Libano",
        "LT": "Lituania",
        "LU": "Lussemburgo",
        "LV": "Lettonia",
        "LY": "Libia",
        "MA": "Marocco",
        "MD": "Moldavia",
        "MH": "Isole Marshall",
        "MK": "Repubblica di Macedonia",
        "MM": "Myanmar",
        "MO": "RAS di Macao",
        "MP": "Isole Marianne Settentrionali",
        "MQ": "Martinica",
        "MV": "Maldive",
        "MX": "Messico",
        "MY": "Malesia",
        "MZ": "Mozambico",
        "NC": "Nuova Caledonia",
        "NF": "Isola Norfolk",
        "NL": "Paesi Bassi",
        "NO": "Norvegia",
        "NZ": "Nuova Zelanda",
        "PE": "Perù",
        "PF": "Polinesia Francese",
        "PG": "Papua Nuova Guinea",
        "PH": "Filippine",
        "PL": "Polonia",
        "PM": "Saint Pierre e Miquelon",
        "PN": "Isole Pitcairn",
        "PR": "Portorico",
        "PS": "Territori palestinesi",
        "PT": "Portogallo",
        "QO": "Oceania lontana",
        "RU": "Federazione Russa",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Isole Solomon",
        "SE": "Svezia",
        "SH": "Sant’Elena",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Slovacchia",
        "SS": "Sudan del Sud",
        "ST": "Sao Tomé e Príncipe",
        "SY": "Siria",
        "TC": "Isole Turks e Caicos",
        "TD": "Ciad",
        "TF": "Territori australi francesi",
        "TH": "Tailandia",
        "TJ": "Tagikistan",
        "TL": "Timor Est",
        "TR": "Turchia",
        "TT": "Trinidad e Tobago",
        "UA": "Ucraina",
        "UM": "Isole minori lontane dagli USA",
        "US": "Stati Uniti",
        "VA": "Città del Vaticano",
        "VC": "Saint Vincent e Grenadines",
        "VG": "Isole Vergini Britanniche",
        "VI": "Isole Vergini Americane",
        "WF": "Wallis e Futuna",
        "ZA": "Sudafrica",
        "ZZ": "Regione non valida o sconosciuta"
    };
  }-*/;
}
