/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.shared;

import com.google.gwt.typedarrays.shared.DataView;

public class DataViewStream {
    private final DataView dataView;
    private int offset;

    public DataViewStream(DataView dataView) {
        this.dataView = dataView;
        this.offset = 0;
    }

    public float getFloat32() {
        return this.getFloat32(false);
    }

    public float getFloat32(boolean littleEndian) {
        float val = this.dataView.getFloat32(this.offset, littleEndian);
        this.offset += 4;
        return val;
    }

    public double getFloat64() {
        return this.getFloat64(false);
    }

    public double getFloat64(boolean littleEndian) {
        double val = this.dataView.getFloat64(this.offset, littleEndian);
        this.offset += 8;
        return val;
    }

    public short getInt16() {
        return this.getInt16(false);
    }

    public short getInt16(boolean littleEndian) {
        short val = this.dataView.getInt16(this.offset, littleEndian);
        this.offset += 2;
        return val;
    }

    public int getInt32() {
        return this.getInt32(false);
    }

    public int getInt32(boolean littleEndian) {
        int val = this.dataView.getInt32(this.offset, littleEndian);
        this.offset += 4;
        return val;
    }

    public byte getInt8() {
        return this.dataView.getInt8(this.offset++);
    }

    public int getUint16() {
        return this.getUint16(false);
    }

    public int getUint16(boolean littleEndian) {
        int val = this.dataView.getUint16(this.offset, littleEndian);
        this.offset += 2;
        return val;
    }

    public long getUint32() {
        return this.getUint32(false);
    }

    public long getUint32(boolean littleEndian) {
        long val = this.dataView.getUint32(this.offset, littleEndian);
        this.offset += 4;
        return val;
    }

    public double getUint32AsDouble() {
        return this.getUint32AsDouble(false);
    }

    public double getUint32AsDouble(boolean littleEndian) {
        double val = this.dataView.getUint32AsDouble(this.offset, littleEndian);
        this.offset += 4;
        return val;
    }

    public short getUint8() {
        return this.dataView.getUint8(this.offset++);
    }

    public int position() {
        return this.offset;
    }

    public void putFloat32(float value) {
        this.putFloat32(value, false);
    }

    public void putFloat32(float value, boolean littleEndian) {
        this.dataView.setFloat32(this.offset, value, littleEndian);
        this.offset += 4;
    }

    public void putFloat64(double value) {
        this.putFloat64(value, false);
    }

    public void putFloat64(double value, boolean littleEndian) {
        this.dataView.setFloat64(this.offset, value, littleEndian);
        this.offset += 8;
    }

    public void putInt16(int value) {
        this.putInt16(value, false);
    }

    public void putInt16(int value, boolean littleEndian) {
        this.dataView.setInt16(this.offset, value, littleEndian);
        this.offset += 2;
    }

    public void putInt32(int value) {
        this.putInt32(value, false);
    }

    public void putInt32(int value, boolean littleEndian) {
        this.dataView.setInt32(this.offset, value, littleEndian);
        this.offset += 4;
    }

    public void putInt8(int value) {
        this.dataView.setInt8(this.offset++, value);
    }

    public void putUint16(int value) {
        this.putUint16(value, false);
    }

    public void putUint16(int value, boolean littleEndian) {
        this.dataView.setUint16(this.offset, value, littleEndian);
        this.offset += 2;
    }

    public void putUint32(long value) {
        this.putUint32(value, false);
    }

    public void putUint32(long value, boolean littleEndian) {
        this.dataView.setUint32(this.offset, value, littleEndian);
        this.offset += 4;
    }

    public void putUint32FromDouble(double value) {
        this.putUint32FromDouble(value, false);
    }

    public void putUint32FromDouble(double value, boolean littleEndian) {
        this.dataView.setUint32FromDouble(this.offset, value, littleEndian);
        this.offset += 4;
    }

    public void putUint8(int value) {
        this.dataView.setUint8(this.offset++, value);
    }

    public void rewind() {
        this.offset = 0;
    }

    public void setPosition(int position) {
        if (position < 0 || position >= this.dataView.byteLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = position;
    }
}

