/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.media.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AudioElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.media.client.MediaBase;

@PartialSupport
public class Audio
extends MediaBase {
    private static AudioElementSupportDetector detector;

    public static Audio createIfSupported() {
        if (detector == null) {
            detector = (AudioElementSupportDetector)GWT.create(AudioElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return null;
        }
        AudioElement element = Document.get().createAudioElement();
        if (!AudioElementSupportDetector.isSupportedRunTime(element)) {
            return null;
        }
        return new Audio(element);
    }

    public static boolean isSupported() {
        if (detector == null) {
            detector = (AudioElementSupportDetector)GWT.create(AudioElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return false;
        }
        AudioElement element = Document.get().createAudioElement();
        return AudioElementSupportDetector.isSupportedRunTime(element);
    }

    protected Audio(AudioElement element) {
        super(element);
    }

    public AudioElement getAudioElement() {
        return (AudioElement)this.getMediaElement().cast();
    }

    private static class AudioElementSupportDetector {
        private AudioElementSupportDetector() {
        }

        static native boolean isSupportedRunTime(AudioElement var0);

        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class AudioElementSupportDetectedNo
    extends AudioElementSupportDetector {
        private AudioElementSupportDetectedNo() {
        }

        @Override
        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class AudioElementSupportDetectedMaybe
    extends AudioElementSupportDetector {
        private AudioElementSupportDetectedMaybe() {
        }

        @Override
        boolean isSupportedCompileTime() {
            return true;
        }
    }
}

