/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ti" locale.
 */
public class LocalizedNamesImpl_ti extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "EU",
        "EZ",
        "UN",
        "XA",
        "XB",
        "HU",
        "HT",
        "IN",
        "HN",
        "HK",
        "LU",
        "LY",
        "LB",
        "LT",
        "LI",
        "LV",
        "LA",
        "LR",
        "LS",
        "AE",
        "FM",
        "ML",
        "MW",
        "MY",
        "MT",
        "MV",
        "MU",
        "MH",
        "MQ",
        "CF",
        "MK",
        "MO",
        "MM",
        "MG",
        "MX",
        "YT",
        "PS",
        "TL",
        "EH",
        "MD",
        "MR",
        "MA",
        "MC",
        "ME",
        "MS",
        "MN",
        "MZ",
        "RW",
        "RE",
        "RU",
        "RO",
        "SB",
        "KP",
        "RS",
        "SO",
        "SR",
        "SZ",
        "SD",
        "LK",
        "SY",
        "SC",
        "SX",
        "SG",
        "EA",
        "WS",
        "SM",
        "ST",
        "CY",
        "SL",
        "SN",
        "SH",
        "LC",
        "MF",
        "SK",
        "SI",
        "SJ",
        "CH",
        "SE",
        "SA",
        "ES",
        "QA",
        "BL",
        "VC",
        "KN",
        "PM",
        "BT",
        "BG",
        "BF",
        "GW",
        "BS",
        "BH",
        "BB",
        "BD",
        "BZ",
        "BY",
        "BE",
        "BM",
        "BJ",
        "BN",
        "BI",
        "BR",
        "BO",
        "BW",
        "BA",
        "VI",
        "VG",
        "VA",
        "VU",
        "VN",
        "VE",
        "TR",
        "TM",
        "TV",
        "TN",
        "TZ",
        "TH",
        "TW",
        "TJ",
        "TA",
        "TT",
        "TO",
        "TK",
        "TG",
        "CL",
        "CN",
        "CZ",
        "NU",
        "NI",
        "NC",
        "NZ",
        "NE",
        "NA",
        "NR",
        "IO",
        "AS",
        "UM",
        "NG",
        "TF",
        "GF",
        "PF",
        "NL",
        "NP",
        "NO",
        "NF",
        "AL",
        "DZ",
        "US",
        "AW",
        "AM",
        "AR",
        "AC",
        "AQ",
        "AD",
        "AI",
        "AO",
        "AU",
        "AZ",
        "IE",
        "IM",
        "IS",
        "AF",
        "UY",
        "IQ",
        "IR",
        "ET",
        "ID",
        "GQ",
        "EC",
        "AG",
        "SV",
        "ER",
        "EE",
        "IL",
        "GB",
        "OM",
        "AT",
        "CW",
        "CU",
        "KI",
        "KG",
        "CM",
        "KH",
        "BQ",
        "CA",
        "KZ",
        "KY",
        "KE",
        "CV",
        "CP",
        "HR",
        "KW",
        "CO",
        "KM",
        "CR",
        "XK",
        "CI",
        "CD",
        "CG",
        "CC",
        "QO",
        "WF",
        "ZW",
        "ZM",
        "YE",
        "UA",
        "UZ",
        "UG",
        "HM",
        "MP",
        "BV",
        "TC",
        "AX",
        "CK",
        "IC",
        "CX",
        "GS",
        "FO",
        "FK",
        "SS",
        "ZA",
        "KR",
        "DG",
        "DK",
        "DO",
        "DM",
        "DE",
        "JE",
        "DJ",
        "JM",
        "JP",
        "JO",
        "GE",
        "GG",
        "GU",
        "GT",
        "GP",
        "GY",
        "GI",
        "GN",
        "GM",
        "GA",
        "GH",
        "GL",
        "GR",
        "GD",
        "EG",
        "IT",
        "TD",
        "FR",
        "PH",
        "FI",
        "FJ",
        "PN",
        "PW",
        "PY",
        "PA",
        "PK",
        "PG",
        "PE",
        "PL",
        "PT",
        "PR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ዓለም");
    namesMap.put("002", "አፍሪካ");
    namesMap.put("005", "ደቡባዊ አሜሪካ");
    namesMap.put("009", "ኦሽኒያ");
    namesMap.put("011", "ምዕራባዊ አፍሪካ");
    namesMap.put("014", "ምስራቃዊ አፍሪካ");
    namesMap.put("015", "ሰሜናዊ አፍሪካ");
    namesMap.put("017", "መካከለኛ አፍሪካ");
    namesMap.put("018", "ደቡባዊ አፍሪካ");
    namesMap.put("019", "አሜሪካዎች");
    namesMap.put("021", "ሰሜናዊ አሜሪካ");
    namesMap.put("029", "ካሪቢያን");
    namesMap.put("034", "ምሥራቃዊ እስያ");
    namesMap.put("039", "ደቡባዊ አውሮፓ");
    namesMap.put("053", "አውስትራሊያ እና ኒው ዚላንድ");
    namesMap.put("054", "ሜላኔሲያ");
    namesMap.put("061", "ፖሊኔዢያ");
    namesMap.put("142", "እስያ");
    namesMap.put("145", "ምዕራባዊ እስያ");
    namesMap.put("150", "አውሮፓ");
    namesMap.put("151", "ምስራቃዊ አውሮፓ");
    namesMap.put("154", "ሰሜናዊ አውሮፓ");
    namesMap.put("155", "ምዕራባዊ አውሮፓ");
    namesMap.put("AC", "አሴንሽን ደሴት");
    namesMap.put("AD", "አንዶራ");
    namesMap.put("AE", "ሕቡራት ኢማራት ዓረብ");
    namesMap.put("AF", "አፍጋኒስታን");
    namesMap.put("AG", "ኣንቲጓን ባሩዳን");
    namesMap.put("AI", "አንጉኢላ");
    namesMap.put("AL", "አልባኒያ");
    namesMap.put("AM", "አርሜኒያ");
    namesMap.put("AO", "አንጐላ");
    namesMap.put("AQ", "አንታርክቲካ");
    namesMap.put("AR", "አርጀንቲና");
    namesMap.put("AS", "ናይ ኣሜሪካ ሳሞኣ");
    namesMap.put("AT", "ኦስትሪያ");
    namesMap.put("AU", "አውስትሬሊያ");
    namesMap.put("AW", "አሩባ");
    namesMap.put("AX", "ደሴታት ኣላንድ");
    namesMap.put("AZ", "አዘርባጃን");
    namesMap.put("BA", "ቦዝንያን ሄርዘጎቪናን");
    namesMap.put("BB", "ባርቤዶስ");
    namesMap.put("BD", "ባንግላዲሽ");
    namesMap.put("BE", "ቤልጄም");
    namesMap.put("BF", "ቡርኪና ፋሶ");
    namesMap.put("BG", "ቡልጌሪያ");
    namesMap.put("BH", "ባህሬን");
    namesMap.put("BI", "ብሩንዲ");
    namesMap.put("BJ", "ቤኒን");
    namesMap.put("BL", "ቅዱስ ባርተለሚይ");
    namesMap.put("BM", "ቤርሙዳ");
    namesMap.put("BN", "ብሩኒ");
    namesMap.put("BO", "ቦሊቪያ");
    namesMap.put("BQ", "ካሪቢያን ኔዘርላንድስ");
    namesMap.put("BR", "ብራዚል");
    namesMap.put("BS", "ባሃማስ");
    namesMap.put("BT", "ቡህታን");
    namesMap.put("BV", "ደሴታት ቦውቬት");
    namesMap.put("BW", "ቦትስዋና");
    namesMap.put("BY", "ቤላሩስ");
    namesMap.put("BZ", "ቤሊዘ");
    namesMap.put("CA", "ካናዳ");
    namesMap.put("CC", "ኮኮስ ኬሊንግ ደሴቶች");
    namesMap.put("CD", "ኮንጎ");
    namesMap.put("CF", "ማእከላይ ኣፍሪቃ ሪፓብሊክ");
    namesMap.put("CG", "ኮንጎ ሪፓብሊክ");
    namesMap.put("CH", "ስዊዘርላንድ");
    namesMap.put("CI", "ኮት ዲቯር");
    namesMap.put("CK", "ደሴታት ኩክ");
    namesMap.put("CL", "ቺሊ");
    namesMap.put("CM", "ካሜሩን");
    namesMap.put("CN", "ቻይና");
    namesMap.put("CO", "ኮሎምቢያ");
    namesMap.put("CP", "ክሊፐርቶን ደሴት");
    namesMap.put("CR", "ኮስታ ሪካ");
    namesMap.put("CU", "ኩባ");
    namesMap.put("CV", "ኬፕ ቬርዴ");
    namesMap.put("CW", "ኩራካዎ");
    namesMap.put("CX", "ደሴታት ክሪስትማስ");
    namesMap.put("CY", "ሳይፕረስ");
    namesMap.put("CZ", "ቼክ ሪፓብሊክ");
    namesMap.put("DE", "ጀርመን");
    namesMap.put("DG", "ዲየጎ ጋርሺያ");
    namesMap.put("DJ", "ጂቡቲ");
    namesMap.put("DK", "ዴንማርክ");
    namesMap.put("DM", "ዶሚኒካ");
    namesMap.put("DO", "ዶመኒካ ሪፓብሊክ");
    namesMap.put("DZ", "አልጄሪያ");
    namesMap.put("EA", "ሲውታን ሜሊላን");
    namesMap.put("EC", "ኢኳዶር");
    namesMap.put("EE", "ኤስቶኒያ");
    namesMap.put("EG", "ግብጽ");
    namesMap.put("EH", "ምዕራባዊ ሳህራ");
    namesMap.put("ER", "ኤርትራ");
    namesMap.put("ES", "ስፔን");
    namesMap.put("ET", "ኢትዮጵያ");
    namesMap.put("FI", "ፊንላንድ");
    namesMap.put("FJ", "ፊጂ");
    namesMap.put("FK", "ደሴታት ፎክላንድ");
    namesMap.put("FM", "ሚክሮኔዢያ");
    namesMap.put("FO", "ደሴታት ፋራኦ");
    namesMap.put("FR", "ፈረንሳይ");
    namesMap.put("GA", "ጋቦን");
    namesMap.put("GB", "እንግሊዝ");
    namesMap.put("GD", "ግሬናዳ");
    namesMap.put("GE", "ጆርጂያ");
    namesMap.put("GF", "ናይ ፈረንሳይ ጉይና");
    namesMap.put("GG", "ገርንሲ");
    namesMap.put("GH", "ጋና");
    namesMap.put("GI", "ጊብራልታር");
    namesMap.put("GL", "ግሪንላንድ");
    namesMap.put("GM", "ጋምቢያ");
    namesMap.put("GN", "ጊኒ");
    namesMap.put("GP", "ጉዋደሉፕ");
    namesMap.put("GQ", "ኢኳቶሪያል ጊኒ");
    namesMap.put("GR", "ግሪክ");
    namesMap.put("GS", "ደሴታት ደቡብ ጆርጂያን ደቡድ ሳንድዊችን");
    namesMap.put("GT", "ጉዋቲማላ");
    namesMap.put("GU", "ጉዋም");
    namesMap.put("GW", "ቢሳዎ");
    namesMap.put("GY", "ጉያና");
    namesMap.put("HK", "ሆንግ ኮንግ");
    namesMap.put("HM", "ደሴታት ሀርድን ማክዶናልድን");
    namesMap.put("HN", "ሆንዱራስ");
    namesMap.put("HR", "ክሮኤሽያ");
    namesMap.put("HT", "ሀይቲ");
    namesMap.put("HU", "ሀንጋሪ");
    namesMap.put("IC", "ደሴታት ካናሪ");
    namesMap.put("ID", "ኢንዶኔዢያ");
    namesMap.put("IE", "አየርላንድ");
    namesMap.put("IL", "እስራኤል");
    namesMap.put("IM", "አይል ኦፍ ማን");
    namesMap.put("IN", "ህንዲ");
    namesMap.put("IO", "ናይ ብሪጣንያ ህንዳዊ ውቅያኖስ ግዝኣት");
    namesMap.put("IQ", "ኢራቅ");
    namesMap.put("IR", "ኢራን");
    namesMap.put("IS", "አይስላንድ");
    namesMap.put("IT", "ጣሊያን");
    namesMap.put("JE", "ጀርሲ");
    namesMap.put("JM", "ጃማይካ");
    namesMap.put("JO", "ጆርዳን");
    namesMap.put("JP", "ጃፓን");
    namesMap.put("KE", "ኬንያ");
    namesMap.put("KG", "ኪርጂስታን");
    namesMap.put("KH", "ካምቦዲያ");
    namesMap.put("KI", "ኪሪባቲ");
    namesMap.put("KM", "ኮሞሮስ");
    namesMap.put("KN", "ቅዱስ ኪትስን ኔቪስን");
    namesMap.put("KP", "ሰሜን ኮሪያ");
    namesMap.put("KR", "ደቡብ ኮሪያ");
    namesMap.put("KW", "ክዌት");
    namesMap.put("KY", "ካይማን ደሴቶች");
    namesMap.put("KZ", "ካዛኪስታን");
    namesMap.put("LA", "ላኦስ");
    namesMap.put("LB", "ሊባኖስ");
    namesMap.put("LC", "ሴንት ሉቺያ");
    namesMap.put("LI", "ሊችተንስታይን");
    namesMap.put("LK", "ሲሪላንካ");
    namesMap.put("LR", "ላይቤሪያ");
    namesMap.put("LS", "ሌሶቶ");
    namesMap.put("LT", "ሊቱዌኒያ");
    namesMap.put("LU", "ሉክሰምበርግ");
    namesMap.put("LV", "ላትቪያ");
    namesMap.put("LY", "ሊቢያ");
    namesMap.put("MA", "ሞሮኮ");
    namesMap.put("MC", "ሞናኮ");
    namesMap.put("MD", "ሞልዶቫ");
    namesMap.put("ME", "ሞንቴኔግሮ");
    namesMap.put("MF", "ሴንት ማርቲን");
    namesMap.put("MG", "ማዳጋስካር");
    namesMap.put("MH", "ማርሻል አይላንድ");
    namesMap.put("MK", "ማከዶኒያ");
    namesMap.put("ML", "ማሊ");
    namesMap.put("MM", "ማያንማር");
    namesMap.put("MN", "ሞንጎሊያ");
    namesMap.put("MO", "ማካዎ");
    namesMap.put("MP", "ደሴታት ሰሜናዊ ማሪያና");
    namesMap.put("MQ", "ማርቲኒክ");
    namesMap.put("MR", "ሞሪቴኒያ");
    namesMap.put("MS", "ሞንትሴራት");
    namesMap.put("MT", "ማልታ");
    namesMap.put("MU", "ማሩሸስ");
    namesMap.put("MV", "ማልዲቭስ");
    namesMap.put("MW", "ማላዊ");
    namesMap.put("MX", "ሜክሲኮ");
    namesMap.put("MY", "ማሌዢያ");
    namesMap.put("MZ", "ሞዛምቢክ");
    namesMap.put("NA", "ናሚቢያ");
    namesMap.put("NC", "ኒው ካሌዶኒያ");
    namesMap.put("NE", "ኒጀር");
    namesMap.put("NF", "ኖርፎልክ ደሴት");
    namesMap.put("NG", "ናይጄሪያ");
    namesMap.put("NI", "ኒካራጓ");
    namesMap.put("NL", "ኔዘርላንድስ");
    namesMap.put("NO", "ኖርዌ");
    namesMap.put("NP", "ኔፓል");
    namesMap.put("NR", "ናኡሩ");
    namesMap.put("NU", "ኒኡይ");
    namesMap.put("NZ", "ኒው ዚላንድ");
    namesMap.put("OM", "ኦማን");
    namesMap.put("PA", "ፓናማ");
    namesMap.put("PE", "ፔሩ");
    namesMap.put("PF", "ናይ ፈረንሳይ ፖሊነዝያ");
    namesMap.put("PG", "ፓፑዋ ኒው ጊኒ");
    namesMap.put("PH", "ፊሊፒንስ");
    namesMap.put("PK", "ፓኪስታን");
    namesMap.put("PL", "ፖላንድ");
    namesMap.put("PM", "ቅዱስ ፒዬርን ሚኩኤሎን");
    namesMap.put("PN", "ፒትካኢርን");
    namesMap.put("PR", "ፖርታ ሪኮ");
    namesMap.put("PS", "ምምሕዳር ፍልስጤም");
    namesMap.put("PT", "ፖርቱጋል");
    namesMap.put("PW", "ፓላው");
    namesMap.put("PY", "ፓራጓይ");
    namesMap.put("QA", "ቀጠር");
    namesMap.put("QO", "ወጣ ያለ ኦሽኒያ");
    namesMap.put("RE", "ሪዩኒየን");
    namesMap.put("RO", "ሮሜኒያ");
    namesMap.put("RS", "ሰርቢያ");
    namesMap.put("RU", "ራሺያ");
    namesMap.put("RW", "ሩዋንዳ");
    namesMap.put("SA", "ስዑዲ ዓረብ");
    namesMap.put("SB", "ሰሎሞን ደሴት");
    namesMap.put("SC", "ሲሼልስ");
    namesMap.put("SD", "ሱዳን");
    namesMap.put("SE", "ስዊድን");
    namesMap.put("SG", "ሲንጋፖር");
    namesMap.put("SH", "ሴንት ሄለና");
    namesMap.put("SI", "ስሎቬኒያ");
    namesMap.put("SJ", "ስቫልባርድን ዣን ማየን ደሴታት");
    namesMap.put("SK", "ስሎቫኪያ");
    namesMap.put("SL", "ሴራሊዮን");
    namesMap.put("SM", "ሳን ማሪኖ");
    namesMap.put("SN", "ሴኔጋል");
    namesMap.put("SO", "ሱማሌ");
    namesMap.put("SR", "ሱሪናም");
    namesMap.put("SS", "ደቡብ ሱዳን");
    namesMap.put("ST", "ሳኦ ቶሜን ፕሪንሲፔን");
    namesMap.put("SV", "ኤል ሳልቫዶር");
    namesMap.put("SX", "ሲንት ማርቲን");
    namesMap.put("SY", "ሲሪያ");
    namesMap.put("SZ", "ሱዋዚላንድ");
    namesMap.put("TA", "ትሪስን ዳ ኩንሃ");
    namesMap.put("TC", "ደሴታት ቱርክን ካይኮስን");
    namesMap.put("TD", "ጫድ");
    namesMap.put("TF", "ናይ ፈረንሳይ ደቡባዊ ግዝኣታት");
    namesMap.put("TG", "ቶጐ");
    namesMap.put("TH", "ታይላንድ");
    namesMap.put("TJ", "ታጃኪስታን");
    namesMap.put("TK", "ቶክላው");
    namesMap.put("TL", "ምብራቕ ቲሞር");
    namesMap.put("TM", "ቱርክሜኒስታን");
    namesMap.put("TN", "ቱኒዚያ");
    namesMap.put("TO", "ቶንጋ");
    namesMap.put("TR", "ቱርክ");
    namesMap.put("TT", "ትሪኒዳድን ቶባጎን");
    namesMap.put("TV", "ቱቫሉ");
    namesMap.put("TW", "ታይዋን");
    namesMap.put("TZ", "ታንዛኒያ");
    namesMap.put("UA", "ዩክሬን");
    namesMap.put("UG", "ዩጋንዳ");
    namesMap.put("UM", "ናይ ኣሜሪካ ፍንትት ዝበሉ ደሴታት");
    namesMap.put("US", "አሜሪካ");
    namesMap.put("UY", "ኡራጓይ");
    namesMap.put("UZ", "ዩዝበኪስታን");
    namesMap.put("VA", "ቫቲካን");
    namesMap.put("VC", "ቅዱስ ቪንሴንትን ግሬናዲንስን");
    namesMap.put("VE", "ቬንዙዌላ");
    namesMap.put("VG", "ቨርጂን ደሴታት እንግሊዝ");
    namesMap.put("VI", "ቨርጂን ደሴታት ኣሜሪካ");
    namesMap.put("VN", "ቬትናም");
    namesMap.put("VU", "ቫኑአቱ");
    namesMap.put("WF", "ዋሊስን ፉቱናን");
    namesMap.put("WS", "ሳሞአ");
    namesMap.put("XK", "ኮሶቮ");
    namesMap.put("YE", "የመን");
    namesMap.put("YT", "ሜይኦቴ");
    namesMap.put("ZA", "ደቡብ አፍሪካ");
    namesMap.put("ZM", "ዛምቢያ");
    namesMap.put("ZW", "ዚምቧቤ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ዓለም",
        "002": "አፍሪካ",
        "005": "ደቡባዊ አሜሪካ",
        "009": "ኦሽኒያ",
        "011": "ምዕራባዊ አፍሪካ",
        "014": "ምስራቃዊ አፍሪካ",
        "015": "ሰሜናዊ አፍሪካ",
        "017": "መካከለኛ አፍሪካ",
        "018": "ደቡባዊ አፍሪካ",
        "019": "አሜሪካዎች",
        "021": "ሰሜናዊ አሜሪካ",
        "029": "ካሪቢያን",
        "034": "ምሥራቃዊ እስያ",
        "039": "ደቡባዊ አውሮፓ",
        "053": "አውስትራሊያ እና ኒው ዚላንድ",
        "054": "ሜላኔሲያ",
        "061": "ፖሊኔዢያ",
        "142": "እስያ",
        "145": "ምዕራባዊ እስያ",
        "150": "አውሮፓ",
        "151": "ምስራቃዊ አውሮፓ",
        "154": "ሰሜናዊ አውሮፓ",
        "155": "ምዕራባዊ አውሮፓ",
        "AC": "አሴንሽን ደሴት",
        "AD": "አንዶራ",
        "AE": "ሕቡራት ኢማራት ዓረብ",
        "AF": "አፍጋኒስታን",
        "AG": "ኣንቲጓን ባሩዳን",
        "AI": "አንጉኢላ",
        "AL": "አልባኒያ",
        "AM": "አርሜኒያ",
        "AO": "አንጐላ",
        "AQ": "አንታርክቲካ",
        "AR": "አርጀንቲና",
        "AS": "ናይ ኣሜሪካ ሳሞኣ",
        "AT": "ኦስትሪያ",
        "AU": "አውስትሬሊያ",
        "AW": "አሩባ",
        "AX": "ደሴታት ኣላንድ",
        "AZ": "አዘርባጃን",
        "BA": "ቦዝንያን ሄርዘጎቪናን",
        "BB": "ባርቤዶስ",
        "BD": "ባንግላዲሽ",
        "BE": "ቤልጄም",
        "BF": "ቡርኪና ፋሶ",
        "BG": "ቡልጌሪያ",
        "BH": "ባህሬን",
        "BI": "ብሩንዲ",
        "BJ": "ቤኒን",
        "BL": "ቅዱስ ባርተለሚይ",
        "BM": "ቤርሙዳ",
        "BN": "ብሩኒ",
        "BO": "ቦሊቪያ",
        "BQ": "ካሪቢያን ኔዘርላንድስ",
        "BR": "ብራዚል",
        "BS": "ባሃማስ",
        "BT": "ቡህታን",
        "BV": "ደሴታት ቦውቬት",
        "BW": "ቦትስዋና",
        "BY": "ቤላሩስ",
        "BZ": "ቤሊዘ",
        "CA": "ካናዳ",
        "CC": "ኮኮስ ኬሊንግ ደሴቶች",
        "CD": "ኮንጎ",
        "CF": "ማእከላይ ኣፍሪቃ ሪፓብሊክ",
        "CG": "ኮንጎ ሪፓብሊክ",
        "CH": "ስዊዘርላንድ",
        "CI": "ኮት ዲቯር",
        "CK": "ደሴታት ኩክ",
        "CL": "ቺሊ",
        "CM": "ካሜሩን",
        "CN": "ቻይና",
        "CO": "ኮሎምቢያ",
        "CP": "ክሊፐርቶን ደሴት",
        "CR": "ኮስታ ሪካ",
        "CU": "ኩባ",
        "CV": "ኬፕ ቬርዴ",
        "CW": "ኩራካዎ",
        "CX": "ደሴታት ክሪስትማስ",
        "CY": "ሳይፕረስ",
        "CZ": "ቼክ ሪፓብሊክ",
        "DE": "ጀርመን",
        "DG": "ዲየጎ ጋርሺያ",
        "DJ": "ጂቡቲ",
        "DK": "ዴንማርክ",
        "DM": "ዶሚኒካ",
        "DO": "ዶመኒካ ሪፓብሊክ",
        "DZ": "አልጄሪያ",
        "EA": "ሲውታን ሜሊላን",
        "EC": "ኢኳዶር",
        "EE": "ኤስቶኒያ",
        "EG": "ግብጽ",
        "EH": "ምዕራባዊ ሳህራ",
        "ER": "ኤርትራ",
        "ES": "ስፔን",
        "ET": "ኢትዮጵያ",
        "FI": "ፊንላንድ",
        "FJ": "ፊጂ",
        "FK": "ደሴታት ፎክላንድ",
        "FM": "ሚክሮኔዢያ",
        "FO": "ደሴታት ፋራኦ",
        "FR": "ፈረንሳይ",
        "GA": "ጋቦን",
        "GB": "እንግሊዝ",
        "GD": "ግሬናዳ",
        "GE": "ጆርጂያ",
        "GF": "ናይ ፈረንሳይ ጉይና",
        "GG": "ገርንሲ",
        "GH": "ጋና",
        "GI": "ጊብራልታር",
        "GL": "ግሪንላንድ",
        "GM": "ጋምቢያ",
        "GN": "ጊኒ",
        "GP": "ጉዋደሉፕ",
        "GQ": "ኢኳቶሪያል ጊኒ",
        "GR": "ግሪክ",
        "GS": "ደሴታት ደቡብ ጆርጂያን ደቡድ ሳንድዊችን",
        "GT": "ጉዋቲማላ",
        "GU": "ጉዋም",
        "GW": "ቢሳዎ",
        "GY": "ጉያና",
        "HK": "ሆንግ ኮንግ",
        "HM": "ደሴታት ሀርድን ማክዶናልድን",
        "HN": "ሆንዱራስ",
        "HR": "ክሮኤሽያ",
        "HT": "ሀይቲ",
        "HU": "ሀንጋሪ",
        "IC": "ደሴታት ካናሪ",
        "ID": "ኢንዶኔዢያ",
        "IE": "አየርላንድ",
        "IL": "እስራኤል",
        "IM": "አይል ኦፍ ማን",
        "IN": "ህንዲ",
        "IO": "ናይ ብሪጣንያ ህንዳዊ ውቅያኖስ ግዝኣት",
        "IQ": "ኢራቅ",
        "IR": "ኢራን",
        "IS": "አይስላንድ",
        "IT": "ጣሊያን",
        "JE": "ጀርሲ",
        "JM": "ጃማይካ",
        "JO": "ጆርዳን",
        "JP": "ጃፓን",
        "KE": "ኬንያ",
        "KG": "ኪርጂስታን",
        "KH": "ካምቦዲያ",
        "KI": "ኪሪባቲ",
        "KM": "ኮሞሮስ",
        "KN": "ቅዱስ ኪትስን ኔቪስን",
        "KP": "ሰሜን ኮሪያ",
        "KR": "ደቡብ ኮሪያ",
        "KW": "ክዌት",
        "KY": "ካይማን ደሴቶች",
        "KZ": "ካዛኪስታን",
        "LA": "ላኦስ",
        "LB": "ሊባኖስ",
        "LC": "ሴንት ሉቺያ",
        "LI": "ሊችተንስታይን",
        "LK": "ሲሪላንካ",
        "LR": "ላይቤሪያ",
        "LS": "ሌሶቶ",
        "LT": "ሊቱዌኒያ",
        "LU": "ሉክሰምበርግ",
        "LV": "ላትቪያ",
        "LY": "ሊቢያ",
        "MA": "ሞሮኮ",
        "MC": "ሞናኮ",
        "MD": "ሞልዶቫ",
        "ME": "ሞንቴኔግሮ",
        "MF": "ሴንት ማርቲን",
        "MG": "ማዳጋስካር",
        "MH": "ማርሻል አይላንድ",
        "MK": "ማከዶኒያ",
        "ML": "ማሊ",
        "MM": "ማያንማር",
        "MN": "ሞንጎሊያ",
        "MO": "ማካዎ",
        "MP": "ደሴታት ሰሜናዊ ማሪያና",
        "MQ": "ማርቲኒክ",
        "MR": "ሞሪቴኒያ",
        "MS": "ሞንትሴራት",
        "MT": "ማልታ",
        "MU": "ማሩሸስ",
        "MV": "ማልዲቭስ",
        "MW": "ማላዊ",
        "MX": "ሜክሲኮ",
        "MY": "ማሌዢያ",
        "MZ": "ሞዛምቢክ",
        "NA": "ናሚቢያ",
        "NC": "ኒው ካሌዶኒያ",
        "NE": "ኒጀር",
        "NF": "ኖርፎልክ ደሴት",
        "NG": "ናይጄሪያ",
        "NI": "ኒካራጓ",
        "NL": "ኔዘርላንድስ",
        "NO": "ኖርዌ",
        "NP": "ኔፓል",
        "NR": "ናኡሩ",
        "NU": "ኒኡይ",
        "NZ": "ኒው ዚላንድ",
        "OM": "ኦማን",
        "PA": "ፓናማ",
        "PE": "ፔሩ",
        "PF": "ናይ ፈረንሳይ ፖሊነዝያ",
        "PG": "ፓፑዋ ኒው ጊኒ",
        "PH": "ፊሊፒንስ",
        "PK": "ፓኪስታን",
        "PL": "ፖላንድ",
        "PM": "ቅዱስ ፒዬርን ሚኩኤሎን",
        "PN": "ፒትካኢርን",
        "PR": "ፖርታ ሪኮ",
        "PS": "ምምሕዳር ፍልስጤም",
        "PT": "ፖርቱጋል",
        "PW": "ፓላው",
        "PY": "ፓራጓይ",
        "QA": "ቀጠር",
        "QO": "ወጣ ያለ ኦሽኒያ",
        "RE": "ሪዩኒየን",
        "RO": "ሮሜኒያ",
        "RS": "ሰርቢያ",
        "RU": "ራሺያ",
        "RW": "ሩዋንዳ",
        "SA": "ስዑዲ ዓረብ",
        "SB": "ሰሎሞን ደሴት",
        "SC": "ሲሼልስ",
        "SD": "ሱዳን",
        "SE": "ስዊድን",
        "SG": "ሲንጋፖር",
        "SH": "ሴንት ሄለና",
        "SI": "ስሎቬኒያ",
        "SJ": "ስቫልባርድን ዣን ማየን ደሴታት",
        "SK": "ስሎቫኪያ",
        "SL": "ሴራሊዮን",
        "SM": "ሳን ማሪኖ",
        "SN": "ሴኔጋል",
        "SO": "ሱማሌ",
        "SR": "ሱሪናም",
        "SS": "ደቡብ ሱዳን",
        "ST": "ሳኦ ቶሜን ፕሪንሲፔን",
        "SV": "ኤል ሳልቫዶር",
        "SX": "ሲንት ማርቲን",
        "SY": "ሲሪያ",
        "SZ": "ሱዋዚላንድ",
        "TA": "ትሪስን ዳ ኩንሃ",
        "TC": "ደሴታት ቱርክን ካይኮስን",
        "TD": "ጫድ",
        "TF": "ናይ ፈረንሳይ ደቡባዊ ግዝኣታት",
        "TG": "ቶጐ",
        "TH": "ታይላንድ",
        "TJ": "ታጃኪስታን",
        "TK": "ቶክላው",
        "TL": "ምብራቕ ቲሞር",
        "TM": "ቱርክሜኒስታን",
        "TN": "ቱኒዚያ",
        "TO": "ቶንጋ",
        "TR": "ቱርክ",
        "TT": "ትሪኒዳድን ቶባጎን",
        "TV": "ቱቫሉ",
        "TW": "ታይዋን",
        "TZ": "ታንዛኒያ",
        "UA": "ዩክሬን",
        "UG": "ዩጋንዳ",
        "UM": "ናይ ኣሜሪካ ፍንትት ዝበሉ ደሴታት",
        "US": "አሜሪካ",
        "UY": "ኡራጓይ",
        "UZ": "ዩዝበኪስታን",
        "VA": "ቫቲካን",
        "VC": "ቅዱስ ቪንሴንትን ግሬናዲንስን",
        "VE": "ቬንዙዌላ",
        "VG": "ቨርጂን ደሴታት እንግሊዝ",
        "VI": "ቨርጂን ደሴታት ኣሜሪካ",
        "VN": "ቬትናም",
        "VU": "ቫኑአቱ",
        "WF": "ዋሊስን ፉቱናን",
        "WS": "ሳሞአ",
        "XK": "ኮሶቮ",
        "YE": "የመን",
        "YT": "ሜይኦቴ",
        "ZA": "ደቡብ አፍሪካ",
        "ZM": "ዛምቢያ",
        "ZW": "ዚምቧቤ"
    };
  }-*/;
}
