/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "it" locale.
 */
public class LocalizedNamesImpl_it extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IT",
        "DE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "UM",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "BQ",
        "CZ",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "EZ",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GS",
        "DE",
        "GH",
        "JM",
        "JP",
        "GI",
        "DJ",
        "JO",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "AC",
        "BV",
        "CX",
        "CP",
        "IM",
        "NF",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FO",
        "FK",
        "HM",
        "MP",
        "MH",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "IL",
        "IT",
        "JE",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "UN",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "HK",
        "MO",
        "GB",
        "CF",
        "MK",
        "DO",
        "RE",
        "RO",
        "RW",
        "RU",
        "EH",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "SH",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "US",
        "ZA",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SE",
        "CH",
        "SZ",
        "TJ",
        "TW",
        "TZ",
        "TF",
        "IO",
        "PS",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UG",
        "HU",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mondo");
    namesMap.put("003", "Nord America");
    namesMap.put("005", "America del Sud");
    namesMap.put("011", "Africa occidentale");
    namesMap.put("013", "America Centrale");
    namesMap.put("014", "Africa orientale");
    namesMap.put("015", "Nordafrica");
    namesMap.put("017", "Africa centrale");
    namesMap.put("018", "Africa del Sud");
    namesMap.put("019", "Americhe");
    namesMap.put("021", "America del Nord");
    namesMap.put("029", "Caraibi");
    namesMap.put("030", "Asia orientale");
    namesMap.put("034", "Asia del Sud");
    namesMap.put("035", "Sud-est asiatico");
    namesMap.put("039", "Europa meridionale");
    namesMap.put("057", "Regione micronesiana");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia centrale");
    namesMap.put("145", "Asia occidentale");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa orientale");
    namesMap.put("154", "Europa settentrionale");
    namesMap.put("155", "Europa occidentale");
    namesMap.put("202", "Africa subsahariana");
    namesMap.put("419", "America Latina");
    namesMap.put("AC", "Isola Ascensione");
    namesMap.put("AE", "Emirati Arabi Uniti");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AQ", "Antartide");
    namesMap.put("AS", "Samoa americane");
    namesMap.put("AX", "Isole Åland");
    namesMap.put("AZ", "Azerbaigian");
    namesMap.put("BA", "Bosnia ed Erzegovina");
    namesMap.put("BE", "Belgio");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "Saint-Barthélemy");
    namesMap.put("BQ", "Caraibi olandesi");
    namesMap.put("BR", "Brasile");
    namesMap.put("BV", "Isola Bouvet");
    namesMap.put("BY", "Bielorussia");
    namesMap.put("CC", "Isole Cocos (Keeling)");
    namesMap.put("CF", "Repubblica Centrafricana");
    namesMap.put("CG", "Congo-Brazzaville");
    namesMap.put("CH", "Svizzera");
    namesMap.put("CI", "Costa d’Avorio");
    namesMap.put("CK", "Isole Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Camerun");
    namesMap.put("CN", "Cina");
    namesMap.put("CP", "Isola di Clipperton");
    namesMap.put("CV", "Capo Verde");
    namesMap.put("CX", "Isola Christmas");
    namesMap.put("CY", "Cipro");
    namesMap.put("CZ", "Cechia");
    namesMap.put("DE", "Germania");
    namesMap.put("DJ", "Gibuti");
    namesMap.put("DK", "Danimarca");
    namesMap.put("DO", "Repubblica Dominicana");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EG", "Egitto");
    namesMap.put("EH", "Sahara occidentale");
    namesMap.put("ES", "Spagna");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Unione Europea");
    namesMap.put("EZ", "Eurozona");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Figi");
    namesMap.put("FK", "Isole Falkland");
    namesMap.put("FO", "Isole Fær Øer");
    namesMap.put("FR", "Francia");
    namesMap.put("GB", "Regno Unito");
    namesMap.put("GF", "Guyana francese");
    namesMap.put("GI", "Gibilterra");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GP", "Guadalupa");
    namesMap.put("GQ", "Guinea Equatoriale");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Georgia del Sud e Sandwich australi");
    namesMap.put("HK", "RAS di Hong Kong");
    namesMap.put("HM", "Isole Heard e McDonald");
    namesMap.put("HR", "Croazia");
    namesMap.put("HU", "Ungheria");
    namesMap.put("IC", "Isole Canarie");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IL", "Israele");
    namesMap.put("IM", "Isola di Man");
    namesMap.put("IO", "Territorio britannico dell’Oceano Indiano");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Giamaica");
    namesMap.put("JO", "Giordania");
    namesMap.put("JP", "Giappone");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Cambogia");
    namesMap.put("KM", "Comore");
    namesMap.put("KN", "Saint Kitts e Nevis");
    namesMap.put("KP", "Corea del Nord");
    namesMap.put("KR", "Corea del Sud");
    namesMap.put("KY", "Isole Cayman");
    namesMap.put("KZ", "Kazakistan");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Saint Lucia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Lussemburgo");
    namesMap.put("LV", "Lettonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marocco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MF", "Saint Martin");
    namesMap.put("MH", "Isole Marshall");
    namesMap.put("MK", "Repubblica di Macedonia");
    namesMap.put("MM", "Myanmar (Birmania)");
    namesMap.put("MO", "RAS di Macao");
    namesMap.put("MP", "Isole Marianne settentrionali");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MV", "Maldive");
    namesMap.put("MX", "Messico");
    namesMap.put("MZ", "Mozambico");
    namesMap.put("NC", "Nuova Caledonia");
    namesMap.put("NF", "Isola Norfolk");
    namesMap.put("NL", "Paesi Bassi");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Nuova Zelanda");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perù");
    namesMap.put("PF", "Polinesia francese");
    namesMap.put("PG", "Papua Nuova Guinea");
    namesMap.put("PH", "Filippine");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint-Pierre e Miquelon");
    namesMap.put("PN", "Isole Pitcairn");
    namesMap.put("PR", "Portorico");
    namesMap.put("PS", "Territori palestinesi");
    namesMap.put("PT", "Portogallo");
    namesMap.put("QO", "Oceania lontana");
    namesMap.put("RE", "Riunione");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Isole Salomone");
    namesMap.put("SE", "Svezia");
    namesMap.put("SH", "Sant’Elena");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Slovacchia");
    namesMap.put("SS", "Sud Sudan");
    namesMap.put("ST", "São Tomé e Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("TC", "Isole Turks e Caicos");
    namesMap.put("TD", "Ciad");
    namesMap.put("TF", "Terre australi francesi");
    namesMap.put("TH", "Thailandia");
    namesMap.put("TJ", "Tagikistan");
    namesMap.put("TL", "Timor Est");
    namesMap.put("TR", "Turchia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("UA", "Ucraina");
    namesMap.put("UM", "Altre isole americane del Pacifico");
    namesMap.put("UN", "Nazioni Unite");
    namesMap.put("US", "Stati Uniti");
    namesMap.put("VA", "Città del Vaticano");
    namesMap.put("VC", "Saint Vincent e Grenadine");
    namesMap.put("VG", "Isole Vergini Britanniche");
    namesMap.put("VI", "Isole Vergini Americane");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("ZA", "Sudafrica");
    namesMap.put("ZZ", "Regione sconosciuta");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mondo",
        "003": "Nord America",
        "005": "America del Sud",
        "011": "Africa occidentale",
        "013": "America Centrale",
        "014": "Africa orientale",
        "015": "Nordafrica",
        "017": "Africa centrale",
        "018": "Africa del Sud",
        "019": "Americhe",
        "021": "America del Nord",
        "029": "Caraibi",
        "030": "Asia orientale",
        "034": "Asia del Sud",
        "035": "Sud-est asiatico",
        "039": "Europa meridionale",
        "057": "Regione micronesiana",
        "061": "Polinesia",
        "143": "Asia centrale",
        "145": "Asia occidentale",
        "150": "Europa",
        "151": "Europa orientale",
        "154": "Europa settentrionale",
        "155": "Europa occidentale",
        "202": "Africa subsahariana",
        "419": "America Latina",
        "AC": "Isola Ascensione",
        "AE": "Emirati Arabi Uniti",
        "AG": "Antigua e Barbuda",
        "AQ": "Antartide",
        "AS": "Samoa americane",
        "AX": "Isole Åland",
        "AZ": "Azerbaigian",
        "BA": "Bosnia ed Erzegovina",
        "BE": "Belgio",
        "BH": "Bahrein",
        "BL": "Saint-Barthélemy",
        "BQ": "Caraibi olandesi",
        "BR": "Brasile",
        "BV": "Isola Bouvet",
        "BY": "Bielorussia",
        "CC": "Isole Cocos (Keeling)",
        "CF": "Repubblica Centrafricana",
        "CG": "Congo-Brazzaville",
        "CH": "Svizzera",
        "CI": "Costa d’Avorio",
        "CK": "Isole Cook",
        "CL": "Cile",
        "CM": "Camerun",
        "CN": "Cina",
        "CP": "Isola di Clipperton",
        "CV": "Capo Verde",
        "CX": "Isola Christmas",
        "CY": "Cipro",
        "CZ": "Cechia",
        "DE": "Germania",
        "DJ": "Gibuti",
        "DK": "Danimarca",
        "DO": "Repubblica Dominicana",
        "EA": "Ceuta e Melilla",
        "EG": "Egitto",
        "EH": "Sahara occidentale",
        "ES": "Spagna",
        "ET": "Etiopia",
        "EU": "Unione Europea",
        "EZ": "Eurozona",
        "FI": "Finlandia",
        "FJ": "Figi",
        "FK": "Isole Falkland",
        "FO": "Isole Fær Øer",
        "FR": "Francia",
        "GB": "Regno Unito",
        "GF": "Guyana francese",
        "GI": "Gibilterra",
        "GL": "Groenlandia",
        "GP": "Guadalupa",
        "GQ": "Guinea Equatoriale",
        "GR": "Grecia",
        "GS": "Georgia del Sud e Sandwich australi",
        "HK": "RAS di Hong Kong",
        "HM": "Isole Heard e McDonald",
        "HR": "Croazia",
        "HU": "Ungheria",
        "IC": "Isole Canarie",
        "IE": "Irlanda",
        "IL": "Israele",
        "IM": "Isola di Man",
        "IO": "Territorio britannico dell’Oceano Indiano",
        "IS": "Islanda",
        "IT": "Italia",
        "JM": "Giamaica",
        "JO": "Giordania",
        "JP": "Giappone",
        "KG": "Kirghizistan",
        "KH": "Cambogia",
        "KM": "Comore",
        "KN": "Saint Kitts e Nevis",
        "KP": "Corea del Nord",
        "KR": "Corea del Sud",
        "KY": "Isole Cayman",
        "KZ": "Kazakistan",
        "LB": "Libano",
        "LC": "Saint Lucia",
        "LT": "Lituania",
        "LU": "Lussemburgo",
        "LV": "Lettonia",
        "LY": "Libia",
        "MA": "Marocco",
        "MD": "Moldavia",
        "MF": "Saint Martin",
        "MH": "Isole Marshall",
        "MK": "Repubblica di Macedonia",
        "MM": "Myanmar (Birmania)",
        "MO": "RAS di Macao",
        "MP": "Isole Marianne settentrionali",
        "MQ": "Martinica",
        "MV": "Maldive",
        "MX": "Messico",
        "MZ": "Mozambico",
        "NC": "Nuova Caledonia",
        "NF": "Isola Norfolk",
        "NL": "Paesi Bassi",
        "NO": "Norvegia",
        "NZ": "Nuova Zelanda",
        "PA": "Panamá",
        "PE": "Perù",
        "PF": "Polinesia francese",
        "PG": "Papua Nuova Guinea",
        "PH": "Filippine",
        "PL": "Polonia",
        "PM": "Saint-Pierre e Miquelon",
        "PN": "Isole Pitcairn",
        "PR": "Portorico",
        "PS": "Territori palestinesi",
        "PT": "Portogallo",
        "QO": "Oceania lontana",
        "RE": "Riunione",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Isole Salomone",
        "SE": "Svezia",
        "SH": "Sant’Elena",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Slovacchia",
        "SS": "Sud Sudan",
        "ST": "São Tomé e Príncipe",
        "SY": "Siria",
        "TC": "Isole Turks e Caicos",
        "TD": "Ciad",
        "TF": "Terre australi francesi",
        "TH": "Thailandia",
        "TJ": "Tagikistan",
        "TL": "Timor Est",
        "TR": "Turchia",
        "TT": "Trinidad e Tobago",
        "UA": "Ucraina",
        "UM": "Altre isole americane del Pacifico",
        "UN": "Nazioni Unite",
        "US": "Stati Uniti",
        "VA": "Città del Vaticano",
        "VC": "Saint Vincent e Grenadine",
        "VG": "Isole Vergini Britanniche",
        "VI": "Isole Vergini Americane",
        "WF": "Wallis e Futuna",
        "ZA": "Sudafrica",
        "ZZ": "Regione sconosciuta"
    };
  }-*/;
}
