/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fo" locale.
 */
public class LocalizedNamesImpl_fo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "BS",
        "BD",
        "BB",
        "BH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "KY",
        "EA",
        "CP",
        "CK",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EG",
        "EC",
        "GQ",
        "SV",
        "ER",
        "EE",
        "ET",
        "EZ",
        "EU",
        "AT",
        "TL",
        "FK",
        "FJ",
        "CI",
        "PH",
        "FI",
        "QO",
        "FR",
        "GF",
        "PF",
        "TF",
        "FO",
        "GA",
        "GM",
        "GH",
        "GE",
        "GI",
        "GD",
        "GR",
        "CV",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "BY",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "CX",
        "JO",
        "KH",
        "CM",
        "CA",
        "IC",
        "KZ",
        "QA",
        "CZ",
        "KE",
        "CL",
        "CN",
        "KG",
        "KI",
        "TD",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "YT",
        "MX",
        "CF",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MR",
        "MU",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "BQ",
        "NE",
        "NG",
        "NI",
        "NU",
        "MP",
        "KP",
        "NO",
        "NF",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "PM",
        "SB",
        "US",
        "UM",
        "VI",
        "ZM",
        "AE",
        "UN",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "ZW",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "BL",
        "SH",
        "KN",
        "LC",
        "VC",
        "MF",
        "GB",
        "IO",
        "VG",
        "SD",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SR",
        "SJ",
        "SZ",
        "CH",
        "SE",
        "SY",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "DE",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "EH",
        "VN",
        "WF",
        "XA",
        "XB",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "heimur");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Norðuramerika");
    namesMap.put("005", "Suðuramerika");
    namesMap.put("009", "Osiania");
    namesMap.put("011", "Vesturafrika");
    namesMap.put("013", "Miðamerika");
    namesMap.put("014", "Eysturafrika");
    namesMap.put("015", "Norðurafrika");
    namesMap.put("017", "Miðafrika");
    namesMap.put("018", "sunnari partur av Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika norðanfyri Meksiko");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Eysturasia");
    namesMap.put("034", "Suðurasia");
    namesMap.put("035", "Útsynningsasia");
    namesMap.put("039", "Suðurevropa");
    namesMap.put("053", "Avstralasia");
    namesMap.put("057", "Mikronesi øki");
    namesMap.put("143", "Miðasia");
    namesMap.put("145", "Vesturasia");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "Eysturevropa");
    namesMap.put("154", "Norðurevropa");
    namesMap.put("155", "Vesturevropa");
    namesMap.put("202", "Afrika sunnanfyri Sahara");
    namesMap.put("419", "Latínamerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Sameindu Emirríkini");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerikanska Samoa");
    namesMap.put("AT", "Eysturríki");
    namesMap.put("AU", "Avstralia");
    namesMap.put("AX", "Áland");
    namesMap.put("AZ", "Aserbadjan");
    namesMap.put("BA", "Bosnia-Hersegovina");
    namesMap.put("BD", "Bangladesj");
    namesMap.put("BE", "Belgia");
    namesMap.put("BH", "Barein");
    namesMap.put("BQ", "Niðurlonds Karibia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahamaoyggjar");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Bouvetoyggj");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BY", "Hvítarussland");
    namesMap.put("BZ", "Belis");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosoyggjar");
    namesMap.put("CD", "Kongo, Dem. Lýðveldið");
    namesMap.put("CF", "Miðafrikalýðveldið");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Sveis");
    namesMap.put("CI", "Fílabeinsstrondin");
    namesMap.put("CK", "Cooksoyggjar");
    namesMap.put("CL", "Kili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Grønhøvdaoyggjar");
    namesMap.put("CX", "Jólaoyggjin");
    namesMap.put("CY", "Kýpros");
    namesMap.put("CZ", "Kekkia");
    namesMap.put("DE", "Týskland");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikalýðveldið");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Egyptaland");
    namesMap.put("EH", "Vestursahara");
    namesMap.put("ES", "Spania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Evropasamveldið");
    namesMap.put("EZ", "Evrasona");
    namesMap.put("FI", "Finnland");
    namesMap.put("FK", "Falklandsoyggjar");
    namesMap.put("FM", "Mikronesiasamveldið");
    namesMap.put("FO", "Føroyar");
    namesMap.put("FR", "Frakland");
    namesMap.put("GB", "Stórabretland");
    namesMap.put("GF", "Franska Gujana");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grønland");
    namesMap.put("GQ", "Ekvatorguinea");
    namesMap.put("GR", "Grikkaland");
    namesMap.put("GS", "Suðurgeorgia og Suðursandwichoyggjar");
    namesMap.put("GY", "Gujana");
    namesMap.put("HK", "Hong Kong SAR Kina");
    namesMap.put("HM", "Heard og McDonaldoyggjar");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Kanariuoyggjar");
    namesMap.put("IE", "Írland");
    namesMap.put("IL", "Ísrael");
    namesMap.put("IO", "Stóra Bretlands Indiahavoyggjar");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Ísland");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("KE", "Kenja");
    namesMap.put("KG", "Kirgisia");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komoroyggjar");
    namesMap.put("KP", "Norðurkorea");
    namesMap.put("KR", "Suðurkorea");
    namesMap.put("KW", "Kuvait");
    namesMap.put("KY", "Caymanoyggjar");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "St. Lusia");
    namesMap.put("LI", "Liktinstein");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litava");
    namesMap.put("LU", "Luksemborg");
    namesMap.put("LV", "Lettland");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monako");
    namesMap.put("MF", "St-Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalloyggjar");
    namesMap.put("MK", "Makedónia");
    namesMap.put("MO", "Makao SAR Kina");
    namesMap.put("MP", "Norðaru Mariuoyggjar");
    namesMap.put("MR", "Móritania");
    namesMap.put("MU", "Móritius");
    namesMap.put("MV", "Maldivoyggjar");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malaisia");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Nýkaledónia");
    namesMap.put("NF", "Norfolksoyggj");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Niðurlond");
    namesMap.put("NO", "Noreg");
    namesMap.put("NZ", "Nýsæland");
    namesMap.put("PF", "Franska Polynesia");
    namesMap.put("PG", "Papua Nýguinea");
    namesMap.put("PH", "Filipsoyggjar");
    namesMap.put("PL", "Pólland");
    namesMap.put("PM", "Saint Pierre & Miquelon");
    namesMap.put("PN", "Pitcairnoyggjar");
    namesMap.put("PR", "Puerto Riko");
    namesMap.put("PS", "Palestinskt landøki");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "fjarskoti Osiania");
    namesMap.put("RO", "Rumenia");
    namesMap.put("RU", "Russland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudiarabia");
    namesMap.put("SB", "Salomonoyggjar");
    namesMap.put("SC", "Seyskelloyggjar");
    namesMap.put("SE", "Svøríki");
    namesMap.put("SG", "Singapor");
    namesMap.put("SL", "Sierra Leona");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Suðursudan");
    namesMap.put("ST", "Sao Tome & Prinsipi");
    namesMap.put("SY", "Sýria");
    namesMap.put("SZ", "Svasiland");
    namesMap.put("TC", "Turks- og Caicosoyggjar");
    namesMap.put("TD", "Kjad");
    namesMap.put("TF", "Fronsku sunnaru landaøki");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tadsjikistan");
    namesMap.put("TL", "Eysturtimor");
    namesMap.put("TN", "Tunesia");
    namesMap.put("TR", "Turkaland");
    namesMap.put("TW", "Taivan");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Sambandsríki Amerikas fjarskotnu oyggjar");
    namesMap.put("UN", "Sameindu Tjóðir");
    namesMap.put("US", "Sambandsríki Amerika");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikanbýur");
    namesMap.put("VC", "St. Vinsent & Grenadinoyggjar");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "Stóra Bretlands Jomfrúoyggjar");
    namesMap.put("VI", "Sambandsríki Amerikas Jomfrúoyggjar");
    namesMap.put("VN", "Vjetnam");
    namesMap.put("WF", "Wallis- og Futunaoyggjar");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Suðurafrika");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabvi");
    namesMap.put("ZZ", "ókent øki");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "heimur",
        "002": "Afrika",
        "003": "Norðuramerika",
        "005": "Suðuramerika",
        "009": "Osiania",
        "011": "Vesturafrika",
        "013": "Miðamerika",
        "014": "Eysturafrika",
        "015": "Norðurafrika",
        "017": "Miðafrika",
        "018": "sunnari partur av Afrika",
        "019": "Amerika",
        "021": "Amerika norðanfyri Meksiko",
        "029": "Karibia",
        "030": "Eysturasia",
        "034": "Suðurasia",
        "035": "Útsynningsasia",
        "039": "Suðurevropa",
        "053": "Avstralasia",
        "057": "Mikronesi øki",
        "143": "Miðasia",
        "145": "Vesturasia",
        "150": "Evropa",
        "151": "Eysturevropa",
        "154": "Norðurevropa",
        "155": "Vesturevropa",
        "202": "Afrika sunnanfyri Sahara",
        "419": "Latínamerika",
        "AC": "Ascension",
        "AE": "Sameindu Emirríkini",
        "AF": "Afganistan",
        "AQ": "Antarktis",
        "AS": "Amerikanska Samoa",
        "AT": "Eysturríki",
        "AU": "Avstralia",
        "AX": "Áland",
        "AZ": "Aserbadjan",
        "BA": "Bosnia-Hersegovina",
        "BD": "Bangladesj",
        "BE": "Belgia",
        "BH": "Barein",
        "BQ": "Niðurlonds Karibia",
        "BR": "Brasil",
        "BS": "Bahamaoyggjar",
        "BT": "Butan",
        "BV": "Bouvetoyggj",
        "BW": "Botsvana",
        "BY": "Hvítarussland",
        "BZ": "Belis",
        "CA": "Kanada",
        "CC": "Kokosoyggjar",
        "CD": "Kongo, Dem. Lýðveldið",
        "CF": "Miðafrikalýðveldið",
        "CG": "Kongo",
        "CH": "Sveis",
        "CI": "Fílabeinsstrondin",
        "CK": "Cooksoyggjar",
        "CL": "Kili",
        "CM": "Kamerun",
        "CN": "Kina",
        "CO": "Kolombia",
        "CP": "Clipperton",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Grønhøvdaoyggjar",
        "CX": "Jólaoyggjin",
        "CY": "Kýpros",
        "CZ": "Kekkia",
        "DE": "Týskland",
        "DJ": "Djibuti",
        "DK": "Danmark",
        "DM": "Dominika",
        "DO": "Dominikalýðveldið",
        "EC": "Ekvador",
        "EE": "Estland",
        "EG": "Egyptaland",
        "EH": "Vestursahara",
        "ES": "Spania",
        "ET": "Etiopia",
        "EU": "Evropasamveldið",
        "EZ": "Evrasona",
        "FI": "Finnland",
        "FK": "Falklandsoyggjar",
        "FM": "Mikronesiasamveldið",
        "FO": "Føroyar",
        "FR": "Frakland",
        "GB": "Stórabretland",
        "GF": "Franska Gujana",
        "GH": "Gana",
        "GL": "Grønland",
        "GQ": "Ekvatorguinea",
        "GR": "Grikkaland",
        "GS": "Suðurgeorgia og Suðursandwichoyggjar",
        "GY": "Gujana",
        "HK": "Hong Kong SAR Kina",
        "HM": "Heard og McDonaldoyggjar",
        "HR": "Kroatia",
        "HU": "Ungarn",
        "IC": "Kanariuoyggjar",
        "IE": "Írland",
        "IL": "Ísrael",
        "IO": "Stóra Bretlands Indiahavoyggjar",
        "IQ": "Irak",
        "IS": "Ísland",
        "IT": "Italia",
        "JM": "Jamaika",
        "KE": "Kenja",
        "KG": "Kirgisia",
        "KH": "Kambodja",
        "KM": "Komoroyggjar",
        "KP": "Norðurkorea",
        "KR": "Suðurkorea",
        "KW": "Kuvait",
        "KY": "Caymanoyggjar",
        "KZ": "Kasakstan",
        "LB": "Libanon",
        "LC": "St. Lusia",
        "LI": "Liktinstein",
        "LS": "Lesoto",
        "LT": "Litava",
        "LU": "Luksemborg",
        "LV": "Lettland",
        "MA": "Marokko",
        "MC": "Monako",
        "MF": "St-Martin",
        "MG": "Madagaskar",
        "MH": "Marshalloyggjar",
        "MK": "Makedónia",
        "MO": "Makao SAR Kina",
        "MP": "Norðaru Mariuoyggjar",
        "MR": "Móritania",
        "MU": "Móritius",
        "MV": "Maldivoyggjar",
        "MW": "Malavi",
        "MX": "Meksiko",
        "MY": "Malaisia",
        "MZ": "Mosambik",
        "NC": "Nýkaledónia",
        "NF": "Norfolksoyggj",
        "NI": "Nikaragua",
        "NL": "Niðurlond",
        "NO": "Noreg",
        "NZ": "Nýsæland",
        "PF": "Franska Polynesia",
        "PG": "Papua Nýguinea",
        "PH": "Filipsoyggjar",
        "PL": "Pólland",
        "PM": "Saint Pierre & Miquelon",
        "PN": "Pitcairnoyggjar",
        "PR": "Puerto Riko",
        "PS": "Palestinskt landøki",
        "PY": "Paraguai",
        "QA": "Katar",
        "QO": "fjarskoti Osiania",
        "RO": "Rumenia",
        "RU": "Russland",
        "RW": "Ruanda",
        "SA": "Saudiarabia",
        "SB": "Salomonoyggjar",
        "SC": "Seyskelloyggjar",
        "SE": "Svøríki",
        "SG": "Singapor",
        "SL": "Sierra Leona",
        "SR": "Surinam",
        "SS": "Suðursudan",
        "ST": "Sao Tome & Prinsipi",
        "SY": "Sýria",
        "SZ": "Svasiland",
        "TC": "Turks- og Caicosoyggjar",
        "TD": "Kjad",
        "TF": "Fronsku sunnaru landaøki",
        "TH": "Tailand",
        "TJ": "Tadsjikistan",
        "TL": "Eysturtimor",
        "TN": "Tunesia",
        "TR": "Turkaland",
        "TW": "Taivan",
        "TZ": "Tansania",
        "UA": "Ukraina",
        "UM": "Sambandsríki Amerikas fjarskotnu oyggjar",
        "UN": "Sameindu Tjóðir",
        "US": "Sambandsríki Amerika",
        "UY": "Uruguai",
        "UZ": "Usbekistan",
        "VA": "Vatikanbýur",
        "VC": "St. Vinsent & Grenadinoyggjar",
        "VE": "Venesuela",
        "VG": "Stóra Bretlands Jomfrúoyggjar",
        "VI": "Sambandsríki Amerikas Jomfrúoyggjar",
        "VN": "Vjetnam",
        "WF": "Wallis- og Futunaoyggjar",
        "YE": "Jemen",
        "ZA": "Suðurafrika",
        "ZM": "Sambia",
        "ZW": "Simbabvi",
        "ZZ": "ókent øki"
    };
  }-*/;
}
