/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ka" locale.
 */
public class LocalizedNamesImpl_ka extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "GE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AU",
        "AT",
        "AF",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AC",
        "US",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AW",
        "VI",
        "UM",
        "NZ",
        "NC",
        "BD",
        "BB",
        "BS",
        "BH",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BG",
        "BF",
        "BI",
        "BT",
        "GA",
        "GY",
        "GM",
        "GH",
        "DE",
        "GG",
        "GP",
        "GT",
        "GN",
        "GW",
        "GI",
        "GD",
        "GL",
        "GU",
        "DK",
        "EH",
        "GB",
        "DG",
        "DM",
        "DO",
        "EG",
        "EU",
        "ET",
        "EC",
        "GQ",
        "IQ",
        "ER",
        "ES",
        "EE",
        "VU",
        "VE",
        "VN",
        "ZM",
        "ZW",
        "TR",
        "TM",
        "JM",
        "JP",
        "YE",
        "IN",
        "ID",
        "JO",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "CV",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KE",
        "CY",
        "KI",
        "CW",
        "CP",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "CK",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MG",
        "MU",
        "MR",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MH",
        "IM",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MN",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "AN",
        "NI",
        "NU",
        "NO",
        "NF",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "GR",
        "SV",
        "WS",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SM",
        "ST",
        "SA",
        "FR",
        "GE",
        "SC",
        "BL",
        "SN",
        "MF",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "EA",
        "SZ",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "AM",
        "SD",
        "SR",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "TC",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "UG",
        "UZ",
        "UA",
        "HU",
        "WF",
        "UY",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FK",
        "GF",
        "PF",
        "TF",
        "VA",
        "CC",
        "KW",
        "KZ",
        "KG",
        "SE",
        "CH",
        "CX",
        "QO",
        "SJ",
        "LK",
        "TD",
        "CZ",
        "CL",
        "CN",
        "KP",
        "MP",
        "CF",
        "SH",
        "HR",
        "JE",
        "DJ",
        "HT",
        "HM",
        "HN",
        "HK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "მსოფლიო");
    namesMap.put("002", "აფრიკა");
    namesMap.put("003", "ჩრდილოეთი ამერიკა");
    namesMap.put("005", "სამხრეთი ამერიკა");
    namesMap.put("009", "ოკეანეთი");
    namesMap.put("011", "დასავლეთი აფრიკა");
    namesMap.put("013", "ცენტრალური ამერიკა");
    namesMap.put("014", "აღმოსავლეთი აფრიკა");
    namesMap.put("015", "ჩრდილოეთი აფრიკა");
    namesMap.put("017", "შუა აფრიკა");
    namesMap.put("018", "სამხრეთი აფრიკა");
    namesMap.put("019", "ამერიკები");
    namesMap.put("021", "ამერიკის ჩრდილოეთი");
    namesMap.put("029", "კარიბის ზღვა");
    namesMap.put("030", "აღმოსავლეთი აზია");
    namesMap.put("034", "სამხრეთი აზია");
    namesMap.put("035", "სამხრეთ-აღმოსავლეთი აზია");
    namesMap.put("039", "სამხრეთი ევროპა");
    namesMap.put("053", "ავსტრალაზია");
    namesMap.put("054", "მელანეზია");
    namesMap.put("057", "მიკრონეზიის რეგიონი");
    namesMap.put("061", "პოლინეზია");
    namesMap.put("142", "აზია");
    namesMap.put("143", "ცენტრალური აზია");
    namesMap.put("145", "დასავლეთი აზია");
    namesMap.put("150", "ევროპა");
    namesMap.put("151", "აღმოსავლეთი ევროპა");
    namesMap.put("154", "ჩრდილოეთი ევროპა");
    namesMap.put("155", "დასავლეთი ევროპა");
    namesMap.put("419", "ლათინური ამერიკა");
    namesMap.put("AC", "ამაღლების კუნძული");
    namesMap.put("AD", "ანდორა");
    namesMap.put("AE", "არაბთა გაერთიანებული საამიროები");
    namesMap.put("AF", "ავღანეთი");
    namesMap.put("AG", "ანტიგუა და ბარბუდა");
    namesMap.put("AI", "ანგვილა");
    namesMap.put("AL", "ალბანეთი");
    namesMap.put("AM", "სომხეთი");
    namesMap.put("AN", "ნიდერლანდების ანტილები");
    namesMap.put("AO", "ანგოლა");
    namesMap.put("AQ", "ანტარქტიკა");
    namesMap.put("AR", "არგენტინა");
    namesMap.put("AS", "ამერიკული სამოა");
    namesMap.put("AT", "ავსტრია");
    namesMap.put("AU", "ავსტრალია");
    namesMap.put("AW", "არუბა");
    namesMap.put("AX", "ალანდის კუნძულები");
    namesMap.put("AZ", "აზერბაიჯანი");
    namesMap.put("BA", "ბოსნია და ჰერცეგოვინა");
    namesMap.put("BB", "ბარბადოსი");
    namesMap.put("BD", "ბანგლადეში");
    namesMap.put("BE", "ბელგია");
    namesMap.put("BF", "ბურკინა-ფასო");
    namesMap.put("BG", "ბულგარეთი");
    namesMap.put("BH", "ბაჰრეინი");
    namesMap.put("BI", "ბურუნდი");
    namesMap.put("BJ", "ბენინი");
    namesMap.put("BL", "სენ-ბართლემი");
    namesMap.put("BM", "ბერმუდი");
    namesMap.put("BN", "ბრუნეი");
    namesMap.put("BO", "ბოლივია");
    namesMap.put("BQ", "კარიბის ნიდერლანდები");
    namesMap.put("BR", "ბრაზილია");
    namesMap.put("BS", "ბაჰამის კუნძულები");
    namesMap.put("BT", "ბუტანი");
    namesMap.put("BV", "ბუვეს კუნძული");
    namesMap.put("BW", "ბოტსვანა");
    namesMap.put("BY", "ბელორუსია");
    namesMap.put("BZ", "ბელიზი");
    namesMap.put("CA", "კანადა");
    namesMap.put("CC", "ქოქოსის (კილინგის) კუნძულები");
    namesMap.put("CD", "კონგო - კინშასა");
    namesMap.put("CF", "ცენტრალური აფრიკის რესპუბლიკა");
    namesMap.put("CG", "კონგო - ბრაზავილი");
    namesMap.put("CH", "შვეიცარია");
    namesMap.put("CI", "კოტ-დივუარი");
    namesMap.put("CK", "კუკის კუნძულები");
    namesMap.put("CL", "ჩილე");
    namesMap.put("CM", "კამერუნი");
    namesMap.put("CN", "ჩინეთი");
    namesMap.put("CO", "კოლუმბია");
    namesMap.put("CP", "კლიპერტონის კუნძული");
    namesMap.put("CR", "კოსტა-რიკა");
    namesMap.put("CU", "კუბა");
    namesMap.put("CV", "კაბო-ვერდე");
    namesMap.put("CW", "კიურასაო");
    namesMap.put("CX", "შობის კუნძული");
    namesMap.put("CY", "კვიპროსი");
    namesMap.put("CZ", "ჩეხეთის რესპუბლიკა");
    namesMap.put("DE", "გერმანია");
    namesMap.put("DG", "დიეგო-გარსია");
    namesMap.put("DJ", "ჯიბუტი");
    namesMap.put("DK", "დანია");
    namesMap.put("DM", "დომინიკა");
    namesMap.put("DO", "დომინიკანის რესპუბლიკა");
    namesMap.put("DZ", "ალჟირი");
    namesMap.put("EA", "სეუტა და მელილა");
    namesMap.put("EC", "ეკვადორი");
    namesMap.put("EE", "ესტონეთი");
    namesMap.put("EG", "ეგვიპტე");
    namesMap.put("EH", "დასავლეთი საჰარა");
    namesMap.put("ER", "ერიტრეა");
    namesMap.put("ES", "ესპანეთი");
    namesMap.put("ET", "ეთიოპია");
    namesMap.put("EU", "ევროკავშირი");
    namesMap.put("FI", "ფინეთი");
    namesMap.put("FJ", "ფიჯი");
    namesMap.put("FK", "ფოლკლენდის კუნძულები");
    namesMap.put("FM", "მიკრონეზია");
    namesMap.put("FO", "ფარერის კუნძულები");
    namesMap.put("FR", "საფრანგეთი");
    namesMap.put("GA", "გაბონი");
    namesMap.put("GB", "დიდი ბრიტანეთი");
    namesMap.put("GD", "გრენადა");
    namesMap.put("GE", "საქართველო");
    namesMap.put("GF", "ფრანგული გვიანა");
    namesMap.put("GG", "გერნსი");
    namesMap.put("GH", "განა");
    namesMap.put("GI", "გიბრალტარი");
    namesMap.put("GL", "გრენლანდია");
    namesMap.put("GM", "გამბია");
    namesMap.put("GN", "გვინეა");
    namesMap.put("GP", "გვადელუპე");
    namesMap.put("GQ", "ეკვატორული გვინეა");
    namesMap.put("GR", "საბერძნეთი");
    namesMap.put("GS", "სამხრეთი გეორგია და სამხრეთ სენდვიჩის კუნძულები");
    namesMap.put("GT", "გვატემალა");
    namesMap.put("GU", "გუამი");
    namesMap.put("GW", "გვინეა-ბისაუ");
    namesMap.put("GY", "გაიანა");
    namesMap.put("HK", "ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი ჩინეთი");
    namesMap.put("HM", "ჰერდი და მაკდონალდის კუნძულები");
    namesMap.put("HN", "ჰონდურასი");
    namesMap.put("HR", "ხორვატია");
    namesMap.put("HT", "ჰაიტი");
    namesMap.put("HU", "უნგრეთი");
    namesMap.put("IC", "კანარის კუნძულები");
    namesMap.put("ID", "ინდონეზია");
    namesMap.put("IE", "ირლანდია");
    namesMap.put("IL", "ისრაელი");
    namesMap.put("IM", "მენის კუნძული");
    namesMap.put("IN", "ინდოეთი");
    namesMap.put("IO", "ბრიტანული ტერიტორია ინდოეთის ოკეანეში");
    namesMap.put("IQ", "ერაყი");
    namesMap.put("IR", "ირანი");
    namesMap.put("IS", "ისლანდია");
    namesMap.put("IT", "იტალია");
    namesMap.put("JE", "ჯერსი");
    namesMap.put("JM", "იამაიკა");
    namesMap.put("JO", "იორდანია");
    namesMap.put("JP", "იაპონია");
    namesMap.put("KE", "კენია");
    namesMap.put("KG", "ყირგიზეთი");
    namesMap.put("KH", "კამბოჯა");
    namesMap.put("KI", "კირიბატი");
    namesMap.put("KM", "კომორის კუნძულები");
    namesMap.put("KN", "სენტ-კიტსი და ნევისი");
    namesMap.put("KP", "ჩრდილოეთი კორეა");
    namesMap.put("KR", "სამხრეთი კორეა");
    namesMap.put("KW", "ქუვეითი");
    namesMap.put("KY", "კაიმანის კუნძულები");
    namesMap.put("KZ", "ყაზახეთი");
    namesMap.put("LA", "ლაოსი");
    namesMap.put("LB", "ლიბანი");
    namesMap.put("LC", "სენტ-ლუსია");
    namesMap.put("LI", "ლიხტენშტეინი");
    namesMap.put("LK", "შრი-ლანკა");
    namesMap.put("LR", "ლიბერია");
    namesMap.put("LS", "ლესოთო");
    namesMap.put("LT", "ლიტვა");
    namesMap.put("LU", "ლუქსემბურგი");
    namesMap.put("LV", "ლატვია");
    namesMap.put("LY", "ლიბია");
    namesMap.put("MA", "მაროკო");
    namesMap.put("MC", "მონაკო");
    namesMap.put("MD", "მოლდოვა");
    namesMap.put("ME", "მონტენეგრო");
    namesMap.put("MF", "სენ-მარტენი");
    namesMap.put("MG", "მადაგასკარი");
    namesMap.put("MH", "მარშალის კუნძულები");
    namesMap.put("MK", "მაკედონია");
    namesMap.put("ML", "მალი");
    namesMap.put("MM", "მიანმარი (ბირმა)");
    namesMap.put("MN", "მონღოლეთი");
    namesMap.put("MO", "მაკაოს სპეციალური ადმინისტრაციული რეგიონი ჩინეთი");
    namesMap.put("MP", "ჩრდილოეთ მარიანას კუნძულები");
    namesMap.put("MQ", "მარტინიკა");
    namesMap.put("MR", "მავრიტანია");
    namesMap.put("MS", "მონსერატი");
    namesMap.put("MT", "მალტა");
    namesMap.put("MU", "მავრიკი");
    namesMap.put("MV", "მალდივის კუნძულები");
    namesMap.put("MW", "მალავი");
    namesMap.put("MX", "მექსიკა");
    namesMap.put("MY", "მალაიზია");
    namesMap.put("MZ", "მოზამბიკი");
    namesMap.put("NA", "ნამიბია");
    namesMap.put("NC", "ახალი კალედონია");
    namesMap.put("NE", "ნიგერი");
    namesMap.put("NF", "ნორფოლკის კუნძული");
    namesMap.put("NG", "ნიგერია");
    namesMap.put("NI", "ნიკარაგუა");
    namesMap.put("NL", "ნიდერლანდები");
    namesMap.put("NO", "ნორვეგია");
    namesMap.put("NP", "ნეპალი");
    namesMap.put("NR", "ნაურუ");
    namesMap.put("NU", "ნიუე");
    namesMap.put("NZ", "ახალი ზელანდია");
    namesMap.put("OM", "ომანი");
    namesMap.put("PA", "პანამა");
    namesMap.put("PE", "პერუ");
    namesMap.put("PF", "ფრანგული პოლინეზია");
    namesMap.put("PG", "პაპუა-ახალი გვინეა");
    namesMap.put("PH", "ფილიპინები");
    namesMap.put("PK", "პაკისტანი");
    namesMap.put("PL", "პოლონეთი");
    namesMap.put("PM", "სენ-პიერი და მიკელონი");
    namesMap.put("PN", "პიტკერნის კუნძულები");
    namesMap.put("PR", "პუერტო-რიკო");
    namesMap.put("PS", "პალესტინის ტერიტორიები");
    namesMap.put("PT", "პორტუგალია");
    namesMap.put("PW", "პალაუ");
    namesMap.put("PY", "პარაგვაი");
    namesMap.put("QA", "კატარი");
    namesMap.put("QO", "შორეული ოკეანეთი");
    namesMap.put("RE", "რეუნიონი");
    namesMap.put("RO", "რუმინეთი");
    namesMap.put("RS", "სერბეთი");
    namesMap.put("RU", "რუსეთი");
    namesMap.put("RW", "რუანდა");
    namesMap.put("SA", "საუდის არაბეთი");
    namesMap.put("SB", "სოლომონის კუნძულები");
    namesMap.put("SC", "სეიშელის კუნძულები");
    namesMap.put("SD", "სუდანი");
    namesMap.put("SE", "შვედეთი");
    namesMap.put("SG", "სინგაპური");
    namesMap.put("SH", "წმინდა ელენეს კუნძული");
    namesMap.put("SI", "სლოვენია");
    namesMap.put("SJ", "შპიცბერგენი და იან-მაიენი");
    namesMap.put("SK", "სლოვაკეთი");
    namesMap.put("SL", "სიერა-ლეონე");
    namesMap.put("SM", "სან-მარინო");
    namesMap.put("SN", "სენეგალი");
    namesMap.put("SO", "სომალი");
    namesMap.put("SR", "სურინამი");
    namesMap.put("SS", "სამხრეთი სუდანი");
    namesMap.put("ST", "სან-ტომე და პრინსიპი");
    namesMap.put("SV", "სალვადორი");
    namesMap.put("SX", "სინტ-მარტენი");
    namesMap.put("SY", "სირია");
    namesMap.put("SZ", "სვაზილენდი");
    namesMap.put("TA", "ტრისტან-და-კუნია");
    namesMap.put("TC", "ტერკსის და კაიკოსის კუნძულები");
    namesMap.put("TD", "ჩადი");
    namesMap.put("TF", "ფრანგული სამხრეთის ტერიტორიები");
    namesMap.put("TG", "ტოგო");
    namesMap.put("TH", "ტაილანდი");
    namesMap.put("TJ", "ტაჯიკეთი");
    namesMap.put("TK", "ტოკელაუ");
    namesMap.put("TL", "ტიმორ-ლეშტი");
    namesMap.put("TM", "თურქმენეთი");
    namesMap.put("TN", "ტუნისი");
    namesMap.put("TO", "ტონგა");
    namesMap.put("TR", "თურქეთი");
    namesMap.put("TT", "ტრინიდადი და ტობაგო");
    namesMap.put("TV", "ტუვალუ");
    namesMap.put("TW", "ტაივანი");
    namesMap.put("TZ", "ტანზანია");
    namesMap.put("UA", "უკრაინა");
    namesMap.put("UG", "უგანდა");
    namesMap.put("UM", "აშშ-ის შორეული კუნძულები");
    namesMap.put("US", "ამერიკის შეერთებული შტატები");
    namesMap.put("UY", "ურუგვაი");
    namesMap.put("UZ", "უზბეკეთი");
    namesMap.put("VA", "ქალაქი ვატიკანი");
    namesMap.put("VC", "სენტ-ვინსენტი და გრენადინები");
    namesMap.put("VE", "ვენესუელა");
    namesMap.put("VG", "ბრიტანეთის ვირჯინიის კუნძულები");
    namesMap.put("VI", "აშშ-ის ვირჯინიის კუნძულები");
    namesMap.put("VN", "ვიეტნამი");
    namesMap.put("VU", "ვანუატუ");
    namesMap.put("WF", "უოლისი და ფუტუნა");
    namesMap.put("WS", "სამოა");
    namesMap.put("XK", "კოსოვო");
    namesMap.put("YE", "იემენი");
    namesMap.put("YT", "მაიოტა");
    namesMap.put("ZA", "სამხრეთ აფრიკა");
    namesMap.put("ZM", "ზამბია");
    namesMap.put("ZW", "ზიმბაბვე");
    namesMap.put("ZZ", "უცნობი რეგიონი");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "მსოფლიო",
        "002": "აფრიკა",
        "003": "ჩრდილოეთი ამერიკა",
        "005": "სამხრეთი ამერიკა",
        "009": "ოკეანეთი",
        "011": "დასავლეთი აფრიკა",
        "013": "ცენტრალური ამერიკა",
        "014": "აღმოსავლეთი აფრიკა",
        "015": "ჩრდილოეთი აფრიკა",
        "017": "შუა აფრიკა",
        "018": "სამხრეთი აფრიკა",
        "019": "ამერიკები",
        "021": "ამერიკის ჩრდილოეთი",
        "029": "კარიბის ზღვა",
        "030": "აღმოსავლეთი აზია",
        "034": "სამხრეთი აზია",
        "035": "სამხრეთ-აღმოსავლეთი აზია",
        "039": "სამხრეთი ევროპა",
        "053": "ავსტრალაზია",
        "054": "მელანეზია",
        "057": "მიკრონეზიის რეგიონი",
        "061": "პოლინეზია",
        "142": "აზია",
        "143": "ცენტრალური აზია",
        "145": "დასავლეთი აზია",
        "150": "ევროპა",
        "151": "აღმოსავლეთი ევროპა",
        "154": "ჩრდილოეთი ევროპა",
        "155": "დასავლეთი ევროპა",
        "419": "ლათინური ამერიკა",
        "AC": "ამაღლების კუნძული",
        "AD": "ანდორა",
        "AE": "არაბთა გაერთიანებული საამიროები",
        "AF": "ავღანეთი",
        "AG": "ანტიგუა და ბარბუდა",
        "AI": "ანგვილა",
        "AL": "ალბანეთი",
        "AM": "სომხეთი",
        "AN": "ნიდერლანდების ანტილები",
        "AO": "ანგოლა",
        "AQ": "ანტარქტიკა",
        "AR": "არგენტინა",
        "AS": "ამერიკული სამოა",
        "AT": "ავსტრია",
        "AU": "ავსტრალია",
        "AW": "არუბა",
        "AX": "ალანდის კუნძულები",
        "AZ": "აზერბაიჯანი",
        "BA": "ბოსნია და ჰერცეგოვინა",
        "BB": "ბარბადოსი",
        "BD": "ბანგლადეში",
        "BE": "ბელგია",
        "BF": "ბურკინა-ფასო",
        "BG": "ბულგარეთი",
        "BH": "ბაჰრეინი",
        "BI": "ბურუნდი",
        "BJ": "ბენინი",
        "BL": "სენ-ბართლემი",
        "BM": "ბერმუდი",
        "BN": "ბრუნეი",
        "BO": "ბოლივია",
        "BQ": "კარიბის ნიდერლანდები",
        "BR": "ბრაზილია",
        "BS": "ბაჰამის კუნძულები",
        "BT": "ბუტანი",
        "BV": "ბუვეს კუნძული",
        "BW": "ბოტსვანა",
        "BY": "ბელორუსია",
        "BZ": "ბელიზი",
        "CA": "კანადა",
        "CC": "ქოქოსის (კილინგის) კუნძულები",
        "CD": "კონგო - კინშასა",
        "CF": "ცენტრალური აფრიკის რესპუბლიკა",
        "CG": "კონგო - ბრაზავილი",
        "CH": "შვეიცარია",
        "CI": "კოტ-დივუარი",
        "CK": "კუკის კუნძულები",
        "CL": "ჩილე",
        "CM": "კამერუნი",
        "CN": "ჩინეთი",
        "CO": "კოლუმბია",
        "CP": "კლიპერტონის კუნძული",
        "CR": "კოსტა-რიკა",
        "CU": "კუბა",
        "CV": "კაბო-ვერდე",
        "CW": "კიურასაო",
        "CX": "შობის კუნძული",
        "CY": "კვიპროსი",
        "CZ": "ჩეხეთის რესპუბლიკა",
        "DE": "გერმანია",
        "DG": "დიეგო-გარსია",
        "DJ": "ჯიბუტი",
        "DK": "დანია",
        "DM": "დომინიკა",
        "DO": "დომინიკანის რესპუბლიკა",
        "DZ": "ალჟირი",
        "EA": "სეუტა და მელილა",
        "EC": "ეკვადორი",
        "EE": "ესტონეთი",
        "EG": "ეგვიპტე",
        "EH": "დასავლეთი საჰარა",
        "ER": "ერიტრეა",
        "ES": "ესპანეთი",
        "ET": "ეთიოპია",
        "EU": "ევროკავშირი",
        "FI": "ფინეთი",
        "FJ": "ფიჯი",
        "FK": "ფოლკლენდის კუნძულები",
        "FM": "მიკრონეზია",
        "FO": "ფარერის კუნძულები",
        "FR": "საფრანგეთი",
        "GA": "გაბონი",
        "GB": "დიდი ბრიტანეთი",
        "GD": "გრენადა",
        "GE": "საქართველო",
        "GF": "ფრანგული გვიანა",
        "GG": "გერნსი",
        "GH": "განა",
        "GI": "გიბრალტარი",
        "GL": "გრენლანდია",
        "GM": "გამბია",
        "GN": "გვინეა",
        "GP": "გვადელუპე",
        "GQ": "ეკვატორული გვინეა",
        "GR": "საბერძნეთი",
        "GS": "სამხრეთი გეორგია და სამხრეთ სენდვიჩის კუნძულები",
        "GT": "გვატემალა",
        "GU": "გუამი",
        "GW": "გვინეა-ბისაუ",
        "GY": "გაიანა",
        "HK": "ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი ჩინეთი",
        "HM": "ჰერდი და მაკდონალდის კუნძულები",
        "HN": "ჰონდურასი",
        "HR": "ხორვატია",
        "HT": "ჰაიტი",
        "HU": "უნგრეთი",
        "IC": "კანარის კუნძულები",
        "ID": "ინდონეზია",
        "IE": "ირლანდია",
        "IL": "ისრაელი",
        "IM": "მენის კუნძული",
        "IN": "ინდოეთი",
        "IO": "ბრიტანული ტერიტორია ინდოეთის ოკეანეში",
        "IQ": "ერაყი",
        "IR": "ირანი",
        "IS": "ისლანდია",
        "IT": "იტალია",
        "JE": "ჯერსი",
        "JM": "იამაიკა",
        "JO": "იორდანია",
        "JP": "იაპონია",
        "KE": "კენია",
        "KG": "ყირგიზეთი",
        "KH": "კამბოჯა",
        "KI": "კირიბატი",
        "KM": "კომორის კუნძულები",
        "KN": "სენტ-კიტსი და ნევისი",
        "KP": "ჩრდილოეთი კორეა",
        "KR": "სამხრეთი კორეა",
        "KW": "ქუვეითი",
        "KY": "კაიმანის კუნძულები",
        "KZ": "ყაზახეთი",
        "LA": "ლაოსი",
        "LB": "ლიბანი",
        "LC": "სენტ-ლუსია",
        "LI": "ლიხტენშტეინი",
        "LK": "შრი-ლანკა",
        "LR": "ლიბერია",
        "LS": "ლესოთო",
        "LT": "ლიტვა",
        "LU": "ლუქსემბურგი",
        "LV": "ლატვია",
        "LY": "ლიბია",
        "MA": "მაროკო",
        "MC": "მონაკო",
        "MD": "მოლდოვა",
        "ME": "მონტენეგრო",
        "MF": "სენ-მარტენი",
        "MG": "მადაგასკარი",
        "MH": "მარშალის კუნძულები",
        "MK": "მაკედონია",
        "ML": "მალი",
        "MM": "მიანმარი (ბირმა)",
        "MN": "მონღოლეთი",
        "MO": "მაკაოს სპეციალური ადმინისტრაციული რეგიონი ჩინეთი",
        "MP": "ჩრდილოეთ მარიანას კუნძულები",
        "MQ": "მარტინიკა",
        "MR": "მავრიტანია",
        "MS": "მონსერატი",
        "MT": "მალტა",
        "MU": "მავრიკი",
        "MV": "მალდივის კუნძულები",
        "MW": "მალავი",
        "MX": "მექსიკა",
        "MY": "მალაიზია",
        "MZ": "მოზამბიკი",
        "NA": "ნამიბია",
        "NC": "ახალი კალედონია",
        "NE": "ნიგერი",
        "NF": "ნორფოლკის კუნძული",
        "NG": "ნიგერია",
        "NI": "ნიკარაგუა",
        "NL": "ნიდერლანდები",
        "NO": "ნორვეგია",
        "NP": "ნეპალი",
        "NR": "ნაურუ",
        "NU": "ნიუე",
        "NZ": "ახალი ზელანდია",
        "OM": "ომანი",
        "PA": "პანამა",
        "PE": "პერუ",
        "PF": "ფრანგული პოლინეზია",
        "PG": "პაპუა-ახალი გვინეა",
        "PH": "ფილიპინები",
        "PK": "პაკისტანი",
        "PL": "პოლონეთი",
        "PM": "სენ-პიერი და მიკელონი",
        "PN": "პიტკერნის კუნძულები",
        "PR": "პუერტო-რიკო",
        "PS": "პალესტინის ტერიტორიები",
        "PT": "პორტუგალია",
        "PW": "პალაუ",
        "PY": "პარაგვაი",
        "QA": "კატარი",
        "QO": "შორეული ოკეანეთი",
        "RE": "რეუნიონი",
        "RO": "რუმინეთი",
        "RS": "სერბეთი",
        "RU": "რუსეთი",
        "RW": "რუანდა",
        "SA": "საუდის არაბეთი",
        "SB": "სოლომონის კუნძულები",
        "SC": "სეიშელის კუნძულები",
        "SD": "სუდანი",
        "SE": "შვედეთი",
        "SG": "სინგაპური",
        "SH": "წმინდა ელენეს კუნძული",
        "SI": "სლოვენია",
        "SJ": "შპიცბერგენი და იან-მაიენი",
        "SK": "სლოვაკეთი",
        "SL": "სიერა-ლეონე",
        "SM": "სან-მარინო",
        "SN": "სენეგალი",
        "SO": "სომალი",
        "SR": "სურინამი",
        "SS": "სამხრეთი სუდანი",
        "ST": "სან-ტომე და პრინსიპი",
        "SV": "სალვადორი",
        "SX": "სინტ-მარტენი",
        "SY": "სირია",
        "SZ": "სვაზილენდი",
        "TA": "ტრისტან-და-კუნია",
        "TC": "ტერკსის და კაიკოსის კუნძულები",
        "TD": "ჩადი",
        "TF": "ფრანგული სამხრეთის ტერიტორიები",
        "TG": "ტოგო",
        "TH": "ტაილანდი",
        "TJ": "ტაჯიკეთი",
        "TK": "ტოკელაუ",
        "TL": "ტიმორ-ლეშტი",
        "TM": "თურქმენეთი",
        "TN": "ტუნისი",
        "TO": "ტონგა",
        "TR": "თურქეთი",
        "TT": "ტრინიდადი და ტობაგო",
        "TV": "ტუვალუ",
        "TW": "ტაივანი",
        "TZ": "ტანზანია",
        "UA": "უკრაინა",
        "UG": "უგანდა",
        "UM": "აშშ-ის შორეული კუნძულები",
        "US": "ამერიკის შეერთებული შტატები",
        "UY": "ურუგვაი",
        "UZ": "უზბეკეთი",
        "VA": "ქალაქი ვატიკანი",
        "VC": "სენტ-ვინსენტი და გრენადინები",
        "VE": "ვენესუელა",
        "VG": "ბრიტანეთის ვირჯინიის კუნძულები",
        "VI": "აშშ-ის ვირჯინიის კუნძულები",
        "VN": "ვიეტნამი",
        "VU": "ვანუატუ",
        "WF": "უოლისი და ფუტუნა",
        "WS": "სამოა",
        "XK": "კოსოვო",
        "YE": "იემენი",
        "YT": "მაიოტა",
        "ZA": "სამხრეთ აფრიკა",
        "ZM": "ზამბია",
        "ZW": "ზიმბაბვე",
        "ZZ": "უცნობი რეგიონი"
    };
  }-*/;
}
