/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "gu" locale.
 */
public class DateTimeFormatInfoImpl_gu extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM, y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM, y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "d-MM-yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ઈસવીસન પૂર્વે",
        "ઇસવીસન"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ઈસુના જન્મ પહેલા",
        "ઇસવીસન"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatHour12Minute() {
    return "hh:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "hh:mm:ss a";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d MMM, y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "જાન્યુઆરી",
        "ફેબ્રુઆરી",
        "માર્ચ",
        "એપ્રિલ",
        "મે",
        "જૂન",
        "જુલાઈ",
        "ઑગસ્ટ",
        "સપ્ટેમ્બર",
        "ઑક્ટોબર",
        "નવેમ્બર",
        "ડિસેમ્બર"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "જા",
        "ફે",
        "મા",
        "એ",
        "મે",
        "જૂ",
        "જુ",
        "ઑ",
        "સ",
        "ઑ",
        "ન",
        "ડિ"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "જાન્યુ",
        "ફેબ્રુ",
        "માર્ચ",
        "એપ્રિલ",
        "મે",
        "જૂન",
        "જુલાઈ",
        "ઑગસ્ટ",
        "સપ્ટે",
        "ઑક્ટો",
        "નવે",
        "ડિસે"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "જાન્યુ",
        "ફેબ્રુ",
        "માર્ચ",
        "એપ્રિલ",
        "મે",
        "જૂન",
        "જુલાઈ",
        "ઑગ",
        "સપ્ટે",
        "ઑક્ટો",
        "નવે",
        "ડિસે"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "પહેલો ત્રિમાસ",
        "બીજો ત્રિમાસ",
        "ત્રીજો ત્રિમાસ",
        "ચોથો ત્રિમાસ"
    };
  }

  @Override
  public String timeFormatFull() {
    return "hh:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "hh:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "hh:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "hh:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "રવિવાર",
        "સોમવાર",
        "મંગળવાર",
        "બુધવાર",
        "ગુરુવાર",
        "શુક્રવાર",
        "શનિવાર"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ર",
        "સો",
        "મં",
        "બુ",
        "ગુ",
        "શુ",
        "શ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "રવિ",
        "સોમ",
        "મંગળ",
        "બુધ",
        "ગુરુ",
        "શુક્ર",
        "શનિ"
    };
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
