/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.logical.shared.HasAttachHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;

public class Widget
extends UIObject
implements EventListener,
HasAttachHandlers,
IsWidget {
    int eventsToSink;
    private boolean attached;
    private HandlerManager handlerManager;
    private Object layoutData;
    private Widget parent;

    public static Widget asWidgetOrNull(IsWidget w) {
        return w == null ? null : w.asWidget();
    }

    @Override
    public HandlerRegistration addAttachHandler(AttachEvent.Handler handler) {
        return this.addHandler(handler, AttachEvent.getType());
    }

    public final <H extends EventHandler> HandlerRegistration addBitlessDomHandler(H handler, DomEvent.Type<H> type) {
        assert (handler != null) : "handler must not be null";
        assert (type != null) : "type must not be null";
        this.sinkBitlessEvent(type.getName());
        return this.ensureHandlers().addHandler(type, handler);
    }

    public final <H extends EventHandler> HandlerRegistration addDomHandler(H handler, DomEvent.Type<H> type) {
        assert (handler != null) : "handler must not be null";
        assert (type != null) : "type must not be null";
        int typeInt = Event.getTypeInt(type.getName());
        if (typeInt == -1) {
            this.sinkBitlessEvent(type.getName());
        } else {
            this.sinkEvents(typeInt);
        }
        return this.ensureHandlers().addHandler(type, handler);
    }

    public final <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
        return this.ensureHandlers().addHandler(type, handler);
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        if (this.handlerManager != null) {
            this.handlerManager.fireEvent(event);
        }
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public Widget getParent() {
        return this.parent;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 16: 
            case 32: {
                Element related = (Element)event.getRelatedEventTarget().cast();
                if (related == null || !this.getElement().isOrHasChild(related)) break;
                return;
            }
        }
        DomEvent.fireNativeEvent(event, this, this.getElement());
    }

    public void removeFromParent() {
        if (this.parent == null) {
            if (RootPanel.isInDetachList(this)) {
                RootPanel.detachNow(this);
            }
        } else if (this.parent instanceof HasWidgets) {
            ((HasWidgets)((Object)this.parent)).remove(this);
        } else if (this.parent != null) {
            throw new IllegalStateException("This widget's parent does not implement HasWidgets");
        }
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    @Override
    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            super.sinkEvents(eventBitsToAdd);
        } else {
            this.eventsToSink |= eventBitsToAdd;
        }
    }

    @Override
    public void unsinkEvents(int eventBitsToRemove) {
        if (this.isOrWasAttached()) {
            super.unsinkEvents(eventBitsToRemove);
        } else {
            this.eventsToSink &= ~eventBitsToRemove;
        }
    }

    protected HandlerManager createHandlerManager() {
        return new HandlerManager(this);
    }

    protected void delegateEvent(Widget target, GwtEvent<?> event) {
        target.fireEvent(event);
    }

    protected void doAttachChildren() {
    }

    protected void doDetachChildren() {
    }

    protected int getHandlerCount(GwtEvent.Type<?> type) {
        return this.handlerManager == null ? 0 : this.handlerManager.getHandlerCount(type);
    }

    protected final boolean isOrWasAttached() {
        return this.eventsToSink == -1;
    }

    protected void onAttach() {
        if (this.isAttached()) {
            throw new IllegalStateException("Should only call onAttach when the widget is detached from the browser's document");
        }
        this.attached = true;
        DOM.setEventListener(this.getElement(), this);
        int bitsToAdd = this.eventsToSink;
        this.eventsToSink = -1;
        if (bitsToAdd > 0) {
            this.sinkEvents(bitsToAdd);
        }
        this.doAttachChildren();
        this.onLoad();
        AttachEvent.fire(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetach() {
        if (!this.isAttached()) {
            throw new IllegalStateException("Should only call onDetach when the widget is attached to the browser's document");
        }
        try {
            this.onUnload();
            AttachEvent.fire(this, false);
        }
        finally {
            try {
                this.doDetachChildren();
            }
            finally {
                DOM.setEventListener(this.getElement(), null);
                this.attached = false;
            }
        }
    }

    protected void onLoad() {
    }

    protected void onUnload() {
    }

    HandlerManager ensureHandlers() {
        return this.handlerManager == null ? (this.handlerManager = this.createHandlerManager()) : this.handlerManager;
    }

    HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    @Override
    void replaceElement(Element elem) {
        if (this.isAttached()) {
            DOM.setEventListener(this.getElement(), null);
        }
        super.replaceElement(elem);
        if (this.isAttached()) {
            DOM.setEventListener(this.getElement(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setParent(Widget parent) {
        Widget oldParent = this.parent;
        if (parent == null) {
            try {
                if (oldParent == null || !oldParent.isAttached()) return;
                this.onDetach();
                assert (!this.isAttached()) : "Failure of " + this.getClass().getName() + " to call super.onDetach()";
                return;
            }
            finally {
                this.parent = null;
            }
        } else {
            if (oldParent != null) {
                throw new IllegalStateException("Cannot set a new parent without first clearing the old parent");
            }
            this.parent = parent;
            if (!parent.isAttached()) return;
            this.onAttach();
            assert (this.isAttached()) : "Failure of " + this.getClass().getName() + " to call super.onAttach()";
            return;
        }
    }
}

