/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.logging.impl.LoggerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerImplRegular
implements LoggerImpl {
    private List<Handler> handlers = new ArrayList<Handler>();
    private Level level = null;
    private String name;
    private Logger parent;
    private boolean useParentHandlers = true;

    @Override
    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    @Override
    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    @Override
    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    @Override
    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Logger getParent() {
        return this.parent;
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public boolean isLoggable(Level messageLevel) {
        return this.getEffectiveLevel().intValue() <= messageLevel.intValue();
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord record = new LogRecord(level, msg);
            record.setThrown(thrown);
            record.setLoggerName(this.getName());
            this.log(record);
        }
    }

    @Override
    public void log(LogRecord record) {
        if (this.isLoggable(record.getLevel())) {
            Logger logger;
            for (Handler handler : this.getHandlers()) {
                handler.publish(record);
            }
            Logger logger2 = logger = this.getUseParentHandlers() ? this.getParent() : null;
            while (logger != null) {
                for (Handler handler : logger.getHandlers()) {
                    handler.publish(record);
                }
                logger = logger.getUseParentHandlers() ? logger.getParent() : null;
            }
        }
    }

    @Override
    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public void setLevel(Level newLevel) {
        this.level = newLevel;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void setParent(Logger newParent) {
        if (newParent != null) {
            this.parent = newParent;
        }
    }

    @Override
    public void setUseParentHandlers(boolean newUseParentHandlers) {
        this.useParentHandlers = newUseParentHandlers;
    }

    @Override
    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    private Level getEffectiveLevel() {
        if (this.level != null) {
            return this.level;
        }
        for (Logger logger = this.getParent(); logger != null; logger = logger.getParent()) {
            Level effectiveLevel = logger.getLevel();
            if (effectiveLevel == null) continue;
            return effectiveLevel;
        }
        return Level.INFO;
    }
}

