/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.shared.impl.JsLogger;

public class SuperDevModeLogger
extends JsLogger {
    @Override
    public void log(String message, Throwable t) {
        if (!this.consoleLogEnabled()) {
            return;
        }
        this.log(message);
        if (t != null) {
            String out = this.makeSimpleStackTrace(t);
            if (this.consoleErrorEnabled()) {
                this.error(out);
            } else {
                this.log(out);
            }
        }
    }

    private String makeSimpleStackTrace(Throwable first) {
        StringBuilder out = new StringBuilder();
        for (Throwable t = first; t != null; t = t.getCause()) {
            if (t == first) {
                out.append(t.toString() + "\n");
            } else {
                out.append("Caused by: " + t.toString() + "\n");
            }
            for (StackTraceElement element : t.getStackTrace()) {
                out.append("  at " + element.getMethodName() + "\n");
            }
        }
        return out.toString();
    }

    private native boolean consoleLogEnabled();

    private native boolean consoleErrorEnabled();

    private native void log(String var1);

    private native void error(String var1);
}

