/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapPutIfAbsentTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutIfAbsent_supportedAbsent() {
        MapPutIfAbsentTester.assertNull("putIfAbsent(notPresent, value) should return null", this.getMap().putIfAbsent(this.k3(), this.v3()));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutIfAbsent_supportedPresent() {
        MapPutIfAbsentTester.assertEquals((String)"putIfAbsent(present, value) should return existing value", this.v0(), this.getMap().putIfAbsent(this.k0(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutIfAbsent_unsupportedAbsent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().putIfAbsent(this.k3(), this.v3()));
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.e3());
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutIfAbsent_unsupportedPresentExistingValue() {
        try {
            MapPutIfAbsentTester.assertEquals((String)"putIfAbsent(present, existingValue) should return present or throw", this.v0(), this.getMap().putIfAbsent(this.k0(), this.v0()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutIfAbsent_unsupportedPresentDifferentValue() {
        try {
            this.getMap().putIfAbsent(this.k0(), this.v3());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutIfAbsent_nullKeyUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().putIfAbsent(null, this.v3()));
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported putIfAbsent(null, value)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutIfAbsent_nullValueUnsupportedAndKeyAbsent() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().putIfAbsent(this.k3(), null));
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null value after unsupported putIfAbsent(key, null)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutIfAbsent_nullValueUnsupportedAndKeyPresent() {
        try {
            this.getMap().putIfAbsent(this.k0(), null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null after unsupported putIfAbsent(present, null)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPut_nullValueSupported() {
        Map.Entry nullValueEntry = this.entry(this.k3(), null);
        MapPutIfAbsentTester.assertNull("putIfAbsent(key, null) should return null", this.getMap().putIfAbsent(nullValueEntry.getKey(), nullValueEntry.getValue()));
        this.expectAdded(nullValueEntry);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutIfAbsent_replacesNullValue() {
        this.initMapWithNullValue();
        MapPutIfAbsentTester.assertNull("putIfAbsent(existingKeyWithNullValue, value) should return null", this.getMap().putIfAbsent(this.getKeyForNullValue(), this.v3()));
        MapPutIfAbsentTester.assertEquals((String)"Map should now contain the new value", this.v3(), this.getMap().get(this.getKeyForNullValue()));
    }
}

