/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import com.google.common.collect.testing.testers.TestExceptions;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapMergeTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testAbsent() {
        MapMergeTester.assertEquals((String)"Map.merge(absent, value, function) should return value", this.v3(), (Object)this.getMap().merge(this.k3(), this.v3(), (oldV, newV) -> {
            throw new AssertionFailedError("Should not call merge function if key was absent");
        }));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testMappedToNull() {
        this.initMapWithNullValue();
        MapMergeTester.assertEquals((String)"Map.merge(keyMappedToNull, value, function) should return value", this.v3(), (Object)this.getMap().merge(this.getKeyForNullValue(), this.v3(), (oldV, newV) -> {
            throw new AssertionFailedError("Should not call merge function if key was mapped to null");
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testMergeAbsentNullKey() {
        MapMergeTester.assertEquals((String)"Map.merge(null, value, function) should return value", this.v3(), (Object)this.getMap().merge(null, this.v3(), (oldV, newV) -> {
            throw new AssertionFailedError("Should not call merge function if key was absent");
        }));
        this.expectAdded(this.entry(null, this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testMergePresent() {
        MapMergeTester.assertEquals((String)"Map.merge(present, value, function) should return function result", this.v4(), (Object)this.getMap().merge(this.k0(), this.v3(), (oldV, newV) -> {
            MapMergeTester.assertEquals(this.v0(), (Object)oldV);
            MapMergeTester.assertEquals(this.v3(), (Object)newV);
            return this.v4();
        }));
        this.expectReplacement(this.entry(this.k0(), this.v4()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testMergeFunctionThrows() {
        ReflectionFreeAssertThrows.assertThrows(TestExceptions.SomeUncheckedException.class, () -> this.getMap().merge(this.k0(), this.v3(), (oldV, newV) -> {
            MapMergeTester.assertEquals(this.v0(), (Object)oldV);
            MapMergeTester.assertEquals(this.v3(), (Object)newV);
            throw new TestExceptions.SomeUncheckedException();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testMergePresentToNull() {
        MapMergeTester.assertNull("Map.merge(present, value, functionReturningNull) should return null", this.getMap().merge(this.k0(), this.v3(), (oldV, newV) -> {
            MapMergeTester.assertEquals(this.v0(), (Object)oldV);
            MapMergeTester.assertEquals(this.v3(), (Object)newV);
            return null;
        }));
        this.expectMissing((Map.Entry)this.e0());
    }

    public void testMergeNullValue() {
        try {
            this.getMap().merge(this.k0(), null, (oldV, newV) -> {
                throw new AssertionFailedError("Should not call merge function if value was null");
            });
            MapMergeTester.fail((String)"Expected NullPointerException or UnsupportedOperationException");
        }
        catch (NullPointerException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    public void testMergeNullFunction() {
        try {
            this.getMap().merge(this.k0(), this.v3(), null);
            MapMergeTester.fail((String)"Expected NullPointerException or UnsupportedOperationException");
        }
        catch (NullPointerException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testMergeUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().merge(this.k3(), this.v3(), (oldV, newV) -> {
            throw new AssertionFailedError();
        }));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getMergeNullValueMethod() {
        return Helpers.getMethod(MapMergeTester.class, "testMergeNullValue");
    }
}

