/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@GwtCompatible(emulated=true)
public class Helpers {
    static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <E> List<E> copyToList(Iterable<? extends E> elements) {
        ArrayList list = new ArrayList();
        Helpers.addAll(list, elements);
        return list;
    }

    public static <E> List<E> copyToList(E[] elements) {
        return Helpers.copyToList(Arrays.asList(elements));
    }

    public static <E> Set<E> copyToSet(Iterable<? extends E> elements) {
        LinkedHashSet set = new LinkedHashSet();
        Helpers.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> copyToSet(E[] elements) {
        return Helpers.copyToSet(Arrays.asList(elements));
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    private static boolean isEmpty(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).isEmpty() : !iterable.iterator().hasNext();
    }

    public static void assertEmpty(Iterable<?> iterable) {
        if (!Helpers.isEmpty(iterable)) {
            Assert.fail((String)("Not true that " + iterable + " is empty"));
        }
    }

    public static void assertEmpty(Map<?, ?> map) {
        if (!map.isEmpty()) {
            Assert.fail((String)("Not true that " + map + " is empty"));
        }
    }

    public static void assertEqualInOrder(Iterable<?> expected, Iterable<?> actual) {
        Iterator<?> expectedIter = expected.iterator();
        Iterator<?> actualIter = actual.iterator();
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            if (Helpers.equal(expectedIter.next(), actualIter.next())) continue;
            Assert.fail((String)("contents were not equal and in the same order: expected = " + expected + ", actual = " + actual));
        }
        if (expectedIter.hasNext() || actualIter.hasNext()) {
            Assert.fail((String)("contents were not equal and in the same order: expected = " + expected + ", actual = " + actual));
        }
    }

    public static void assertContentsInOrder(Iterable<?> actual, Object ... expected) {
        Helpers.assertEqualInOrder(Arrays.asList(expected), actual);
    }

    public static void assertEqualIgnoringOrder(Iterable<?> expected, Iterable<?> actual) {
        List<?> exp = Helpers.copyToList(expected);
        List<?> act = Helpers.copyToList(actual);
        String actString = act.toString();
        for (Object object : exp) {
            if (act.remove(object)) continue;
            Assert.fail((String)("did not contain expected element " + object + ", expected = " + exp + ", actual = " + actString));
        }
        Assert.assertTrue((String)("unexpected elements: " + act), (boolean)act.isEmpty());
    }

    public static void assertContentsAnyOrder(Iterable<?> actual, Object ... expected) {
        Helpers.assertEqualIgnoringOrder(Arrays.asList(expected), actual);
    }

    public static void assertContains(Iterable<?> actual, Object expected) {
        boolean contained = false;
        if (actual instanceof Collection) {
            contained = ((Collection)actual).contains(expected);
        } else {
            for (Object o : actual) {
                if (!Helpers.equal(o, expected)) continue;
                contained = true;
                break;
            }
        }
        if (!contained) {
            Assert.fail((String)("Not true that " + actual + " contains " + expected));
        }
    }

    public static void assertContainsAllOf(Iterable<?> actual, Object ... expected) {
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expected));
        for (Object o : actual) {
            expectedList.remove(o);
        }
        if (!expectedList.isEmpty()) {
            Assert.fail((String)("Not true that " + actual + " contains all of " + Arrays.asList(expected)));
        }
    }

    @CanIgnoreReturnValue
    public static <E> boolean addAll(Collection<E> addTo, Iterable<? extends E> elementsToAdd) {
        boolean modified = false;
        for (E e : elementsToAdd) {
            modified |= addTo.add(e);
        }
        return modified;
    }

    static <T> Iterable<T> reverse(final List<T> list) {
        return () -> new Iterator<T>(){
            private final ListIterator<T> listIter;
            {
                this.listIter = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.listIter.hasPrevious();
            }

            @Override
            public T next() {
                return this.listIter.previous();
            }

            @Override
            public void remove() {
                this.listIter.remove();
            }
        };
    }

    static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = Collections.emptySet().iterator();

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <T> T get(Iterator<T> iterator, int position) {
        for (int i = 0; i < position; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static <K, V> Comparator<Map.Entry<K, V>> entryComparator(@Nullable Comparator<? super K> keyComparator) {
        return new EntryComparator(keyComparator);
    }

    public static <T> void testComparator(Comparator<? super T> comparator, T ... valuesInExpectedOrder) {
        Helpers.testComparator(comparator, Arrays.asList(valuesInExpectedOrder));
    }

    public static <T> void testComparator(Comparator<? super T> comparator, List<T> valuesInExpectedOrder) {
        for (int i = 0; i < valuesInExpectedOrder.size(); ++i) {
            int j;
            T t = valuesInExpectedOrder.get(i);
            for (j = 0; j < i; ++j) {
                T lesser = valuesInExpectedOrder.get(j);
                Assert.assertTrue((String)(comparator + ".compare(" + lesser + ", " + t + ")"), (comparator.compare(lesser, t) < 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((String)(comparator + ".compare(" + t + ", " + t + ")"), (int)0, (int)comparator.compare(t, t));
            for (j = i + 1; j < valuesInExpectedOrder.size(); ++j) {
                T greater = valuesInExpectedOrder.get(j);
                Assert.assertTrue((String)(comparator + ".compare(" + greater + ", " + t + ")"), (comparator.compare(greater, t) > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static <T extends Comparable<? super T>> void testCompareToAndEquals(List<T> valuesInExpectedOrder) {
        for (int i = 0; i < valuesInExpectedOrder.size(); ++i) {
            int j;
            Comparable t = (Comparable)valuesInExpectedOrder.get(i);
            for (j = 0; j < i; ++j) {
                Comparable lesser = (Comparable)valuesInExpectedOrder.get(j);
                Assert.assertTrue((String)(lesser + ".compareTo(" + t + ')'), (lesser.compareTo(t) < 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)lesser.equals(t));
            }
            Assert.assertEquals((String)(t + ".compareTo(" + t + ')'), (int)0, (int)t.compareTo(t));
            Assert.assertTrue((boolean)t.equals(t));
            for (j = i + 1; j < valuesInExpectedOrder.size(); ++j) {
                Comparable greater = (Comparable)valuesInExpectedOrder.get(j);
                Assert.assertTrue((String)(greater + ".compareTo(" + t + ')'), (greater.compareTo(t) > 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)greater.equals(t));
            }
        }
    }

    public static <T> Collection<T> misleadingSizeCollection(final int delta) {
        return new AbstractList<T>(){
            ArrayList<T> data = new ArrayList();

            @Override
            public int size() {
                return Math.max(0, this.data.size() + delta);
            }

            @Override
            public T get(int index) {
                return this.data.get(index);
            }

            @Override
            public T set(int index, T element) {
                return this.data.set(index, element);
            }

            @Override
            public boolean add(T element) {
                return this.data.add(element);
            }

            @Override
            public void add(int index, T element) {
                this.data.add(index, element);
            }

            @Override
            public T remove(int index) {
                return this.data.remove(index);
            }

            @Override
            public @Nullable Object[] toArray() {
                return this.data.toArray();
            }
        };
    }

    public static <K, V> Map.Entry<K, V> nefariousMapEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(@Nullable Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    e.setValue(value);
                    return Helpers.equal(this.getKey(), e.getKey()) && Helpers.equal(this.getValue(), e.getValue());
                }
                return false;
            }

            @Override
            public int hashCode() {
                Object k = this.getKey();
                Object v = this.getValue();
                return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        };
    }

    static <E> List<E> castOrCopyToList(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E e : iterable) {
            list.add(e);
        }
        return list;
    }

    public static <K extends Comparable, V> Iterable<Map.Entry<K, V>> orderEntriesByKey(List<Map.Entry<K, V>> insertionOrder) {
        Comparator keyComparator = Comparable::compareTo;
        Collections.sort(insertionOrder, Helpers.entryComparator(keyComparator));
        return insertionOrder;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class EntryComparator<K, V>
    implements Comparator<Map.Entry<K, V>> {
        final @Nullable Comparator<? super K> keyComparator;

        public EntryComparator(@Nullable Comparator<? super K> keyComparator) {
            this.keyComparator = keyComparator;
        }

        @Override
        public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
            return this.keyComparator == null ? ((Comparable)a.getKey()).compareTo(b.getKey()) : this.keyComparator.compare(a.getKey(), b.getKey());
        }
    }

    public static final class NullsBeforeTwo
    extends NullsBefore {
        public static final NullsBeforeTwo INSTANCE = new NullsBeforeTwo();

        private NullsBeforeTwo() {
            super("two");
        }
    }

    public static final class NullsBeforeB
    extends NullsBefore {
        public static final NullsBeforeB INSTANCE = new NullsBeforeB();

        private NullsBeforeB() {
            super("b");
        }
    }

    public static abstract class NullsBefore
    implements Comparator<String>,
    Serializable {
        @GwtTransient
        private final String justAfterNull;

        protected NullsBefore(String justAfterNull) {
            if (justAfterNull == null) {
                throw new NullPointerException();
            }
            this.justAfterNull = justAfterNull;
        }

        @Override
        public int compare(@Nullable String lhs, @Nullable String rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                if (rhs.equals(this.justAfterNull)) {
                    return -1;
                }
                return this.justAfterNull.compareTo(rhs);
            }
            if (rhs == null) {
                if (lhs.equals(this.justAfterNull)) {
                    return 1;
                }
                return lhs.compareTo(this.justAfterNull);
            }
            return lhs.compareTo(rhs);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof NullsBefore) {
                NullsBefore other = (NullsBefore)obj;
                return this.justAfterNull.equals(other.justAfterNull);
            }
            return false;
        }

        public int hashCode() {
            return this.justAfterNull.hashCode();
        }
    }

    private static @interface GwtTransient {
    }
}

